/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FeedMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;

public abstract class N2NFeedMessage
extends FeedMessage {
    protected final String sourceNodeName;
    protected final long composed;
    protected final long sent;
    protected final long received;

    public N2NFeedMessage(String header, String shortText, String text, short priorityClass, long updatedTime, String sourceNodeName, long composed, long sent, long received) {
        super(header, shortText, text, priorityClass, updatedTime);
        this.sourceNodeName = sourceNodeName;
        this.composed = composed;
        this.sent = sent;
        this.received = received;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = super.getFieldSet();
        fs.putSingle("SourceNodeName", this.sourceNodeName);
        if (this.composed != -1L) {
            fs.put("TimeComposed", this.composed);
        }
        if (this.sent != -1L) {
            fs.put("TimeSent", this.sent);
        }
        if (this.received != -1L) {
            fs.put("TimeReceived", this.received);
        }
        return fs;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, this.getName() + " goes from server to client not the other way around", null, false);
    }
}

