/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.clients.fcp.DirectDirPutFile;
import freenet.clients.fcp.DiskDirPutFile;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.RedirectDirPutFile;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.BucketFactory;
import freenet.support.api.ManifestElement;
import freenet.support.api.RandomAccessBucket;

abstract class DirPutFile {
    final String name;
    ClientMetadata meta;
    private static volatile boolean logMINOR;

    protected DirPutFile(String name, String mimeType) {
        this.name = name;
        this.meta = new ClientMetadata(mimeType);
    }

    protected static String guessMIME(String name) {
        return DefaultMIMETypes.guessMIMEType(name, true);
    }

    public static DirPutFile create(SimpleFieldSet subset, String identifier, boolean global, BucketFactory bf) throws MessageInvalidException {
        String name = subset.get("Name");
        if (name == null) {
            throw new MessageInvalidException(5, "Missing field Name", identifier, global);
        }
        String contentTypeOverride = subset.get("Metadata.ContentType");
        if (contentTypeOverride != null && !contentTypeOverride.equals("") && !DefaultMIMETypes.isPlausibleMIMEType(contentTypeOverride)) {
            throw new MessageInvalidException(35, "Bad MIME type in Metadata.ContentType", identifier, global);
        }
        String type = subset.get("UploadFrom");
        if (type == null || type.equalsIgnoreCase("direct")) {
            return DirectDirPutFile.create(name, contentTypeOverride, subset, identifier, global, bf);
        }
        if (type.equalsIgnoreCase("disk")) {
            return DiskDirPutFile.create(name, contentTypeOverride, subset, identifier, global);
        }
        if (type.equalsIgnoreCase("redirect")) {
            return RedirectDirPutFile.create(name, contentTypeOverride, subset, identifier, global);
        }
        throw new MessageInvalidException(8, "Unsupported or unknown UploadFrom: " + type, identifier, global);
    }

    public String getName() {
        return this.name;
    }

    public String getMIMEType() {
        return this.meta.getMIMEType();
    }

    public abstract RandomAccessBucket getData();

    public ManifestElement getElement() {
        String n = this.name;
        int idx = n.lastIndexOf(47);
        if (idx != -1) {
            n = n.substring(idx + 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Element name: " + this.name + " -> " + n);
        }
        return new ManifestElement(n, this.getData(), this.getMIMEType(), this.getData().size());
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

