/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CSSParser;
import freenet.client.filter.CharsetExtractor;
import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.FilterUtils;
import freenet.client.filter.NullFilterCallback;
import freenet.client.filter.UnknownCharsetException;
import freenet.client.filter.UnsupportedCharsetInFilterException;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.Closer;
import freenet.support.io.NullWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;

public class CSSReadFilter
implements ContentDataFilter,
CharsetExtractor {
    private static volatile boolean logDEBUG;
    private static volatile boolean logMINOR;
    static final byte[] ascii;
    static final byte[] utf16be;
    static final byte[] utf16le;
    static final byte[] utf32_le;
    static final byte[] utf32_be;
    static final byte[] ebcdic;
    static final byte[] ibm1026;
    static final byte[] utf32_2143;
    static final byte[] utf32_3412;
    static final byte[] gsm;
    static final int maxBOMLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        if (logDEBUG) {
            Logger.debug(this, "running " + this + "with charset" + charset);
        }
        BufferedReader r = null;
        Writer w = null;
        try {
            try {
                InputStreamReader isr = new InputStreamReader(input, charset);
                OutputStreamWriter osw = new OutputStreamWriter(output, charset);
                r = new BufferedReader(isr, 32768);
                w = new BufferedWriter(osw, 32768);
            }
            catch (UnsupportedEncodingException e) {
                throw UnknownCharsetException.create(e, charset);
            }
            CSSParser parser = new CSSParser(r, w, false, cb, charset, false, false);
            parser.parse();
        }
        finally {
            w.flush();
        }
    }

    @Override
    public void writeFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCharset(byte[] input, int length, String charset) throws DataFilterException, IOException {
        String string;
        if (logDEBUG) {
            Logger.debug(this, "Fetching charset for CSS with initial charset " + charset);
        }
        if (input.length > this.getCharsetBufferSize() && logMINOR) {
            Logger.minor(this, "More data than was strictly needed was passed to the charset extractor for extraction");
        }
        ByteArrayInputStream strm = new ByteArrayInputStream(input, 0, length);
        NullWriter w = new NullWriter();
        BufferedReader r = null;
        try {
            try {
                InputStreamReader isr = new InputStreamReader((InputStream)strm, charset);
                r = new BufferedReader(isr, 32768);
            }
            catch (UnsupportedEncodingException e) {
                throw UnknownCharsetException.create(e, charset);
            }
            CSSParser parser = new CSSParser(r, w, false, new NullFilterCallback(), null, true, false);
            parser.parse();
            r.close();
            r = null;
            string = parser.detectedCharset();
        }
        catch (Throwable throwable) {
            Closer.close(strm);
            Closer.close(r);
            Closer.close(w);
            throw throwable;
        }
        Closer.close(strm);
        Closer.close(r);
        Closer.close(w);
        return string;
    }

    static byte[] parse(String s) {
        s = s.replaceAll(" ", "");
        return HexUtil.hexToBytes(s);
    }

    @Override
    public CharsetExtractor.BOMDetection getCharsetByBOM(byte[] input, int length) throws DataFilterException, IOException {
        if (ContentFilter.startsWith(input, ascii, length)) {
            return new CharsetExtractor.BOMDetection("UTF-8", true);
        }
        if (ContentFilter.startsWith(input, utf16be, length)) {
            return new CharsetExtractor.BOMDetection("UTF-16BE", true);
        }
        if (ContentFilter.startsWith(input, utf16le, length)) {
            return new CharsetExtractor.BOMDetection("UTF-16LE", true);
        }
        if (ContentFilter.startsWith(input, utf32_be, length)) {
            return new CharsetExtractor.BOMDetection("UTF-32BE", true);
        }
        if (ContentFilter.startsWith(input, utf32_le, length)) {
            return new CharsetExtractor.BOMDetection("UTF-32LE", true);
        }
        if (ContentFilter.startsWith(input, ebcdic, length)) {
            return new CharsetExtractor.BOMDetection("IBM01140", true);
        }
        if (ContentFilter.startsWith(input, ibm1026, length)) {
            return new CharsetExtractor.BOMDetection("IBM1026", true);
        }
        if (ContentFilter.startsWith(input, utf32_2143, length)) {
            throw new UnsupportedCharsetInFilterException("UTF-32-2143");
        }
        if (ContentFilter.startsWith(input, utf32_3412, length)) {
            throw new UnsupportedCharsetInFilterException("UTF-32-3412");
        }
        if (ContentFilter.startsWith(input, gsm, length)) {
            throw new UnsupportedCharsetInFilterException("GSM 03.38");
        }
        return null;
    }

    public static String filterMediaList(String media) {
        String[] split = media.split(",");
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        for (String m : split) {
            char c;
            int i;
            m = m.trim();
            for (i = 0; !(i >= m.length() || 'a' > (c = m.charAt(i)) || 'z' < c || 'A' <= c && 'Z' >= c || '0' <= c && '9' >= c || c == '-'); ++i) {
            }
            if (!FilterUtils.isMedia(m = m.substring(0, i))) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(m);
            first = false;
        }
        if (sb.length() != 0) {
            return sb.toString();
        }
        return null;
    }

    @Override
    public int getCharsetBufferSize() {
        return 64;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        ascii = CSSReadFilter.parse("40 63 68 61 72 73 65 74 20 22");
        utf16be = CSSReadFilter.parse("00 40 00 63 00 68 00 61 00 72 00 73 00 65 00 74 00 20 00 22");
        utf16le = CSSReadFilter.parse("40 00 63 00 68 00 61 00 72 00 73 00 65 00 74 00 20 00 22 00");
        utf32_le = CSSReadFilter.parse("40 00 00 00 63 00 00 00 68 00 00 00 61 00 00 00 72 00 00 00 73 00 00 00 65 00 00 00 74 00 00 00 20 00 00 00 22 00 00 00");
        utf32_be = CSSReadFilter.parse("00 00 00 40 00 00 00 63 00 00 00 68 00 00 00 61 00 00 00 72 00 00 00 73 00 00 00 65 00 00 00 74 00 00 00 20 00 00 00 22");
        ebcdic = CSSReadFilter.parse("7C 83 88 81 99 A2 85 A3 40 7F");
        ibm1026 = CSSReadFilter.parse("AE 83 88 81 99 A2 85 A3 40 FC");
        utf32_2143 = CSSReadFilter.parse("00 00 40 00 00 00 63 00 00 00 68 00 00 00 61 00 00 00 72 00 00 00 73 00 00 00 65 00 00 00 74 00 00 00 20 00 00 00 22 00");
        utf32_3412 = CSSReadFilter.parse("00 40 00 00 00 63 00 00 00 68 00 00 00 61 00 00 00 72 00 00 00 73 00 00 00 65 00 00 00 74 00 00 00 20 00 00 00 22 00 00");
        gsm = CSSReadFilter.parse("00 63 68 61 72 73 65 74 20 22");
        maxBOMLength = Math.max(utf16be.length, Math.max(utf16le.length, Math.max(utf32_le.length, Math.max(utf32_be.length, Math.max(ebcdic.length, Math.max(ibm1026.length, Math.max(utf32_2143.length, Math.max(utf32_3412.length, gsm.length))))))));
    }
}

