/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientBaseCallback;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutState;
import freenet.client.async.ClientRequestSchedulerGroup;
import freenet.client.async.ContainerInserter;
import freenet.client.async.ManifestPutter;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleFileInserter;
import freenet.client.async.TooManyFilesInsertException;
import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.ManifestElement;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.ResumeFailedException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class BaseManifestPutter
extends ManifestPutter {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private static final String[] defaultDefaultNames;
    private boolean containerMode = false;
    private boolean freeformMode = false;
    private HashSet<PutHandler> putHandlerWaitingForBlockSets;
    private HashSet<PutHandler> putHandlersWaitingForFetchable;
    private HashSet<PutHandler> runningPutHandlers;
    private ContainerBuilder rootContainerBuilder;
    private ContainerPutHandler rootContainerPutHandler;
    private HashSet<PutHandler> containerPutHandlers;
    private HashMap<PutHandler, HashSet<PutHandler>> perContainerPutHandlersWaitingForMetadata;
    private HashMap<PutHandler, HashMap<String, Object>> putHandlersTransformMap;
    private HashMap<ArchivePutHandler, ArrayList<PutHandler>> putHandlersArchiveTransformMap;
    private FreeFormBuilder rootBuilder;
    private MetaPutHandler rootMetaPutHandler;
    private HashMap<String, Object> rootDir;
    private HashSet<PutHandler> putHandlersWaitingForMetadata;
    private FreenetURI finalURI;
    private final FreenetURI targetURI;
    private boolean finished;
    private final InsertContext ctx;
    final ClientPutCallback cb;
    private int numberOfFiles;
    private long totalSize;
    private Metadata baseMetadata;
    private boolean hasResolvedBase;
    private boolean fetchable;
    final byte[] forceCryptoKey;
    final byte cryptoAlgorithm;
    protected int minSuccessFetchBlocks;

    public BaseManifestPutter(ClientPutCallback cb, HashMap<String, Object> manifestElements, short prioClass, FreenetURI target, String defaultName, InsertContext ctx, boolean randomiseCryptoKeys, byte[] forceCryptoKey, ClientContext context) throws TooManyFilesInsertException {
        super(prioClass, cb);
        this.targetURI = target;
        this.cb = cb;
        this.ctx = ctx;
        if (randomiseCryptoKeys && forceCryptoKey == null) {
            forceCryptoKey = new byte[32];
            context.random.nextBytes(forceCryptoKey);
        }
        this.forceCryptoKey = forceCryptoKey;
        InsertContext.CompatibilityMode mode = ctx.getCompatibilityMode();
        this.cryptoAlgorithm = mode != InsertContext.CompatibilityMode.COMPAT_CURRENT && mode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1416.ordinal() ? (byte)2 : (byte)3;
        this.runningPutHandlers = new HashSet();
        this.putHandlersWaitingForMetadata = new HashSet();
        this.putHandlersWaitingForFetchable = new HashSet();
        this.putHandlerWaitingForBlockSets = new HashSet();
        this.containerPutHandlers = new HashSet();
        this.perContainerPutHandlersWaitingForMetadata = new HashMap();
        this.putHandlersTransformMap = new HashMap();
        this.putHandlersArchiveTransformMap = new HashMap();
        if (defaultName == null) {
            defaultName = this.findDefaultName(manifestElements);
        }
        this.makePutHandlers(manifestElements, defaultName);
        this.rootBuilder = null;
        this.rootContainerBuilder = null;
    }

    private String findDefaultName(HashMap<String, Object> manifestElements) {
        for (String name : defaultDefaultNames) {
            Object o = manifestElements.get(name);
            if (o == null || o instanceof HashMap) continue;
            return name;
        }
        for (String name : defaultDefaultNames) {
            boolean found = false;
            for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
                Object o = entry.getValue();
                if (o == null || o instanceof HashMap || !entry.getKey().equalsIgnoreCase(name)) continue;
                found = true;
                name = entry.getKey();
                break;
            }
            if (!found) continue;
            return name;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ClientContext context) throws InsertException {
        PutHandler[] containers;
        PutHandler[] running;
        if (logMINOR) {
            Logger.minor(this, "Starting " + this + " persistence=" + this.persistent() + " containermode=" + this.containerMode);
        }
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            running = this.runningPutHandlers.toArray(new PutHandler[this.runningPutHandlers.size()]);
            containers = this.containerMode ? this.getContainersToStart(running.length > 0) : null;
        }
        try {
            int i;
            for (i = 0; i < running.length; ++i) {
                running[i].start(context);
                if (logMINOR) {
                    Logger.minor(this, "Started " + i + " of " + running.length);
                }
                if (!this.isFinished()) continue;
                if (logMINOR) {
                    Logger.minor(this, "Already finished, killing start() on " + this);
                }
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Started " + running.length + " PutHandler's for " + this);
            }
            if (this.containerMode) {
                for (i = 0; i < containers.length; ++i) {
                    containers[i].start(context);
                    if (logMINOR) {
                        Logger.minor(this, "Started " + i + " of " + containers.length);
                    }
                    if (!this.isFinished()) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Already finished, killing start() on " + this);
                    }
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Started " + containers.length + " PutHandler's (containers) for " + this);
                }
            }
            if (!this.containerMode && running.length == 0) {
                this.gotAllMetadata(context);
            }
        }
        catch (InsertException e) {
            BaseManifestPutter baseManifestPutter2 = this;
            synchronized (baseManifestPutter2) {
                this.finished = true;
            }
            this.cancelAndFinish(context);
            throw e;
        }
    }

    private PutHandler[] getContainersToStart(boolean excludeRoot) {
        PutHandler[] maybeStartPH = this.containerPutHandlers.toArray(new PutHandler[this.containerPutHandlers.size()]);
        ArrayList<PutHandler> phToStart = new ArrayList<PutHandler>();
        for (PutHandler ph : maybeStartPH) {
            if (!this.perContainerPutHandlersWaitingForMetadata.get(ph).isEmpty()) continue;
            phToStart.add(ph);
        }
        if (!excludeRoot && maybeStartPH.length == 0) {
            phToStart.add(this.rootContainerPutHandler);
        }
        return phToStart.toArray(new PutHandler[phToStart.size()]);
    }

    protected abstract void makePutHandlers(HashMap<String, Object> var1, String var2) throws TooManyFilesInsertException;

    @Override
    public FreenetURI getURI() {
        return this.finalURI;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished || this.cancelled;
    }

    @Override
    public byte[] getSplitfileCryptoKey() {
        return this.forceCryptoKey;
    }

    private void gotAllMetadata(ClientContext context) {
        if (this.containerMode) {
            throw new IllegalStateException();
        }
        if (logMINOR) {
            Logger.minor(this, "Got all metadata");
        }
        this.baseMetadata = this.makeMetadata(this.rootDir);
        context.jobRunner.setCheckpointASAP();
        this.resolveAndStartBase(context);
    }

    private Metadata makeMetadata(HashMap<String, Object> dir) {
        Metadata.SimpleManifestComposer smc = new Metadata.SimpleManifestComposer();
        for (Map.Entry<String, Object> entry : dir.entrySet()) {
            Metadata m;
            String name = entry.getKey();
            Object item = entry.getValue();
            if (item == null) {
                throw new NullPointerException();
            }
            if (item instanceof HashMap) {
                m = this.makeMetadata((HashMap)item);
                if (m == null) {
                    throw new NullPointerException("HERE!!");
                }
            } else {
                m = ((PutHandler)item).metadata;
                if (m == null) {
                    throw new NullPointerException("HERE!!" + item);
                }
            }
            smc.addItem(name, m);
        }
        return smc.getMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveAndStartBase(ClientContext context) {
        RandomAccessBucket bucket = null;
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.hasResolvedBase) {
                return;
            }
        }
        try {
            bucket = this.baseMetadata.toBucket(context.getBucketFactory(this.persistent()));
            if (logMINOR) {
                Logger.minor(this, "Metadata bucket is " + bucket.size() + " bytes long");
            }
        }
        catch (IOException e) {
            this.fail(new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null), context);
            return;
        }
        catch (MetadataUnresolvedException e) {
            try {
                if (logMINOR) {
                    Logger.minor(this, "Main metadata needs resolving: " + e);
                }
                this.resolve(e, context);
                return;
            }
            catch (IOException e1) {
                this.fail(new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null), context);
                return;
            }
            catch (InsertException e2) {
                this.fail(e2, context);
                return;
            }
        }
        if (bucket == null) {
            return;
        }
        BaseManifestPutter e = this;
        synchronized (e) {
            if (this.hasResolvedBase) {
                return;
            }
            this.hasResolvedBase = true;
        }
        InsertBlock block = new InsertBlock(bucket, null, this.targetURI);
        try {
            this.rootMetaPutHandler = new MetaPutHandler(this, null, block);
            if (logMINOR) {
                Logger.minor(this, "Inserting main metadata: " + this.rootMetaPutHandler + " for " + this.baseMetadata);
            }
            this.rootMetaPutHandler.start(context);
        }
        catch (InsertException e2) {
            this.fail(e2, context);
            return;
        }
    }

    private void resolve(MetadataUnresolvedException e, ClientContext context) throws InsertException, IOException {
        Metadata[] metas;
        new Error("RefactorME-resolve").printStackTrace();
        for (Metadata m : metas = e.mustResolve) {
            if (logMINOR) {
                Logger.minor(this, "Resolving " + m);
            }
            if (m.isResolved()) {
                Logger.error(this, "Already resolved: " + m + " in resolve() - race condition???");
                continue;
            }
            try {
                MetaPutHandler ph = new MetaPutHandler(this, null, m, context.getBucketFactory(this.persistent()));
                ph.start(context);
            }
            catch (MetadataUnresolvedException e1) {
                this.resolve(e1, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryComplete(ClientContext context) {
        if (logDEBUG) {
            Logger.debug(this, "try complete", (Throwable)new Error("trace tryComplete()"));
        }
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.finished || this.cancelled) {
                if (logMINOR) {
                    Logger.minor(this, "Already " + (this.finished ? "finished" : "cancelled"));
                }
                return;
            }
            if (!this.runningPutHandlers.isEmpty()) {
                if (logDEBUG) {
                    Logger.debug(this, "Not finished, runningPutHandlers not empty.");
                }
                return;
            }
            if (!this.containerPutHandlers.isEmpty()) {
                if (logDEBUG) {
                    Logger.debug(this, "Not finished, containerPutHandlers not empty.");
                }
                return;
            }
            if (this.containerMode) {
                if (this.rootContainerPutHandler != null) {
                    if (logDEBUG) {
                        Logger.debug(this, "Not finished, rootContainerPutHandler not empty.");
                    }
                    return;
                }
            } else if (this.rootMetaPutHandler != null) {
                if (logDEBUG) {
                    Logger.debug(this, "Not finished, rootMetaPutHandler not empty.");
                }
                return;
            }
            this.finished = true;
        }
        this.complete(context);
    }

    private void complete(ClientContext context) {
        this.cb.onSuccess(this);
    }

    private void fail(Exception e, ClientContext context) {
        InsertException ie = new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, e, null);
        this.fail(ie, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(InsertException e, ClientContext context) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        this.cancelAndFinish(context);
        this.cb.onFailure(e, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAndFinish(ClientContext context) {
        PutHandler[] running;
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            running = this.runningPutHandlers.toArray(new PutHandler[this.runningPutHandlers.size()]);
        }
        if (logMINOR) {
            Logger.minor(this, "PutHandler's to cancel: " + running.length);
        }
        for (PutHandler putter : running) {
            putter.cancel(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ClientContext context) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.finished) {
                return;
            }
            if (super.cancel()) {
                return;
            }
        }
        this.fail(new InsertException(InsertException.InsertExceptionMode.CANCELLED), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlock() {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            ++this.minSuccessFetchBlocks;
        }
        super.addBlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlocks(int num) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            this.minSuccessFetchBlocks += num;
        }
        super.addBlocks(num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMustSucceedBlocks(int blocks) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            this.minSuccessFetchBlocks += blocks;
        }
        super.addMustSucceedBlocks(blocks);
    }

    @Override
    public void addRedundantBlocksInsert(int blocks) {
        super.addMustSucceedBlocks(blocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void innerNotifyClients(ClientContext context) {
        SplitfileProgressEvent e;
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            e = new SplitfileProgressEvent(this.totalBlocks, this.successfulBlocks, this.latestSuccess, this.failedBlocks, this.fatallyFailedBlocks, this.latestFailure, this.minSuccessBlocks, this.minSuccessFetchBlocks, this.blockSetFinalized);
        }
        this.ctx.eventProducer.produceEvent(e, context);
    }

    @Override
    public int getMinSuccessFetchBlocks() {
        return this.minSuccessFetchBlocks;
    }

    @Override
    public void blockSetFinalized(ClientContext context) {
        super.blockSetFinalized(context);
    }

    @Override
    public int countFiles() {
        return this.numberOfFiles;
    }

    @Override
    public long totalSize() {
        return this.totalSize;
    }

    protected void onFetchable(PutHandler handler) {
        if (this.checkFetchable(handler)) {
            this.cb.onFetchable(this);
        }
    }

    private synchronized boolean checkFetchable(PutHandler handler) {
        if (!this.putHandlersWaitingForFetchable.remove(handler)) {
            throw new IllegalStateException("was not in putHandlersWaitingForFetchable! : " + handler);
        }
        if (this.fetchable) {
            return false;
        }
        if (!this.putHandlersWaitingForFetchable.isEmpty()) {
            return false;
        }
        this.fetchable = true;
        return true;
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ClientContext context) {
    }

    @Override
    public void onTransition(ClientPutState from, ClientPutState to, ClientContext context) {
        Logger.error(this, "Ignoring transition from " + from + " to " + to + " on " + this);
    }

    @Override
    protected void innerToNetwork(ClientContext context) {
    }

    private void tryStartParentContainer(PutHandler containerHandle2, ClientContext context) throws InsertException {
        if (containerHandle2 == null) {
            throw new NullPointerException();
        }
        if (this.perContainerPutHandlersWaitingForMetadata.get(containerHandle2).isEmpty()) {
            this.perContainerPutHandlersWaitingForMetadata.remove(containerHandle2);
            containerHandle2.start(context);
        } else if (logMINOR) {
            Logger.minor(this, "(spc) waiting m:" + this.perContainerPutHandlersWaitingForMetadata.get(containerHandle2).size() + " for " + containerHandle2);
        }
    }

    protected final ClientMetadata guessMime(String name, ManifestElement me) {
        return this.guessMime(name, me.mimeOverride);
    }

    protected final ClientMetadata guessMime(String name, String mimetype) {
        String mimeType = mimetype;
        if (mimeType == null && name != null) {
            mimeType = DefaultMIMETypes.guessMIMEType(name, true);
        }
        ClientMetadata cm = mimeType == null || mimeType.equals("application/octet-stream") ? null : new ClientMetadata(mimeType);
        return cm;
    }

    public ContainerBuilder makeArchive() {
        return new ContainerBuilder(false, null, null, true);
    }

    protected ContainerBuilder getRootContainer() {
        if (this.freeformMode) {
            throw new IllegalStateException("Already in freeform mode!");
        }
        if (!this.containerMode) {
            this.containerMode = true;
            this.rootContainerBuilder = new ContainerBuilder(true);
        }
        return this.rootContainerBuilder;
    }

    protected FreeFormBuilder getRootBuilder() {
        if (this.containerMode) {
            throw new IllegalStateException("Already in container mode!");
        }
        if (!this.freeformMode) {
            this.freeformMode = true;
            this.rootBuilder = new FreeFormBuilder();
        }
        return this.rootBuilder;
    }

    @Override
    protected ClientBaseCallback getCallback() {
        return this.cb;
    }

    public static HashMap<String, Object> bucketsByNameToManifestEntries(HashMap<String, Object> bucketsByName) {
        HashMap<String, Object> manifestEntries = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : bucketsByName.entrySet()) {
            String name = entry.getKey();
            Object o = entry.getValue();
            if (o instanceof ManifestElement) {
                manifestEntries.put(name, o);
                continue;
            }
            if (o instanceof Bucket) {
                RandomAccessBucket data = (RandomAccessBucket)o;
                manifestEntries.put(name, new ManifestElement(name, data, null, data.size()));
                continue;
            }
            if (o instanceof HashMap) {
                manifestEntries.put(name, BaseManifestPutter.bucketsByNameToManifestEntries(Metadata.forceMap(o)));
                continue;
            }
            throw new IllegalArgumentException(String.valueOf(o));
        }
        return manifestEntries;
    }

    public static ManifestElement[] flatten(HashMap<String, Object> manifestElements) {
        ArrayList<ManifestElement> v = new ArrayList<ManifestElement>();
        BaseManifestPutter.flatten(manifestElements, v, "");
        return v.toArray(new ManifestElement[v.size()]);
    }

    public static void flatten(HashMap<String, Object> manifestElements, List<ManifestElement> v, String prefix) {
        for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
            String name = entry.getKey();
            String fullName = prefix.length() == 0 ? name : prefix + '/' + name;
            Object o = entry.getValue();
            if (o instanceof HashMap) {
                BaseManifestPutter.flatten(Metadata.forceMap(o), v, fullName);
                continue;
            }
            if (o instanceof ManifestElement) {
                ManifestElement me = (ManifestElement)o;
                v.add(new ManifestElement(me, fullName));
                continue;
            }
            throw new IllegalStateException(String.valueOf(o));
        }
    }

    @Override
    public void onShutdown(ClientContext context) {
        for (PutHandler h : this.runningPutHandlers) {
            h.onShutdown(context);
        }
        if (this.rootContainerPutHandler != null) {
            this.rootContainerPutHandler.onShutdown(context);
        }
        if (this.containerPutHandlers != null) {
            for (PutHandler h : this.containerPutHandlers) {
                h.onShutdown(context);
            }
        }
        if (this.rootMetaPutHandler != null) {
            this.rootMetaPutHandler.onShutdown(context);
        }
    }

    @Override
    protected void innerOnResume(ClientContext context) throws ResumeFailedException {
        super.innerOnResume(context);
        for (PutHandler h : this.runningPutHandlers) {
            h.onResume(context);
        }
        if (this.rootContainerPutHandler != null) {
            this.rootContainerPutHandler.onResume(context);
        }
        if (this.containerPutHandlers != null) {
            for (PutHandler h : this.containerPutHandlers) {
                h.onResume(context);
            }
        }
        if (this.rootMetaPutHandler != null) {
            this.rootMetaPutHandler.onResume(context);
        }
    }

    static {
        Logger.registerClass(BaseManifestPutter.class);
        defaultDefaultNames = new String[]{"index.html", "index.htm", "default.html", "default.htm"};
    }

    protected final class ContainerBuilder
    extends ManifestBuilder {
        private static final long serialVersionUID = 1L;
        private final HashMap<String, Object> _rootDir;
        private final PutHandler selfHandle;

        private ContainerBuilder(boolean isRoot) {
            this(isRoot, null, null, false);
        }

        private ContainerBuilder(PutHandler parent, String name) {
            this(false, parent, name, false);
        }

        private ContainerBuilder(boolean isRoot, PutHandler parent, String name, boolean isArchive) {
            if (!BaseManifestPutter.this.containerMode) {
                throw new IllegalStateException("You can not add containers in free form mode!");
            }
            this._rootDir = new HashMap();
            this.selfHandle = isArchive ? new ArchivePutHandler(BaseManifestPutter.this, parent, name, this._rootDir, isRoot ? BaseManifestPutter.this.targetURI : FreenetURI.EMPTY_CHK_URI) : new ContainerPutHandler(BaseManifestPutter.this, parent, name, this._rootDir, isRoot ? BaseManifestPutter.this.targetURI : FreenetURI.EMPTY_CHK_URI, null, isRoot ? null : BaseManifestPutter.this.containerPutHandlers);
            this.currentDir = this._rootDir;
            if (isRoot) {
                BaseManifestPutter.this.rootContainerPutHandler = (ContainerPutHandler)this.selfHandle;
            } else {
                BaseManifestPutter.this.containerPutHandlers.add(this.selfHandle);
            }
            BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.put(this.selfHandle, new HashSet());
            if (isArchive) {
                BaseManifestPutter.this.putHandlersArchiveTransformMap.put((ArchivePutHandler)this.selfHandle, new ArrayList());
            }
        }

        public ContainerBuilder makeSubContainer(String name) {
            ContainerBuilder subCon = new ContainerBuilder(this.selfHandle, name);
            this.currentDir.put(name, subCon.selfHandle);
            BaseManifestPutter.this.putHandlersTransformMap.put(subCon.selfHandle, this.currentDir);
            ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(this.selfHandle)).add(subCon.selfHandle);
            return subCon;
        }

        public void addItem(String name, String nameInArchive, ManifestElement element, boolean isDefaultDoc) {
            ManifestElement me = new ManifestElement(element, name, nameInArchive);
            this.addItem(name, me, isDefaultDoc);
        }

        public void addItem(String name, ManifestElement element, boolean isDefaultDoc) {
            this.currentDir.put(name, element);
            if (isDefaultDoc) {
                Metadata m = new Metadata(Metadata.DocumentType.SYMBOLIC_SHORTLINK, null, null, name, null);
                this.currentDir.put("", m);
            }
            BaseManifestPutter.this.numberOfFiles++;
            if (element.getData() != null) {
                BaseManifestPutter.this.totalSize += element.getSize();
            }
        }

        @Override
        public void addRedirect(String name, FreenetURI targetUri, ClientMetadata cm, boolean isDefaultDoc) {
            Metadata m = new Metadata(Metadata.DocumentType.SIMPLE_REDIRECT, null, null, targetUri, cm);
            this.currentDir.put(name, m);
            if (isDefaultDoc) {
                this.currentDir.put("", m);
            }
        }

        @Override
        public void addExternal(String name, RandomAccessBucket data, ClientMetadata cm, boolean isDefaultDoc) {
            ExternPutHandler ph = new ExternPutHandler(BaseManifestPutter.this, this.selfHandle, name, data, cm);
            ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(this.selfHandle)).add(ph);
            BaseManifestPutter.this.putHandlersTransformMap.put(ph, this.currentDir);
            if (isDefaultDoc) {
                Metadata m = new Metadata(Metadata.DocumentType.SYMBOLIC_SHORTLINK, null, null, name, null);
                this.currentDir.put("", m);
            }
            BaseManifestPutter.this.numberOfFiles++;
            BaseManifestPutter.this.totalSize += data.size();
        }

        public void addArchiveItem(ContainerBuilder archive, String name, ManifestElement element, boolean isDefaultDoc) {
            assert (element.getData() != null);
            archive.addItem(name, new ManifestElement(element, name, name), false);
            JokerPutHandler ph = new JokerPutHandler(BaseManifestPutter.this, this.selfHandle, name, BaseManifestPutter.this.guessMime(name, element.mimeOverride));
            BaseManifestPutter.this.putHandlersTransformMap.put(ph, this.currentDir);
            ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(this.selfHandle)).add(ph);
            ((ArrayList)BaseManifestPutter.this.putHandlersArchiveTransformMap.get(archive.selfHandle)).add(ph);
            if (isDefaultDoc) {
                Metadata m = new Metadata(Metadata.DocumentType.SYMBOLIC_SHORTLINK, null, null, name, null);
                this.currentDir.put("", m);
            }
            BaseManifestPutter.this.numberOfFiles++;
            if (element.getData() != null) {
                BaseManifestPutter.this.totalSize += element.getSize();
            }
        }
    }

    protected final class FreeFormBuilder
    extends ManifestBuilder {
        private static final long serialVersionUID = 1L;

        protected FreeFormBuilder() {
            BaseManifestPutter.this.rootDir = new HashMap();
            this.currentDir = BaseManifestPutter.this.rootDir;
        }

        @Override
        public void addExternal(String name, RandomAccessBucket data, ClientMetadata cm, boolean isDefaultDoc) {
            PutHandler ph = new ExternPutHandler(BaseManifestPutter.this, null, name, data, cm);
            if (logMINOR) {
                Logger.minor(this, "Inserting separately as PutHandler: " + name + " : " + ph + " persistent=" + ph.persistent());
            }
            BaseManifestPutter.this.numberOfFiles++;
            BaseManifestPutter.this.totalSize += data.size();
            this.currentDir.put(name, ph);
            if (isDefaultDoc) {
                ph = new JokerPutHandler(BaseManifestPutter.this, null, name, name);
                this.currentDir.put("", ph);
            }
        }

        @Override
        public void addRedirect(String name, FreenetURI targetURI2, ClientMetadata cm, boolean isDefaultDoc) {
            JokerPutHandler ph = new JokerPutHandler(BaseManifestPutter.this, name, targetURI2, cm);
            this.currentDir.put(name, ph);
            if (isDefaultDoc) {
                this.currentDir.put("", ph);
            }
        }
    }

    protected abstract class ManifestBuilder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Stack<HashMap<String, Object>> dirStack = new Stack();
        protected HashMap<String, Object> currentDir;

        private ClientMetadata makeClientMetadata(String mime) {
            if (mime == null) {
                return null;
            }
            ClientMetadata cm = new ClientMetadata(mime.trim());
            if (cm.isTrivial()) {
                return null;
            }
            return cm;
        }

        ManifestBuilder() {
        }

        public void pushCurrentDir() {
            this.dirStack.push(this.currentDir);
        }

        public void popCurrentDir() {
            this.currentDir = this.dirStack.pop();
        }

        public void makeSubDirCD(String name) {
            Object dir = this.currentDir.get(name);
            this.currentDir = dir != null ? Metadata.forceMap(dir) : this.makeSubDir(this.currentDir, name);
        }

        private HashMap<String, Object> makeSubDir(HashMap<String, Object> parentDir, String name) {
            if (parentDir.containsKey(name)) {
                throw new IllegalStateException("Item '" + name + "' already exist!");
            }
            HashMap<String, Object> newDir = new HashMap<String, Object>();
            parentDir.put(name, newDir);
            return newDir;
        }

        public final void addElement(String name, ManifestElement element, boolean isDefaultDoc) {
            ClientMetadata cm = this.makeClientMetadata(element.mimeOverride);
            if (element.getData() != null) {
                this.addExternal(name, element.getData(), cm, isDefaultDoc);
                return;
            }
            if (element.targetURI != null) {
                this.addRedirect(name, element.targetURI, cm, isDefaultDoc);
                return;
            }
            throw new IllegalStateException("ME is neither a redirect nor dircet data. " + element);
        }

        public final void addExternal(String name, RandomAccessBucket data, String mimeOverride, boolean isDefaultDoc) {
            assert (data != null);
            ClientMetadata cm = this.makeClientMetadata(mimeOverride);
            this.addExternal(name, data, cm, isDefaultDoc);
        }

        public final void addRedirect(String name, FreenetURI targetUri, String mimeOverride, boolean isDefaultDoc) {
            ClientMetadata cm = this.makeClientMetadata(mimeOverride);
            this.addRedirect(name, targetUri, cm, isDefaultDoc);
        }

        public abstract void addExternal(String var1, RandomAccessBucket var2, ClientMetadata var3, boolean var4);

        public abstract void addRedirect(String var1, FreenetURI var2, ClientMetadata var3, boolean var4);
    }

    abstract class PutHandler
    extends BaseClientPutter
    implements PutCompletionCallback {
        private static final long serialVersionUID = 1L;
        protected ClientPutState origSFI;
        private ClientPutState currentState;
        protected ClientMetadata cm;
        protected Metadata metadata;
        private String targetInArchive;
        protected final String itemName;
        protected final boolean persistent;
        protected final PutHandler parentPutHandler;
        protected int minSuccessFetchBlocks;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PutHandler(BaseManifestPutter bmp, PutHandler parent, String name, ClientMetadata cm, HashSet<PutHandler> runningMap) {
            HashSet hashSet;
            super(bmp.priorityClass, bmp.cb);
            this.persistent = bmp.persistent();
            this.cm = cm;
            this.itemName = name;
            this.metadata = null;
            this.parentPutHandler = parent;
            if (runningMap != null) {
                hashSet = runningMap;
                synchronized (hashSet) {
                    if (runningMap.contains(this)) {
                        Logger.error(this, "PutHandler already in 'runningMap': " + runningMap, (Throwable)new Error("error"));
                    } else {
                        runningMap.add(this);
                    }
                }
            }
            hashSet = BaseManifestPutter.this.putHandlerWaitingForBlockSets;
            synchronized (hashSet) {
                if (BaseManifestPutter.this.putHandlerWaitingForBlockSets.contains(this)) {
                    Logger.error(this, "PutHandler already in 'waitingForBlockSets'!", (Throwable)new Error("error"));
                } else {
                    BaseManifestPutter.this.putHandlerWaitingForBlockSets.add(this);
                }
            }
            hashSet = BaseManifestPutter.this.putHandlersWaitingForFetchable;
            synchronized (hashSet) {
                if (BaseManifestPutter.this.putHandlersWaitingForFetchable.contains(this)) {
                    Logger.error(this, "PutHandler already in 'waitingForFetchable'!", (Throwable)new Error("error"));
                } else {
                    BaseManifestPutter.this.putHandlersWaitingForFetchable.add(this);
                }
            }
        }

        private PutHandler(BaseManifestPutter bmp, PutHandler parent, String name, String nameInArchive, Metadata md, ClientMetadata cm) {
            super(bmp.priorityClass, bmp.cb);
            this.persistent = bmp.persistent();
            this.cm = cm;
            this.itemName = name;
            this.origSFI = null;
            this.metadata = md;
            this.parentPutHandler = parent;
            this.targetInArchive = nameInArchive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(ClientContext context) throws InsertException {
            ClientPutState sfi;
            boolean ok;
            HashSet hashSet;
            if (logDEBUG) {
                Logger.debug(this, "Starting a PutHandler for '" + this.itemName + "' " + this);
            }
            if (this.origSFI == null) {
                BaseManifestPutter.this.fail(new IllegalStateException("origSFI is null on start(), impossible"), context);
            }
            if (!(this instanceof MetaPutHandler) && this.metadata != null) {
                BaseManifestPutter.this.fail(new IllegalStateException("metdata=" + this.metadata + " on start(), impossible"), context);
            }
            if (this instanceof ContainerPutHandler || this instanceof ArchivePutHandler) {
                if (this != BaseManifestPutter.this.rootContainerPutHandler) {
                    hashSet = BaseManifestPutter.this.containerPutHandlers;
                    synchronized (hashSet) {
                        ok = BaseManifestPutter.this.containerPutHandlers.contains(this);
                    }
                    if (!ok) {
                        throw new IllegalStateException("Starting a PutHandler thats not in 'containerPutHandlers'! " + this);
                    }
                }
            } else if (this != BaseManifestPutter.this.rootMetaPutHandler) {
                hashSet = BaseManifestPutter.this.runningPutHandlers;
                synchronized (hashSet) {
                    ok = BaseManifestPutter.this.runningPutHandlers.contains(this);
                }
                if (!ok) {
                    throw new IllegalStateException("Starting a PutHandler thats not in 'runningPutHandlers'! " + this);
                }
            }
            hashSet = BaseManifestPutter.this.putHandlerWaitingForBlockSets;
            synchronized (hashSet) {
                ok = BaseManifestPutter.this.putHandlerWaitingForBlockSets.contains(this);
            }
            if (!ok) {
                Logger.error(this, "Starting a PutHandler thats not in 'waitingForBlockSets'! " + this, (Throwable)new Error("error"));
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                this.currentState = sfi = this.origSFI;
                this.origSFI = null;
            }
            sfi.schedule(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Cancelling " + this, (Throwable)new Exception("debug"));
            }
            ClientPutState oldState = null;
            PutHandler putHandler = this;
            synchronized (putHandler) {
                if (this.cancelled) {
                    return;
                }
                super.cancel();
                oldState = this.currentState;
            }
            if (oldState != null) {
                oldState.cancel(context);
            }
            this.onFailure(new InsertException(InsertException.InsertExceptionMode.CANCELLED), oldState, context);
        }

        @Override
        public FreenetURI getURI() {
            return null;
        }

        @Override
        public boolean isFinished() {
            if (logMINOR) {
                Logger.minor(this, "Finished " + this, (Throwable)new Exception("debug"));
            }
            return BaseManifestPutter.this.finished || this.cancelled || BaseManifestPutter.this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(ClientPutState state, ClientContext context) {
            Throwable t;
            StackTraceElement te;
            if (!(!logDEBUG || "BaseManifestPutter.java".equals((te = (t = new Throwable("DEBUG onSuccess")).getStackTrace()[1]).getFileName()) && "onSuccess".equals(te.getMethodName()))) {
                Logger.error(this, "Not called via super", t);
            }
            if (logMINOR) {
                Logger.minor(this, "Completed '" + this.itemName + "' " + this);
            }
            if (BaseManifestPutter.this.putHandlersWaitingForFetchable.contains(this)) {
                BaseManifestPutter.this.onFetchable(this);
            }
            BaseClientPutter baseClientPutter = this;
            synchronized (baseClientPutter) {
                ClientPutState oldState = this.currentState;
                this.currentState = null;
            }
            baseClientPutter = BaseManifestPutter.this;
            synchronized (baseClientPutter) {
                BaseManifestPutter.this.runningPutHandlers.remove(this);
                if (BaseManifestPutter.this.putHandlersWaitingForMetadata.remove(this)) {
                    Logger.error(this, "PutHandler '" + this.itemName + "' was in waitingForMetadata in onSuccess() on " + this + " for " + BaseManifestPutter.this, (Throwable)new Error("debug"));
                }
                if (BaseManifestPutter.this.putHandlerWaitingForBlockSets.remove(this)) {
                    Logger.error(this, "PutHandler was in waitingForBlockSets in onSuccess() on " + this + " for " + BaseManifestPutter.this, (Throwable)new Error("debug"));
                }
                if (BaseManifestPutter.this.putHandlersWaitingForFetchable.remove(this)) {
                    Logger.error(this, "PutHandler was in waitingForFetchable in onSuccess() on " + this + " for " + BaseManifestPutter.this, (Throwable)new Error("debug"));
                }
                if (!BaseManifestPutter.this.runningPutHandlers.isEmpty() && logMINOR) {
                    Logger.minor(this, "Running put handlers: " + BaseManifestPutter.this.runningPutHandlers.size());
                    for (Object o : BaseManifestPutter.this.runningPutHandlers) {
                        Logger.minor(this, "Still running: " + o);
                    }
                }
            }
            BaseManifestPutter.this.tryComplete(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(InsertException e, ClientPutState state, ClientContext context) {
            PutHandler putHandler = this;
            synchronized (putHandler) {
                ClientPutState oldState = this.currentState;
                this.currentState = null;
            }
            if (logMINOR) {
                Logger.minor(this, "Failed: " + this + " - " + e, (Throwable)e);
            }
            BaseManifestPutter.this.fail(e, context);
        }

        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ClientContext context) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTransition(ClientPutState oldState, ClientPutState newState, ClientContext context) {
            if (newState == null) {
                throw new NullPointerException();
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                if (this.currentState == oldState) {
                    this.currentState = newState;
                    if (logMINOR) {
                        Logger.minor(this, "onTransition: cur=" + this.currentState + ", old=" + oldState + ", new=" + newState + " for " + this);
                    }
                    return;
                }
                Logger.error(this, "Ignoring onTransition: cur=" + this.currentState + ", old=" + oldState + ", new=" + newState + " for " + this);
            }
        }

        @Override
        public void onMetadata(Metadata m, ClientPutState state, ClientContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onMetadata(Bucket meta, ClientPutState state, ClientContext context) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addBlock() {
            BaseManifestPutter.this.addBlock();
            PutHandler putHandler = this;
            synchronized (putHandler) {
                ++this.minSuccessFetchBlocks;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addBlocks(int num) {
            BaseManifestPutter.this.addBlocks(num);
            PutHandler putHandler = this;
            synchronized (putHandler) {
                this.minSuccessFetchBlocks += num;
            }
        }

        @Override
        public void completedBlock(boolean dontNotify, ClientContext context) {
            BaseManifestPutter.this.completedBlock(dontNotify, context);
        }

        @Override
        public void failedBlock(ClientContext context) {
            BaseManifestPutter.this.failedBlock(context);
        }

        @Override
        public void fatallyFailedBlock(ClientContext context) {
            BaseManifestPutter.this.fatallyFailedBlock(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void addMustSucceedBlocks(int blocks) {
            BaseManifestPutter.this.addMustSucceedBlocks(blocks);
            PutHandler putHandler = this;
            synchronized (putHandler) {
                this.minSuccessFetchBlocks += blocks;
            }
        }

        @Override
        public synchronized void addRedundantBlocksInsert(int blocks) {
            BaseManifestPutter.this.addRedundantBlocksInsert(blocks);
        }

        @Override
        public synchronized int getMinSuccessFetchBlocks() {
            return this.minSuccessFetchBlocks;
        }

        @Override
        protected void innerNotifyClients(ClientContext context) {
            BaseManifestPutter.this.notifyClients(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBlockSetFinished(ClientPutState state, ClientContext context) {
            boolean allBlockSets = false;
            BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
            synchronized (baseManifestPutter) {
                BaseManifestPutter.this.putHandlerWaitingForBlockSets.remove(this);
                allBlockSets = BaseManifestPutter.this.freeformMode ? BaseManifestPutter.this.hasResolvedBase && BaseManifestPutter.this.putHandlerWaitingForBlockSets.isEmpty() : BaseManifestPutter.this.putHandlerWaitingForBlockSets.isEmpty();
            }
            if (allBlockSets) {
                BaseManifestPutter.this.blockSetFinalized(context);
            }
        }

        @Override
        public void onFetchable(ClientPutState state) {
            if (logMINOR) {
                Logger.minor(this, "onFetchable " + this, (Throwable)new Exception("debug"));
            }
            BaseManifestPutter.this.onFetchable(this);
        }

        @Override
        public void onTransition(ClientGetState oldState, ClientGetState newState, ClientContext context) {
        }

        public String toString() {
            if (logDEBUG) {
                return super.toString() + " {" + this.itemName + '}';
            }
            return super.toString();
        }

        @Override
        protected void innerToNetwork(ClientContext context) {
        }

        @Override
        public void innerOnResume(ClientContext context) throws ResumeFailedException {
            super.innerOnResume(context);
            try {
                if (this.currentState != null) {
                    this.currentState.onResume(context);
                }
                if (this.origSFI != null) {
                    this.origSFI.onResume(context);
                }
            }
            catch (InsertException e) {
                Logger.error(this, "Failed to start insert on resume: " + e, (Throwable)e);
                throw new ResumeFailedException("Insert error: " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onShutdown(ClientContext context) {
            ClientPutState s;
            PutHandler putHandler = this;
            synchronized (putHandler) {
                s = this.currentState;
            }
            if (s != null) {
                s.onShutdown(context);
            }
        }

        @Override
        protected ClientBaseCallback getCallback() {
            return BaseManifestPutter.this.cb;
        }

        @Override
        public short getPriorityClass() {
            return BaseManifestPutter.this.getPriorityClass();
        }

        @Override
        public ClientRequestSchedulerGroup getSchedulerGroup() {
            return BaseManifestPutter.this;
        }
    }

    private final class JokerPutHandler
    extends PutHandler {
        private static final long serialVersionUID = 1L;

        public JokerPutHandler(BaseManifestPutter bmp, String name, FreenetURI targetURI2, ClientMetadata cm2) {
            Metadata m;
            super(bmp, null, name, null, null, cm2);
            this.metadata = m = new Metadata(Metadata.DocumentType.SIMPLE_REDIRECT, null, null, targetURI2, cm2);
        }

        public JokerPutHandler(BaseManifestPutter bmp, PutHandler parent, String name, ClientMetadata cm2) {
            super(bmp, parent, name, name, null, cm2);
        }

        public JokerPutHandler(BaseManifestPutter bmp, PutHandler parent, String name, String target) {
            Metadata m;
            super(bmp, parent, name, name, null, null);
            this.metadata = m = new Metadata(Metadata.DocumentType.SYMBOLIC_SHORTLINK, null, null, target, null);
        }
    }

    private final class MetaPutHandler
    extends PutHandler {
        private static final long serialVersionUID = 1L;

        private MetaPutHandler(BaseManifestPutter smp, PutHandler parent, InsertBlock insertBlock) {
            super(smp, parent, (String)null, (ClientMetadata)null, (HashSet)null);
            this.origSFI = new SingleFileInserter(this, this, insertBlock, true, BaseManifestPutter.this.ctx, this.realTimeFlag, false, false, null, null, true, null, true, this.persistent(), 0L, 0L, null, BaseManifestPutter.this.cryptoAlgorithm, null, -1L);
            if (logMINOR) {
                Logger.minor(this, "Inserting root metadata: " + this.origSFI);
            }
        }

        private MetaPutHandler(BaseManifestPutter smp, PutHandler parent, Metadata toResolve, BucketFactory bf) throws MetadataUnresolvedException, IOException {
            super(smp, parent, null, null, BaseManifestPutter.this.runningPutHandlers);
            RandomAccessBucket b = toResolve.toBucket(bf);
            this.metadata = toResolve;
            InsertBlock ib = new InsertBlock(b, null, FreenetURI.EMPTY_CHK_URI);
            this.origSFI = new SingleFileInserter(this, this, ib, true, BaseManifestPutter.this.ctx, this.realTimeFlag, false, false, toResolve, null, true, null, true, this.persistent(), 0L, 0L, null, BaseManifestPutter.this.cryptoAlgorithm, null, -1L);
            if (logMINOR) {
                Logger.minor(this, "Inserting subsidiary metadata: " + this.origSFI + " for " + toResolve);
            }
        }

        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "onEncode(" + key.getURI().toString(false, false) + ") for " + this);
            }
            if (BaseManifestPutter.this.rootMetaPutHandler == this) {
                BaseManifestPutter.this.finalURI = key.getURI();
                BaseManifestPutter.this.cb.onGeneratedURI(BaseManifestPutter.this.finalURI, this);
                return;
            }
            this.metadata.resolve(key.getURI());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(ClientPutState state, ClientContext context) {
            boolean wasRoot = false;
            BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
            synchronized (baseManifestPutter) {
                if (BaseManifestPutter.this.rootMetaPutHandler == this) {
                    BaseManifestPutter.this.rootMetaPutHandler = null;
                    wasRoot = true;
                }
            }
            if (!wasRoot) {
                BaseManifestPutter.this.resolveAndStartBase(context);
            }
            super.onSuccess(state, context);
        }
    }

    private final class ExternPutHandler
    extends PutHandler {
        private static final long serialVersionUID = 1L;

        private ExternPutHandler(BaseManifestPutter bmp, PutHandler parent, String name, RandomAccessBucket data, ClientMetadata cm2) {
            super(bmp, parent, name, cm2, BaseManifestPutter.this.runningPutHandlers);
            InsertBlock block = new InsertBlock(data, this.cm, FreenetURI.EMPTY_CHK_URI);
            this.origSFI = new SingleFileInserter(this, this, block, false, BaseManifestPutter.this.ctx, this.realTimeFlag, false, true, null, null, false, null, false, this.persistent(), 0L, 0L, null, BaseManifestPutter.this.cryptoAlgorithm, BaseManifestPutter.this.forceCryptoKey, -1L);
        }

        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "onEncode(" + key + ") for " + this);
            }
            if (this.metadata != null) {
                Logger.error(this, "Reassigning metadata: " + this.metadata, (Throwable)new Exception("debug"));
            }
            Metadata m = new Metadata(Metadata.DocumentType.SIMPLE_REDIRECT, null, null, key.getURI(), this.cm);
            this.onMetadata(m, state, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetadata(Metadata m, ClientPutState state, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Assigning metadata: " + m + " for '" + this.itemName + "' " + this + " from " + state + " persistent=" + this.persistent);
            }
            if (this.metadata != null) {
                Logger.error(this, "Reassigning metadata", (Throwable)new Exception("debug"));
                return;
            }
            this.metadata = m;
            if (BaseManifestPutter.this.freeformMode) {
                boolean allMetadatas = false;
                BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
                synchronized (baseManifestPutter) {
                    BaseManifestPutter.this.putHandlersWaitingForMetadata.remove(this);
                    allMetadatas = BaseManifestPutter.this.putHandlersWaitingForMetadata.isEmpty();
                    if (!allMetadatas && logMINOR) {
                        Logger.minor(this, "Still waiting for metadata: " + BaseManifestPutter.this.putHandlersWaitingForMetadata.size());
                    }
                }
                if (allMetadatas) {
                    BaseManifestPutter.this.gotAllMetadata(context);
                } else {
                    try {
                        if (m.writtenLength() > 32767L) {
                            throw new MetadataUnresolvedException(new Metadata[]{m}, "Too big");
                        }
                    }
                    catch (MetadataUnresolvedException e) {
                        try {
                            BaseManifestPutter.this.resolve(e, context);
                        }
                        catch (IOException e1) {
                            BaseManifestPutter.this.fail(new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e1, null), context);
                            return;
                        }
                        catch (InsertException e1) {
                            BaseManifestPutter.this.fail(e1, context);
                        }
                    }
                }
            } else if (BaseManifestPutter.this.containerMode) {
                HashMap hm = (HashMap)BaseManifestPutter.this.putHandlersTransformMap.get(this);
                ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(this.parentPutHandler)).remove(this);
                hm.put(this.itemName, m);
                BaseManifestPutter.this.putHandlersTransformMap.remove(this);
                try {
                    BaseManifestPutter.this.tryStartParentContainer(this.parentPutHandler, context);
                }
                catch (InsertException e) {
                    BaseManifestPutter.this.fail(e, context);
                    return;
                }
            } else {
                throw new RuntimeException("Neiter container nor freeform mode. Hu?");
            }
        }

        @Override
        public void onSuccess(ClientPutState state, ClientContext context) {
            super.onSuccess(state, context);
        }
    }

    private final class ContainerPutHandler
    extends PutHandler {
        private static final long serialVersionUID = 1L;

        private ContainerPutHandler(BaseManifestPutter bmp, PutHandler parent, String name, HashMap<String, Object> data, FreenetURI insertURI, Object object, HashSet<PutHandler> runningMap) {
            super(bmp, parent, name, null, runningMap);
            this.origSFI = new ContainerInserter(this, this, data, insertURI, BaseManifestPutter.this.ctx, false, false, null, ArchiveManager.ARCHIVE_TYPE.TAR, false, BaseManifestPutter.this.forceCryptoKey, BaseManifestPutter.this.cryptoAlgorithm, this.realTimeFlag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "onEncode(" + key.getURI().toString(false, false) + ") for " + this);
            }
            if (BaseManifestPutter.this.rootContainerPutHandler == this) {
                BaseManifestPutter.this.finalURI = key.getURI();
                BaseManifestPutter.this.cb.onGeneratedURI(BaseManifestPutter.this.finalURI, this);
            } else {
                BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
                synchronized (baseManifestPutter) {
                    HashMap hm = (HashMap)BaseManifestPutter.this.putHandlersTransformMap.get(this);
                    ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(this.parentPutHandler)).remove(this);
                    Metadata m = new Metadata(Metadata.DocumentType.SIMPLE_REDIRECT, null, null, key.getURI(), this.cm);
                    hm.put(this.itemName, m);
                    BaseManifestPutter.this.putHandlersTransformMap.remove(this);
                    try {
                        BaseManifestPutter.this.tryStartParentContainer(this.parentPutHandler, context);
                    }
                    catch (InsertException e) {
                        BaseManifestPutter.this.fail(e, context);
                        return;
                    }
                }
            }
        }

        @Override
        public void onSuccess(ClientPutState state, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Completed '" + this.itemName + "' " + this);
            }
            if (BaseManifestPutter.this.rootContainerPutHandler == this) {
                if (BaseManifestPutter.this.containerPutHandlers.contains(this)) {
                    throw new IllegalStateException("was in containerPutHandlers");
                }
                BaseManifestPutter.this.rootContainerPutHandler = null;
            } else if (!BaseManifestPutter.this.containerPutHandlers.remove(this)) {
                throw new IllegalStateException("was not in containerPutHandlers");
            }
            super.onSuccess(state, context);
        }
    }

    private final class ArchivePutHandler
    extends PutHandler {
        private static final long serialVersionUID = 1L;

        private ArchivePutHandler(BaseManifestPutter bmp, PutHandler parent, String name, HashMap<String, Object> data, FreenetURI insertURI) {
            super(bmp, parent, name, null, BaseManifestPutter.this.containerPutHandlers);
            this.origSFI = new ContainerInserter(this, this, data, insertURI, BaseManifestPutter.this.ctx, false, false, null, ArchiveManager.ARCHIVE_TYPE.TAR, false, BaseManifestPutter.this.forceCryptoKey, BaseManifestPutter.this.cryptoAlgorithm, this.realTimeFlag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "onEncode(" + key.getURI().toString(false, false) + ") for " + this);
            }
            BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
            synchronized (baseManifestPutter) {
                ArrayList phv = (ArrayList)BaseManifestPutter.this.putHandlersArchiveTransformMap.get(this);
                if (phv == null) {
                    return;
                }
                for (PutHandler ph : phv) {
                    HashMap hm = (HashMap)BaseManifestPutter.this.putHandlersTransformMap.get(ph);
                    ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(ph.parentPutHandler)).remove(ph);
                    if (ph.targetInArchive == null) {
                        throw new NullPointerException();
                    }
                    Metadata m = new Metadata(Metadata.DocumentType.SIMPLE_REDIRECT, null, null, key.getURI().setMetaString(new String[]{ph.targetInArchive}), this.cm);
                    hm.put(ph.itemName, m);
                    BaseManifestPutter.this.putHandlersTransformMap.remove(ph);
                    try {
                        BaseManifestPutter.this.tryStartParentContainer(ph.parentPutHandler, context);
                    }
                    catch (InsertException e) {
                        BaseManifestPutter.this.fail(new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, e, null), context);
                        return;
                    }
                }
                BaseManifestPutter.this.putHandlersArchiveTransformMap.remove(this);
            }
        }

        @Override
        public void onSuccess(ClientPutState state, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Completed '" + this.itemName + "' " + this);
            }
            if (!BaseManifestPutter.this.containerPutHandlers.remove(this)) {
                throw new IllegalStateException("was not in containerPutHandlers");
            }
            super.onSuccess(state, context);
        }
    }
}

