/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.utilities;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.SwingUtilities;

public class ParentDispatchingMouseAdapter
extends MouseAdapter {
    private Component source;

    public ParentDispatchingMouseAdapter(Component source) {
        this.source = source;
    }

    private void dispatchToParent(MouseEvent e) {
        Container parentComp;
        if (!e.isConsumed() && (parentComp = this.source.getParent()) != null) {
            parentComp.dispatchEvent(SwingUtilities.convertMouseEvent((Component)e.getSource(), e, parentComp));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dispatchToParent(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dispatchToParent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dispatchToParent(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.dispatchToParent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.dispatchToParent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.dispatchToParent(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.dispatchToParent(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.dispatchToParent(e);
    }
}

