/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.utilities;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class LinearLayout
implements LayoutManager {
    int spacer = 0;

    public LinearLayout() {
    }

    public LinearLayout(int spacer) {
        this.spacer = spacer;
    }

    public void setSpacer(int spacer) {
        this.spacer = spacer;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int count = parent.getComponentCount();
        if (count == 0) {
            return new Dimension(0, 0);
        }
        if (parent.getParent() == null) {
            return new Dimension(0, 0);
        }
        int w = parent.getWidth();
        int h = 0;
        for (Component c : parent.getComponents()) {
            if (h != 0) {
                h += this.spacer;
            }
            h += c.getHeight();
        }
        return new Dimension(w, h);
    }

    @Override
    public void layoutContainer(Container parent) {
        int count = parent.getComponentCount();
        if (count == 0) {
            return;
        }
        if (parent.getParent() == null) {
            return;
        }
        int w = parent.getWidth();
        int runningY = 0;
        for (int i = 0; i < count; ++i) {
            Component temp = parent.getComponent(i);
            int h = temp.getHeight();
            temp.setLocation(0, runningY);
            temp.setSize(w, h);
            runningY += h + this.spacer;
        }
    }
}

