/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.ui;

import blue.BlueData;
import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.mixer.Mixer;
import blue.projects.BlueProject;
import blue.score.Score;
import blue.score.layers.Layer;
import blue.score.layers.LayerGroup;
import blue.score.layers.LayerGroupListener;
import blue.score.layers.audio.core.AudioLayer;
import blue.score.layers.audio.core.AudioLayerGroup;
import blue.score.layers.audio.ui.bindings.AudioLayerChannelBinding;
import blue.score.layers.audio.ui.bindings.AudioLayerGroupBinding;
import blue.util.ObservableList;
import blue.util.ObservableListEvent;
import blue.util.ObservableListListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlueProjectPropertyChangeListener
implements PropertyChangeListener {
    protected BlueProject currentProject = null;
    protected ObservableListListener<LayerGroup<? extends Layer>> scoreListener;
    protected LayerGroupListener layerGroupListener;
    protected Map<AudioLayerGroup, AudioLayerGroupBinding> layerGroupBindings = new HashMap<AudioLayerGroup, AudioLayerGroupBinding>();
    protected Map<AudioLayer, AudioLayerChannelBinding> layerBindings = new HashMap<AudioLayer, AudioLayerChannelBinding>();

    public BlueProjectPropertyChangeListener() {
        this.layerGroupListener = event -> {
            if (!(event.getSource() instanceof AudioLayerGroup)) {
                return;
            }
            AudioLayerGroup alg = (AudioLayerGroup)event.getSource();
            ChannelList list = this.findChannelListForAudioLayerGroup(this.currentProject.getData().getMixer(), alg);
            switch (event.getType()) {
                case 0: {
                    for (Layer layer : event.getLayers()) {
                        AudioLayer aLayer = (AudioLayer)layer;
                        Channel channel = new Channel();
                        channel.setAssociation(aLayer.getUniqueId());
                        list.add((Object)channel);
                        this.layerBindings.put(aLayer, new AudioLayerChannelBinding(aLayer, channel));
                    }
                    break;
                }
                case 1: {
                    for (Layer layer : event.getLayers()) {
                        AudioLayer aLayer = (AudioLayer)layer;
                        String uniqueId = aLayer.getUniqueId();
                        for (int i = 0; i < list.size(); ++i) {
                            Channel channel = (Channel)list.get(i);
                            if (!uniqueId.equals(channel.getAssociation())) continue;
                            list.remove((Object)channel);
                            break;
                        }
                        if (!this.layerBindings.containsKey(aLayer)) continue;
                        this.layerBindings.get(aLayer).clearBinding();
                        this.layerBindings.remove(aLayer);
                    }
                    break;
                }
            }
        };
        this.scoreListener = new ObservableListListener<LayerGroup<?>>(){

            public void listChanged(ObservableListEvent<LayerGroup<?>> evt) {
                if (BlueProjectPropertyChangeListener.this.currentProject == null) {
                    return;
                }
                Mixer mixer = BlueProjectPropertyChangeListener.this.currentProject.getData().getMixer();
                ObservableList channelGroups = mixer.getChannelListGroups();
                switch (evt.getType()) {
                    case 0: {
                        for (LayerGroup lg : evt.getAffectedItems()) {
                            if (!(lg instanceof AudioLayerGroup)) continue;
                            AudioLayerGroup alg = (AudioLayerGroup)lg;
                            alg.addLayerGroupListener(BlueProjectPropertyChangeListener.this.layerGroupListener);
                            ChannelList channels = new ChannelList();
                            channelGroups.add(channels);
                            channels.setAssociation(alg.getUniqueId());
                            channels.setListName(alg.getName());
                            channels.setListNameEditSupported(true);
                            BlueProjectPropertyChangeListener.this.layerGroupBindings.put(alg, new AudioLayerGroupBinding(alg, channels));
                            for (AudioLayer layer : alg) {
                                Channel channel = new Channel();
                                channel.setAssociation(layer.getUniqueId());
                                channels.add((Object)channel);
                                BlueProjectPropertyChangeListener.this.layerBindings.put(layer, new AudioLayerChannelBinding(layer, channel));
                            }
                        }
                        break;
                    }
                    case 1: {
                        for (LayerGroup lg : evt.getAffectedItems()) {
                            if (!(lg instanceof AudioLayerGroup)) continue;
                            AudioLayerGroup alg = (AudioLayerGroup)lg;
                            String uniqueId = alg.getUniqueId();
                            alg.removeLayerGroupListener(BlueProjectPropertyChangeListener.this.layerGroupListener);
                            if (BlueProjectPropertyChangeListener.this.layerGroupBindings.containsKey(alg)) {
                                AudioLayerGroupBinding binding = BlueProjectPropertyChangeListener.this.layerGroupBindings.get(alg);
                                binding.clearBinding();
                                BlueProjectPropertyChangeListener.this.layerGroupBindings.remove(alg);
                            }
                            for (ChannelList list : channelGroups) {
                                if (!uniqueId.equals(list.getAssociation())) continue;
                                channelGroups.remove(list);
                                break;
                            }
                            for (AudioLayer layer : alg) {
                                if (!BlueProjectPropertyChangeListener.this.layerBindings.containsKey(layer)) continue;
                                AudioLayerChannelBinding binding = BlueProjectPropertyChangeListener.this.layerBindings.get(layer);
                                binding.clearBinding();
                                BlueProjectPropertyChangeListener.this.layerBindings.remove(layer);
                            }
                        }
                        break;
                    }
                    case 2: {
                        ChannelList second;
                        List affectedItems = evt.getAffectedItems();
                        ArrayList<AudioLayerGroup> affectedAudioGroups = new ArrayList<AudioLayerGroup>();
                        for (LayerGroup layerGroup : affectedItems) {
                            if (!(layerGroup instanceof AudioLayerGroup)) continue;
                            affectedAudioGroups.add((AudioLayerGroup)layerGroup);
                        }
                        if (affectedAudioGroups.size() <= 1) {
                            return;
                        }
                        if (evt.getSubType() == 16) {
                            if (!(affectedItems.get(0) instanceof AudioLayerGroup)) break;
                            ChannelList first = this.findChanneListByAssociation((List<ChannelList>)channelGroups, ((AudioLayerGroup)affectedAudioGroups.get(0)).getUniqueId());
                            second = this.findChanneListByAssociation((List<ChannelList>)channelGroups, ((AudioLayerGroup)affectedAudioGroups.get(1)).getUniqueId());
                            channelGroups.remove(first);
                            channelGroups.add(channelGroups.indexOf(second), first);
                            break;
                        }
                        if (evt.getSubType() != 8 || !(affectedItems.get(affectedItems.size() - 1) instanceof AudioLayerGroup)) break;
                        ChannelList newLast = this.findChanneListByAssociation((List<ChannelList>)channelGroups, ((AudioLayerGroup)affectedAudioGroups.get(affectedAudioGroups.size() - 1)).getUniqueId());
                        second = this.findChanneListByAssociation((List<ChannelList>)channelGroups, ((AudioLayerGroup)affectedAudioGroups.get(affectedItems.size() - 2)).getUniqueId());
                        channelGroups.remove(newLast);
                        channelGroups.add(channelGroups.indexOf(second), newLast);
                        break;
                    }
                }
            }

            private ChannelList findChanneListByAssociation(List<ChannelList> channelLists, String uniqueId) {
                for (ChannelList list : channelLists) {
                    if (!uniqueId.equals(list.getAssociation())) continue;
                    return list;
                }
                return null;
            }
        };
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentProject".equals(evt.getPropertyName())) {
            BlueProject newProject;
            BlueProject oldProject = (BlueProject)evt.getOldValue();
            if (oldProject == (newProject = (BlueProject)evt.getNewValue())) {
                return;
            }
            if (oldProject != null) {
                this.detachListeners(oldProject);
            }
            for (AudioLayerGroupBinding audioLayerGroupBinding : this.layerGroupBindings.values()) {
                audioLayerGroupBinding.clearBinding();
            }
            this.layerGroupBindings.clear();
            for (AudioLayerChannelBinding audioLayerChannelBinding : this.layerBindings.values()) {
                audioLayerChannelBinding.clearBinding();
            }
            this.layerBindings.clear();
            if (newProject != null) {
                this.synchronizeAudioLayersAndMixer(newProject.getData());
                this.attachListeners(newProject);
            }
            this.currentProject = newProject;
        }
    }

    protected void detachListeners(BlueProject project) {
        if (project == null) {
            return;
        }
        Score score = project.getData().getScore();
        for (LayerGroup lg : score) {
            if (!(lg instanceof AudioLayerGroup)) continue;
            lg.removeLayerGroupListener(this.layerGroupListener);
        }
        score.removeListener(this.scoreListener);
    }

    protected void attachListeners(BlueProject project) {
        if (project == null) {
            return;
        }
        Score score = project.getData().getScore();
        Mixer mixer = project.getData().getMixer();
        for (LayerGroup lg : score) {
            if (!(lg instanceof AudioLayerGroup)) continue;
            AudioLayerGroup alg = (AudioLayerGroup)lg;
            ChannelList channelList = this.findChannelListForAudioLayerGroup(mixer, alg);
            lg.addLayerGroupListener(this.layerGroupListener);
            AudioLayerGroupBinding binding = new AudioLayerGroupBinding(alg, channelList);
            this.layerGroupBindings.put(alg, binding);
            for (AudioLayer layer : alg) {
                Channel channel = ChannelList.findChannelByAssociation((ChannelList)channelList, (String)layer.getUniqueId());
                if (channel == null) continue;
                this.layerBindings.put(layer, new AudioLayerChannelBinding(layer, channel));
            }
        }
        score.addListener(this.scoreListener);
    }

    ChannelList findChannelListForAudioLayerGroup(Mixer mixer, AudioLayerGroup alg) {
        String uniqueId = alg.getUniqueId();
        for (ChannelList list : mixer.getChannelListGroups()) {
            if (!uniqueId.equals(list.getAssociation())) continue;
            return list;
        }
        return null;
    }

    private void synchronizeAudioLayersAndMixer(BlueData data) {
    }
}

