/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class ProjectDefaultsSettings {
    private static final String PREFIX = "projectDefaults.";
    private static final String DEFAULT_AUTHOR = "defaultAuthor";
    private static final String MIXER_ENABLED = "mixerEnabled";
    private static final String LAYER_HEIGHT_DEFAULT = "layerHeightDefault";
    public String defaultAuthor;
    public boolean mixerEnabled;
    public int layerHeightDefault;
    private static ProjectDefaultsSettings instance = null;

    private ProjectDefaultsSettings() {
    }

    public static ProjectDefaultsSettings getInstance() {
        if (instance == null) {
            instance = new ProjectDefaultsSettings();
            Preferences prefs = NbPreferences.forModule(ProjectDefaultsSettings.class);
            ProjectDefaultsSettings.instance.defaultAuthor = prefs.get("projectDefaults.defaultAuthor", "");
            ProjectDefaultsSettings.instance.mixerEnabled = prefs.getBoolean("projectDefaults.mixerEnabled", true);
            ProjectDefaultsSettings.instance.layerHeightDefault = prefs.getInt("projectDefaults.layerHeightDefault", 0);
        }
        return instance;
    }

    public void save() {
        Preferences prefs = NbPreferences.forModule(ProjectDefaultsSettings.class);
        prefs.put("projectDefaults.defaultAuthor", this.defaultAuthor);
        prefs.putBoolean("projectDefaults.mixerEnabled", this.mixerEnabled);
        prefs.putInt("projectDefaults.layerHeightDefault", this.layerHeightDefault);
        try {
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

