/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.EOFException;
import java.io.IOException;
import tcl.lang.Channel;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclString;
import tcl.lang.Util;

class ConsoleThread
extends Thread {
    Interp interp;
    StringBuffer sbuf;
    private Channel out;
    private Channel err;
    private static final boolean debug = false;
    private static boolean sysInAvailableWorks = false;

    ConsoleThread(Interp i) {
        this.setName("ConsoleThread");
        this.interp = i;
        this.sbuf = new StringBuffer(100);
        this.out = TclIO.getStdChannel(1);
        this.err = TclIO.getStdChannel(2);
    }

    public synchronized void run() {
        this.put(this.out, "% ");
        while (true) {
            this.getLine();
            final String command = this.sbuf.toString();
            TclEvent event = new TclEvent(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public int processEvent(int flags) {
                    if (Interp.commandComplete(command)) {
                        eval_exception = true;
                        commandObj = TclString.newInstance((String)command);
                        try {
                            commandObj.preserve();
                            ConsoleThread.this.interp.recordAndEval(commandObj, 0);
                            eval_exception = false;
                        }
                        catch (TclException e) {
                            code = e.getCompletionCode();
                            switch (code) {
                                case 1: {
                                    ConsoleThread.access$100(ConsoleThread.this, ConsoleThread.access$000(ConsoleThread.this), ConsoleThread.this.interp.getResult().toString());
                                    ** break;
lbl15:
                                    // 1 sources

                                    break;
                                }
                                case 3: {
                                    ConsoleThread.access$100(ConsoleThread.this, ConsoleThread.access$000(ConsoleThread.this), "invoked \"break\" outside of a loop");
                                    ** break;
lbl19:
                                    // 1 sources

                                    break;
                                }
                                case 4: {
                                    ConsoleThread.access$100(ConsoleThread.this, ConsoleThread.access$000(ConsoleThread.this), "invoked \"continue\" outside of a loop");
                                    ** break;
lbl23:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    ConsoleThread.access$100(ConsoleThread.this, ConsoleThread.access$000(ConsoleThread.this), "command returned bad code: " + code);
                                    break;
                                }
                            }
                        }
                        finally {
                            commandObj.release();
                        }
                        if (!eval_exception && (evalResult = ConsoleThread.this.interp.getResult().toString()).length() > 0) {
                            ConsoleThread.access$100(ConsoleThread.this, ConsoleThread.access$200(ConsoleThread.this), evalResult);
                        }
                        ConsoleThread.this.sbuf.setLength(0);
                        try {
                            prompt = ConsoleThread.this.interp.getVar("tcl_prompt1", 1);
                        }
                        catch (TclException e) {
                            prompt = null;
                        }
                        if (prompt != null) {
                            try {
                                ConsoleThread.this.interp.eval(prompt.toString(), 131072);
                            }
                            catch (TclException e) {
                                ConsoleThread.access$300(ConsoleThread.this, ConsoleThread.access$200(ConsoleThread.this), "% ");
                            }
                        } else {
                            ConsoleThread.access$300(ConsoleThread.this, ConsoleThread.access$200(ConsoleThread.this), "% ");
                        }
                        return 1;
                    }
                    try {
                        prompt = ConsoleThread.this.interp.getVar("tcl_prompt2", 1);
                    }
                    catch (TclException e) {
                        prompt = null;
                    }
                    if (prompt != null) {
                        try {
                            ConsoleThread.this.interp.eval(prompt.toString(), 131072);
                        }
                        catch (TclException e) {
                            ConsoleThread.access$300(ConsoleThread.this, ConsoleThread.access$200(ConsoleThread.this), "");
                        }
                    } else {
                        ConsoleThread.access$300(ConsoleThread.this, ConsoleThread.access$200(ConsoleThread.this), "");
                    }
                    return 1;
                }
            };
            this.interp.getNotifier().queueEvent(event, 0);
            event.sync();
        }
    }

    private void getLine() {
        int availableBytes = -1;
        if (sysInAvailableWorks) {
            try {
                availableBytes = 0;
                while (availableBytes == 0) {
                    availableBytes = System.in.available();
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                System.exit(0);
            }
            catch (EOFException e) {
                System.exit(0);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        char c2 = ' ';
        char c = ' ';
        while (availableBytes != 0) {
            try {
                int i = System.in.read();
                if (i == -1) {
                    if (this.sbuf.length() == 0) {
                        System.exit(0);
                    } else {
                        return;
                    }
                }
                c = (char)i;
                --availableBytes;
                if (c == '\r') {
                    i = System.in.read();
                    if (i == -1) {
                        if (this.sbuf.length() == 0) {
                            System.exit(0);
                        } else {
                            return;
                        }
                    }
                    if ((c2 = (char)((char)i)) == '\n') {
                        c = c2;
                    } else {
                        this.sbuf.append(c);
                        c = c2;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
            this.sbuf.append(c);
            if (c != 10) continue;
            return;
        }
    }

    private void putLine(Channel channel, String s) {
        try {
            channel.write(this.interp, s);
            channel.write(this.interp, "\n");
            channel.flush(this.interp);
        }
        catch (IOException ex) {
            System.err.println("IOException in Shell.putLine()");
            ex.printStackTrace(System.err);
        }
        catch (TclException ex) {
            System.err.println("TclException in Shell.putLine()");
            ex.printStackTrace(System.err);
        }
    }

    private void put(Channel channel, String s) {
        try {
            channel.write(this.interp, s);
            channel.flush(this.interp);
        }
        catch (IOException ex) {
            System.err.println("IOException in Shell.put()");
            ex.printStackTrace(System.err);
        }
        catch (TclException ex) {
            System.err.println("TclException in Shell.put()");
            ex.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Channel access$000(ConsoleThread x0) {
        return x0.err;
    }

    static /* synthetic */ void access$100(ConsoleThread x0, Channel x1, String x2) {
        x0.putLine(x1, x2);
    }

    static /* synthetic */ Channel access$200(ConsoleThread x0) {
        return x0.out;
    }

    static /* synthetic */ void access$300(ConsoleThread x0, Channel x1, String x2) {
        x0.put(x1, x2);
    }

    static {
        try {
            System.in.available();
            sysInAvailableWorks = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Util.isWindows()) {
            sysInAvailableWorks = false;
        }
    }
}

