/*
 * Decompiled with CFR 0.152.
 */
package blue.utility.midi;

import blue.utility.midi.TrackImportSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class MidiImportSettings
extends AbstractTableModel {
    List<TrackImportSettings> settings = Collections.synchronizedList(new ArrayList());

    public void addTrackImportSetting(TrackImportSettings trSetting) {
        this.settings.add(trSetting);
    }

    public TrackImportSettings getTrackSettingsForTrackNum(int trackNum) {
        for (TrackImportSettings trSettings : this.settings) {
            if (trSettings.getTrackNumber() != trackNum) continue;
            return trSettings;
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return null;
    }

    public List<TrackImportSettings> getSettings() {
        return this.settings;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Track";
            }
            case 1: {
                return "Instrument ID";
            }
            case 2: {
                return "Note Template";
            }
            case 3: {
                return "Trim Time";
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.settings.size();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        TrackImportSettings trSetting = this.settings.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                trSetting.setInstrId(((String)aValue).trim());
                break;
            }
            case 2: {
                trSetting.setNoteTemplate(((String)aValue).trim());
                break;
            }
            case 3: {
                trSetting.setTrim((Boolean)aValue);
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TrackImportSettings trSetting = this.settings.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return Integer.toString(trSetting.getTrackNumber());
            }
            case 1: {
                return trSetting.getInstrId();
            }
            case 2: {
                return trSetting.getNoteTemplate();
            }
            case 3: {
                return trSetting.isTrim();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }
}

