/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.Lex;
import electric.util.Node;
import electric.util.NodeList;
import electric.xml.AllAttributesNode;
import electric.xml.AllNode;
import electric.xml.Attribute;
import electric.xml.AttributeNode;
import electric.xml.AttributePredicate;
import electric.xml.Attributes;
import electric.xml.CurrentNode;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IndexPredicate;
import electric.xml.NameNode;
import electric.xml.Parent;
import electric.xml.ParentNode;
import electric.xml.RootNode;
import electric.xml.TextPredicate;
import electric.xml.WildNode;
import electric.xml.XPathException;
import electric.xml.XPathNode;
import java.io.IOException;

public final class XPath {
    NodeList nodes = new NodeList();

    public XPath(String string) throws XPathException {
        try {
            Lex lex = new Lex(string.trim(), "/", 19);
            if (lex.peek() == 47) {
                this.addNode(new RootNode());
                lex.read();
            }
            if (!lex.eof()) {
                String string2 = lex.readToken();
                this.addNode(string2);
                while (!lex.eof()) {
                    if (!string2.equals("/")) {
                        lex.readChar(47);
                    }
                    string2 = lex.readToken();
                    this.addNode(string2);
                }
            }
        }
        catch (IOException iOException) {
            throw new XPathException(iOException.toString());
        }
    }

    void addNode(String string) throws XPathException {
        if (string.equals("..")) {
            this.addNode(new ParentNode());
        } else if (string.equals(".")) {
            this.addNode(new CurrentNode());
        } else if (string.equals("/")) {
            this.addNode(new WildNode());
        } else if (string.equals("*")) {
            this.addNode(new AllNode());
        } else if (string.equals("@*")) {
            this.addNode(new AllAttributesNode());
        } else if (string.startsWith("@")) {
            this.addNode(new AttributeNode(string));
        } else if (string.indexOf("[@") != -1) {
            this.addNode(new AttributePredicate(string));
        } else if (string.indexOf("[text") != -1) {
            this.addNode(new TextPredicate(string));
        } else if (string.indexOf("[") != -1) {
            this.addNode(new IndexPredicate(string));
        } else {
            this.addNode(new NameNode(string));
        }
    }

    void addNode(Node node) {
        this.nodes.append(node);
    }

    Attribute getAttribute(Element element) {
        return this.getAttributes(element).first();
    }

    Attributes getAttributes(Element element) {
        NodeList nodeList = new NodeList();
        ((XPathNode)this.nodes.first).addNodes(element, nodeList);
        return new Attributes(nodeList);
    }

    Element getElement(Parent parent) {
        return this.getElements(parent).first();
    }

    Elements getElements(Parent parent) {
        NodeList nodeList = new NodeList();
        ((XPathNode)this.nodes.first).addNodes(parent, nodeList);
        return new Elements(nodeList);
    }
}

