/*
 * Decompiled with CFR 0.152.
 */
package blue.utility;

import blue.utility.GUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class SerializationCodeWriter
extends JFrame {
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea text1;
    private JTextArea text2;

    public SerializationCodeWriter() {
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.text1 = new JTextArea();
        this.jButton1 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.text2 = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.text1.setColumns(20);
        this.text1.setRows(5);
        this.jScrollPane1.setViewportView(this.text1);
        this.jButton1.setText("Process");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerializationCodeWriter.this.jButton1ActionPerformed(evt);
            }
        });
        this.text2.setColumns(20);
        this.text2.setRows(5);
        this.jScrollPane2.setViewportView(this.text2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 525, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 525, Short.MAX_VALUE).addComponent(this.jButton1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 206, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 218, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String text = this.text1.getText();
        String[] lines = text.split("\n");
        StringBuilder saveCode = new StringBuilder();
        StringBuilder loadCode = new StringBuilder();
        block14: for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.length() == 0) continue;
            if (line.indexOf(61) > 0) {
                line = line.substring(0, line.indexOf(61));
            }
            System.out.println(line);
            String[] parts = line.split("\\s");
            String varType = parts[parts.length - 2];
            String varName = parts[parts.length - 1];
            loadCode.append("} else if(nodeName.equals(\"").append(varName).append("\")) {\n");
            switch (varType) {
                case "String": {
                    saveCode.append("retVal.addElement(\"").append(varName).append("\").setText(").append(varName).append(");\n");
                    loadCode.append("retVal.").append(varName).append(" = nodeVal;\n");
                    continue block14;
                }
                case "boolean": {
                    saveCode.append("retVal.addElement(XMLUtilities.writeBoolean(\"").append(varName).append("\", ").append(varName).append("));\n");
                    loadCode.append("retVal.").append(varName).append(" = Boolean.valueOf(nodeVal).booleanValue();\n");
                    continue block14;
                }
                case "int": {
                    saveCode.append("retVal.addElement(XMLUtilities.writeInt(\"").append(varName).append("\", ").append(varName).append("));\n");
                    loadCode.append("retVal.").append(varName).append(" = Integer.parseInt(nodeVal);\n");
                    continue block14;
                }
                case "float": {
                    saveCode.append("retVal.addElement(XMLUtilities.writeFloat(\"").append(varName).append("\", ").append(varName).append("));\n");
                    loadCode.append("retVal.").append(varName).append(" = Float.parseFloat(nodeVal);\n");
                    continue block14;
                }
                case "double": {
                    saveCode.append("retVal.addElement(XMLUtilities.writeDouble(\"").append(varName).append("\", ").append(varName).append("));\n");
                    loadCode.append("retVal.").append(varName).append(" = Double.parseDouble(nodeVal);\n");
                }
            }
        }
        this.text2.setText(loadCode.toString() + "\n\n" + saveCode.toString());
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        SerializationCodeWriter s = new SerializationCodeWriter();
        s.setDefaultCloseOperation(3);
        s.setVisible(true);
    }
}

