/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.components.lines.Line;
import blue.components.lines.LineList;
import blue.components.lines.LinePoint;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.utility.NumberUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Iterator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.commons.lang3.text.StrBuilder;

public class BSBLineObject
extends BSBObject {
    IntegerProperty canvasWidth = new SimpleIntegerProperty(200);
    IntegerProperty canvasHeight = new SimpleIntegerProperty(160);
    DoubleProperty xMax = new SimpleDoubleProperty(1.0);
    BooleanProperty relativeXValues = new SimpleBooleanProperty(true);
    BooleanProperty leadingZero = new SimpleBooleanProperty(true);
    ObjectProperty<SeparatorType> separatorType = new SimpleObjectProperty((Object)SeparatorType.NONE);
    BooleanProperty locked = new SimpleBooleanProperty(false);
    private LineList lines;

    public BSBLineObject() {
        this.lines = new LineList();
    }

    public BSBLineObject(BSBLineObject lineObj) {
        super(lineObj);
        this.setCanvasWidth(lineObj.getCanvasWidth());
        this.setCanvasHeight(lineObj.getCanvasHeight());
        this.setXMax(lineObj.getXMax());
        this.setRelativeXValues(lineObj.isRelativeXValues());
        this.setLeadingZero(lineObj.isLeadingZero());
        this.setSeparatorType(lineObj.getSeparatorType());
        this.setLocked(lineObj.isLocked());
        this.lines = new LineList(lineObj.lines);
    }

    public static BSBObject loadFromXML(Element data) {
        BSBLineObject lineObj = new BSBLineObject();
        BSBLineObject.initBasicFromXML(data, lineObj);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "canvasWidth": {
                    lineObj.setCanvasWidth(XMLUtilities.readInt(node));
                    break;
                }
                case "canvasHeight": {
                    lineObj.setCanvasHeight(XMLUtilities.readInt(node));
                    break;
                }
                case "xMax": {
                    lineObj.setXMax(XMLUtilities.readDouble(node));
                    break;
                }
                case "commaSeparated": {
                    boolean val = XMLUtilities.readBoolean(node);
                    if (!val) break;
                    lineObj.setSeparatorType(SeparatorType.COMMA);
                    break;
                }
                case "separatorType": {
                    lineObj.setSeparatorType(SeparatorType.fromString(node.getTextString()));
                    break;
                }
                case "relativeXValues": {
                    lineObj.setRelativeXValues(XMLUtilities.readBoolean(node));
                    break;
                }
                case "lines": {
                    lineObj.setLines(LineList.loadFromXML(node));
                    break;
                }
                case "leadingZero": {
                    lineObj.setLeadingZero(XMLUtilities.readBoolean(node));
                    break;
                }
                case "locked": {
                    lineObj.setLocked(XMLUtilities.readBoolean(node));
                }
            }
        }
        return lineObj;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = BSBLineObject.getBasicXML(this);
        retVal.addElement(XMLUtilities.writeInt("canvasWidth", this.getCanvasWidth()));
        retVal.addElement(XMLUtilities.writeInt("canvasHeight", this.getCanvasHeight()));
        retVal.addElement(XMLUtilities.writeDouble("xMax", this.getXMax()));
        retVal.addElement(XMLUtilities.writeBoolean("relativeXValues", this.isRelativeXValues()));
        retVal.addElement("separatorType").setText(this.getSeparatorType().name());
        retVal.addElement(XMLUtilities.writeBoolean("leadingZero", this.isLeadingZero()));
        retVal.addElement(XMLUtilities.writeBoolean("locked", this.isLocked()));
        retVal.addElement(this.lines.saveAsXML());
        return retVal;
    }

    @Override
    public String[] getReplacementKeys() {
        String[] vals = new String[this.lines.size()];
        String objName = this.getObjectName();
        for (int i = 0; i < this.lines.size(); ++i) {
            Line l = (Line)this.lines.get(i);
            vals[i] = objName + "_" + l.getVarName();
        }
        return vals;
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        Iterator iter = this.lines.iterator();
        while (iter.hasNext()) {
            Line line = (Line)iter.next();
            String key = this.getObjectName() + "_" + line.getVarName();
            String val = this.getLineString(line);
            compilationUnit.addReplacementValue(key, val);
        }
    }

    private String getLineString(Line line) {
        int i;
        StrBuilder buffer = new StrBuilder();
        double[] xVals = new double[line.size()];
        double[] yVals = new double[line.size()];
        for (i = 0; i < line.size(); ++i) {
            LinePoint p = line.getLinePoint(i);
            xVals[i] = p.getX() * this.getXMax();
            yVals[i] = p.getY();
        }
        if (this.isRelativeXValues()) {
            for (i = xVals.length - 1; i > 0; --i) {
                xVals[i] = xVals[i] - xVals[i - 1];
            }
        }
        String spacer = this.getSeparatorType().getSeparatorString();
        if (this.isLeadingZero()) {
            buffer.append("0.0").append(spacer);
        }
        buffer.append(yVals[0]);
        for (int i2 = 1; i2 < xVals.length; ++i2) {
            buffer.append(spacer).append(NumberUtilities.formatDouble(xVals[i2]));
            buffer.append(spacer).append(NumberUtilities.formatDouble(yVals[i2]));
        }
        return buffer.toString();
    }

    @Override
    public String getPresetValue() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("version=2");
        Iterator iter = this.lines.iterator();
        while (iter.hasNext()) {
            buffer.append("@_@");
            Line line = (Line)iter.next();
            StringBuilder temp = new StringBuilder();
            temp.append(line.getVarName());
            for (int i = 0; i < line.size(); ++i) {
                LinePoint pt = line.getLinePoint(i);
                temp.append(":").append(pt.getX());
                temp.append(":").append(pt.getY());
            }
            buffer.append(temp.toString());
        }
        return buffer.toString();
    }

    @Override
    public void setPresetValue(String val) {
        String[] parts = val.split("@_@");
        int version = 1;
        int startIndex = 0;
        if (parts[0].startsWith("version=")) {
            version = Integer.parseInt(parts[0].substring(8));
            startIndex = 1;
        }
        for (int i = startIndex; i < parts.length; ++i) {
            String lineStr = parts[i];
            String[] vals = lineStr.split(":");
            String name = vals[0];
            Line line = this.getLineByName(name);
            if (line == null) continue;
            line.clear();
            double min = line.getMin();
            double max = line.getMax();
            double range = max - min;
            for (int j = 1; j < vals.length; j += 2) {
                LinePoint p = new LinePoint();
                double x = Double.parseDouble(vals[j]);
                double y = Double.parseDouble(vals[j + 1]);
                if (version == 1) {
                    y = y * range + min;
                }
                p.setLocation(x, y);
                line.addLinePoint(p);
            }
        }
        if (this.propListeners != null) {
            this.propListeners.firePropertyChange("presetValue", null, "preset");
        }
    }

    private Line getLineByName(String name) {
        Iterator iter = this.lines.iterator();
        while (iter.hasNext()) {
            Line line = (Line)iter.next();
            if (!line.getVarName().equals(name)) continue;
            return line;
        }
        return null;
    }

    public void setLines(LineList lines) {
        this.lines = lines;
    }

    public LineList getLines() {
        return this.lines;
    }

    public final void setCanvasWidth(int value) {
        this.canvasWidth.set(value);
    }

    public final int getCanvasWidth() {
        return this.canvasWidth.get();
    }

    public final IntegerProperty canvasWidthProperty() {
        return this.canvasWidth;
    }

    public final void setCanvasHeight(int value) {
        this.canvasHeight.set(value);
    }

    public final int getCanvasHeight() {
        return this.canvasHeight.get();
    }

    public final IntegerProperty canvasHeightProperty() {
        return this.canvasHeight;
    }

    public final void setXMax(double value) {
        this.xMax.set(value);
    }

    public final double getXMax() {
        return this.xMax.get();
    }

    public final DoubleProperty xMaxProperty() {
        return this.xMax;
    }

    public final void setRelativeXValues(boolean value) {
        this.relativeXValues.set(value);
    }

    public final boolean isRelativeXValues() {
        return this.relativeXValues.get();
    }

    public final BooleanProperty relativeXValuesProperty() {
        return this.relativeXValues;
    }

    public final void setLeadingZero(boolean val) {
        this.leadingZero.set(val);
    }

    public final boolean isLeadingZero() {
        return this.leadingZero.get();
    }

    public final BooleanProperty leadingZeroProperty() {
        return this.leadingZero;
    }

    public final void setLocked(boolean value) {
        this.locked.set(value);
    }

    public final boolean isLocked() {
        return this.locked.get();
    }

    public final BooleanProperty lockedProperty() {
        return this.locked;
    }

    public final SeparatorType getSeparatorType() {
        return (SeparatorType)((Object)this.separatorType.get());
    }

    public final void setSeparatorType(SeparatorType sType) {
        this.separatorType.set((Object)sType);
    }

    public final ObjectProperty<SeparatorType> separatorTypeProperty() {
        return this.separatorType;
    }

    @Override
    public BSBObject deepCopy() {
        return new BSBLineObject(this);
    }

    public static enum SeparatorType {
        NONE("None", " "),
        COMMA("Comma", ", "),
        SINGLE_QUOTE("Single Quote", "' ");

        private final String value;
        private final String separatorString;

        private SeparatorType(String value, String separatorString) {
            this.value = value;
            this.separatorString = separatorString;
        }

        public static SeparatorType fromString(String string) {
            switch (string) {
                case "None": {
                    return NONE;
                }
                case "Comma": {
                    return COMMA;
                }
                case "Single Quote": {
                    return SINGLE_QUOTE;
                }
            }
            return SeparatorType.valueOf(string);
        }

        public String getSeparatorString() {
            return this.separatorString;
        }

        public String toString() {
            return this.value;
        }
    }
}

