/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import electric.xml.Element;

public class AddProcessor
implements NoteProcessor {
    double value = 0.0;
    int pfield = 4;

    public AddProcessor() {
    }

    public AddProcessor(AddProcessor addProc) {
        this.value = addProc.value;
        this.pfield = addProc.pfield;
    }

    public String toString() {
        return "[add]";
    }

    public String getPfield() {
        return Integer.toString(this.pfield);
    }

    public void setPfield(String pfield) {
        this.pfield = Integer.parseInt(pfield);
    }

    public String getVal() {
        return Double.toString(this.value);
    }

    public void setVal(String value) {
        this.value = Double.parseDouble(value);
    }

    @Override
    public final void processNotes(NoteList in) throws NoteProcessorException {
        double fieldVal = 0.0;
        for (int i = 0; i < in.size(); ++i) {
            Note temp = (Note)in.get(i);
            try {
                fieldVal = Double.parseDouble(temp.getPField(this.pfield));
            }
            catch (NumberFormatException ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.pfieldNotDouble"), this.pfield);
            }
            catch (Exception ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield);
            }
            temp.setPField(Double.toString(fieldVal + this.value), this.pfield);
        }
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i * 2 + " 2 3 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        AddProcessor ap = new AddProcessor();
        ap.setPfield("2");
        ap.setVal("-2.2");
        try {
            ap.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    public static NoteProcessor loadFromXML(Element data) {
        AddProcessor ap = new AddProcessor();
        ap.setPfield(data.getElement("pfield").getTextString());
        ap.setVal(data.getElement("value").getTextString());
        return ap;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("pfield").setText(this.getPfield());
        retVal.addElement("value").setText(this.getVal());
        return retVal;
    }

    @Override
    public AddProcessor deepCopy() {
        return new AddProcessor(this);
    }
}

