/*
 * Decompiled with CFR 0.152.
 */
package blue.mixer;

import blue.automation.Automatable;
import blue.automation.Parameter;
import blue.automation.ParameterList;
import blue.automation.ParameterListener;
import blue.automation.ParameterTimeManagerFactory;
import blue.components.lines.Line;
import blue.components.lines.LinePoint;
import blue.orchestra.blueSynthBuilder.StringChannel;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Vector;

public class Send
implements Automatable,
ParameterListener {
    private String sendChannel = "Master";
    private double level = 1.0;
    private boolean enabled = true;
    private ParameterList params = new ParameterList();
    private Parameter levelParameter;
    private transient Vector<PropertyChangeListener> listeners = null;
    private transient boolean updatingLine = false;

    public Send() {
        this(true);
    }

    private Send(boolean init) {
        if (init) {
            this.levelParameter = new Parameter();
            this.levelParameter.setName("Send Amount");
            this.levelParameter.setMin(0.0, false);
            this.levelParameter.setMax(1.0, false);
            this.levelParameter.setValue(1.0);
            this.levelParameter.setResolution(new BigDecimal(-1.0));
            this.levelParameter.addParameterListener(this);
            this.params.add(this.levelParameter);
        }
    }

    public Send(Send send) {
        this.sendChannel = send.sendChannel;
        this.level = send.level;
        this.enabled = send.enabled;
        this.levelParameter = new Parameter(send.levelParameter);
        this.levelParameter.addParameterListener(this);
        this.params.add(this.levelParameter);
    }

    public String getSendChannel() {
        return this.sendChannel;
    }

    public void setSendChannel(String sendChannel) {
        if (this.sendChannel.equals(sendChannel)) {
            return;
        }
        String oldName = this.sendChannel;
        this.sendChannel = sendChannel;
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "sendChannel", oldName, this.sendChannel);
        this.firePropertyChangeEvent(pce);
    }

    public double getLevel() {
        return this.level;
    }

    public Parameter getLevelParameter() {
        return this.levelParameter;
    }

    public void setLevel(double level) {
        if (this.levelParameter.isAutomationEnabled()) {
            double time = ParameterTimeManagerFactory.getInstance().getTime();
            if (time < 0.0) {
                return;
            }
            this.updatingLine = true;
            LinePoint found = null;
            Line line = this.levelParameter.getLine();
            for (int i = 0; i < line.size(); ++i) {
                LinePoint point = line.getLinePoint(i);
                if (point.getX() != time) continue;
                found = point;
                break;
            }
            if (found != null) {
                found.setLocation(found.getX(), level);
            } else {
                LinePoint lp = new LinePoint();
                lp.setLocation(time, level);
                line.insertLinePoint(lp);
            }
            this.updatingLine = false;
        }
        double oldVal = this.level;
        this.level = level;
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "level", new Double(oldVal), new Double(level));
        this.firePropertyChangeEvent(pce);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Element saveAsXML() {
        Element retVal = new Element("send");
        retVal.addElement("sendChannel").setText(this.sendChannel);
        retVal.addElement("level").setText(Double.toString(this.level));
        retVal.addElement("enabled").setText(Boolean.toString(this.enabled));
        retVal.addElement(this.levelParameter.saveAsXML());
        return retVal;
    }

    public static Send loadFromXML(Element data) {
        Send send = new Send(false);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "sendChannel": {
                    send.sendChannel = node.getTextString();
                    break;
                }
                case "level": {
                    send.level = Double.parseDouble(node.getTextString());
                    break;
                }
                case "enabled": {
                    send.enabled = Boolean.valueOf(node.getTextString());
                    break;
                }
                case "parameter": {
                    send.levelParameter = Parameter.loadFromXML(node);
                    send.levelParameter.addParameterListener(send);
                    send.params.add(send.levelParameter);
                }
            }
        }
        if (send.params.size() == 0) {
            send.levelParameter = new Parameter();
            send.levelParameter.setName("Send Amount");
            send.levelParameter.setMin(0.0, false);
            send.levelParameter.setMax(1.0, false);
            send.levelParameter.setValue(1.0);
            send.levelParameter.setResolution(new BigDecimal(-1.0));
            send.levelParameter.addParameterListener(send);
            send.params.add(send.levelParameter);
        }
        return send;
    }

    public String toString() {
        return "> Send: " + this.sendChannel;
    }

    @Override
    public ParameterList getParameterList() {
        return this.params;
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.listeners == null) {
            return;
        }
        for (PropertyChangeListener listener : new Vector<PropertyChangeListener>(this.listeners)) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(pcl)) {
            this.listeners.add(pcl);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(pcl);
    }

    @Override
    public void lineDataChanged(Parameter param) {
        if (!this.updatingLine) {
            double time = ParameterTimeManagerFactory.getInstance().getTime();
            double level = this.levelParameter.getLine().getValue(time);
            double oldVal = this.level;
            this.level = level;
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "level", new Double(oldVal), new Double(level));
            this.firePropertyChangeEvent(pce);
        }
    }

    @Override
    public void parameterChanged(Parameter param) {
    }

    @Override
    public ArrayList<StringChannel> getStringChannels() {
        return null;
    }
}

