/*
 * Decompiled with CFR 0.152.
 */
package blue.data.impl;

import blue.BlueDataObject;
import blue.data.BlueDataObjectLoadException;
import blue.data.BlueDataObjectLoader;
import blue.data.BlueDataObjectManager;
import electric.xml.Element;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;

public class BlueDataObjectManagerImpl
implements BlueDataObjectManager {
    Map<String, BlueDataObjectLoader> loaders = new HashMap<String, BlueDataObjectLoader>();

    public BlueDataObjectManagerImpl() {
        Lookup.Result results = Lookup.getDefault().lookupResult(BlueDataObjectLoader.class);
        this.updateLoaders(results.allInstances());
        results.addLookupListener(ev -> this.updateLoaders(results.allInstances()));
    }

    @Override
    public BlueDataObject loadFromXML(Element element) {
        String bdoType = element.getAttributeValue("bdoType");
        if (bdoType == null) {
            throw new BlueDataObjectLoadException("Invalid XML found: Could not find bdoType attribute.");
        }
        BlueDataObjectLoader loader = this.loaders.get(bdoType);
        if (loader == null) {
            throw new BlueDataObjectLoadException("Unable to find loader for BlueDataObject of type: " + bdoType);
        }
        return loader.loadFromXML(element);
    }

    private void updateLoaders(Collection<? extends BlueDataObjectLoader> allInstances) {
        for (BlueDataObjectLoader blueDataObjectLoader : allInstances) {
            this.loaders.put(blueDataObjectLoader.getBlueDataObjectClass().getName(), blueDataObjectLoader);
        }
    }
}

