/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.test.NetUtilTest;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class NetUtil {
    private static final double VERSION = 0.39;
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("NetUtilStrings");

    private NetUtil() {
    }

    public static void main(String[] args) {
        boolean testo = false;
        if (args.length == 1) {
            if (args[0].equals("--testTCPClient")) {
                testo = true;
                NetUtilTest.client("tcp");
            } else if (args[0].equals("--testUDPClient")) {
                testo = true;
                NetUtilTest.client("udp");
            } else if (args[0].equals("--testTCPServer")) {
                testo = true;
                NetUtilTest.server("tcp");
            } else if (args[0].equals("--testUDPServer")) {
                testo = true;
                NetUtilTest.server("udp");
            } else if (args[0].equals("--testCodecSpeed")) {
                testo = true;
                NetUtilTest.codecSpeed();
            } else if (args[0].equals("--testPingPong")) {
                testo = true;
                NetUtilTest.pingPong();
            }
        }
        if (!testo) {
            System.err.println("\nNetUtil v0.39\n" + NetUtil.getCopyrightString() + "\n\n" + NetUtil.getCreditsString() + "\n\n  " + NetUtil.getResourceString("errIsALibrary"));
            System.out.println("\nThe following demos are available:\n  --testTCPClient\n  --testUDPClient\n  --testTCPServer\n  --testUDPServer\n  --testCodecSpeed\n  --testPingPong\n");
            System.exit(1);
        }
    }

    public static final double getVersion() {
        return 0.39;
    }

    public static final String getCopyrightString() {
        return NetUtil.getResourceString("copyright");
    }

    public static final String getCreditsString() {
        return NetUtil.getResourceString("credits");
    }

    public static final String getResourceString(String key) {
        try {
            return resBundle.getString(key);
        }
        catch (MissingResourceException e1) {
            return "[Missing Resource: " + key + "]";
        }
    }
}

