/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.udo;

import blue.BlueSystem;
import blue.gui.DragManager;
import blue.settings.GeneralSettings;
import blue.udo.OpcodeList;
import blue.udo.UDOCategory;
import blue.udo.UserDefinedOpcode;
import blue.ui.core.udo.TransferableUDO;
import blue.ui.core.udo.UDOBuffer;
import blue.ui.core.udo.UDORepositoryBrowser;
import blue.ui.utilities.FileChooserManager;
import blue.ui.utilities.UiUtilities;
import blue.utility.TextUtilities;
import blue.utility.UDOUtilities;
import electric.xml.Document;
import electric.xml.Element;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableModel;
import org.openide.util.Exceptions;

public class OpcodeListEditPanel
extends JComponent {
    private static final String EXPORT_BLUE_UDO_DIALOG = "blue.udo.export";
    private static final String EXPORT_CSOUND_UDO_DIALOG = "csound.udo.export";
    private static final String IMPORT_BLUE_UDO_DIALOG = "blue.udo.import";
    private static final String IMPORT_CSOUND_UDO_DIALOG = "csound.udo.import";
    UDORepositoryBrowser browser = null;
    JPopupMenu importPopup = new JPopupMenu();
    UDOPopup popup = new UDOPopup();
    JTable table = new JTable(){

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.getPreferredSize().height < this.getParent().getHeight();
        }
    };
    JLabel label;
    OpcodeList opcodeList = null;

    public OpcodeListEditPanel() {
        this.table.setSelectionMode(2);
        Insets smallButtonInsets = new Insets(0, 3, 0, 3);
        this.label = new JLabel("User-Defined Opcodes");
        this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), new EmptyBorder(3, 3, 3, 3)));
        JButton addButton = new JButton("+");
        addButton.setMargin(smallButtonInsets);
        addButton.setToolTipText("Add User-Defined Opcode");
        addButton.addActionListener(e -> this.addUDO());
        JMenuItem importBlueUDO = new JMenuItem("Import Blue UDO");
        importBlueUDO.addActionListener(ae -> this.importBlueUdo());
        JMenuItem importCsoundUDO = new JMenuItem("Import Csound UDO");
        importCsoundUDO.addActionListener(ae -> this.importCsoundUdo());
        this.importPopup.add(importBlueUDO);
        this.importPopup.add(importCsoundUDO);
        JButton importButton = new JButton("I");
        importButton.setMargin(new Insets(1, 6, 1, 7));
        importButton.setToolTipText("Import User-Defined Opcode");
        importButton.addActionListener(e -> this.importPopup.show(importButton, importButton.getX(), importButton.getHeight()));
        JButton removeButton = new JButton("-");
        removeButton.setMargin(new Insets(1, 4, 1, 5));
        removeButton.setToolTipText("Remove User-Defined Opcode");
        removeButton.addActionListener(e -> this.removeUDO());
        JButton pushUpButton = new JButton("^");
        pushUpButton.setToolTipText("Push Up");
        pushUpButton.setMargin(new Insets(4, 4, 0, 3));
        pushUpButton.addActionListener(e -> {
            int[] rows = this.table.getSelectedRows();
            if (rows.length > 0 && rows[0] > 0) {
                this.opcodeList.pushUpUDO(rows);
                this.table.setRowSelectionInterval(rows[0] - 1, rows[rows.length - 1] - 1);
            }
        });
        JButton pushDownButton = new JButton("V");
        pushDownButton.setMargin(new Insets(2, 3, 0, 4));
        pushDownButton.setToolTipText("Push Down");
        pushDownButton.addActionListener(e -> {
            int[] rows = this.table.getSelectedRows();
            if (rows.length > 0 && rows[rows.length - 1] < this.opcodeList.size() - 1) {
                this.opcodeList.pushDownUDO(rows);
                this.table.setRowSelectionInterval(rows[0] + 1, rows[rows.length - 1] + 1);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setPreferredSize(new Dimension(30, 100));
        buttonPanel.add(addButton);
        buttonPanel.add(importButton);
        buttonPanel.add(removeButton);
        buttonPanel.add(pushUpButton);
        buttonPanel.add(pushDownButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "North");
        this.add((Component)buttonPanel, "West");
        this.add((Component)new JScrollPane(this.table), "Center");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (OpcodeListEditPanel.this.table.isEditing()) {
                    return;
                }
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    OpcodeListEditPanel.this.popup.show(OpcodeListEditPanel.this.table, e.getX(), e.getY());
                }
            }
        });
        new OpcodeListDragSource(this.table, 1);
        new OpcodeListDropTarget(this.table);
        File defaultFile = new File(GeneralSettings.getInstance().getDefaultDirectory() + File.separator + "default.blueUDO");
        File defaultCsoundUdoFile = new File(GeneralSettings.getInstance().getDefaultDirectory() + File.separator + "default.udo");
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.addFilter((Object)IMPORT_BLUE_UDO_DIALOG, new FileChooser.ExtensionFilter("Blue UDO File", new String[]{"*.blueUDO"}));
        fcm.setDialogTitle((Object)IMPORT_BLUE_UDO_DIALOG, "Import Blue User-Defined Opcode");
        fcm.setSelectedFile((Object)IMPORT_BLUE_UDO_DIALOG, defaultFile);
        fcm.addFilter((Object)IMPORT_CSOUND_UDO_DIALOG, new FileChooser.ExtensionFilter("Csound File", new String[]{"*.udo", "*.orc", "*.csd"}));
        fcm.setDialogTitle((Object)IMPORT_CSOUND_UDO_DIALOG, "Import Csound User-Defined Opcodes");
        fcm.setSelectedFile((Object)IMPORT_CSOUND_UDO_DIALOG, defaultCsoundUdoFile);
    }

    public void setTopBarVisible(boolean visible) {
        this.label.setVisible(visible);
    }

    public void deselect() {
        this.table.clearSelection();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().addListSelectionListener(listener);
    }

    protected void removeUDO() {
        if (this.opcodeList == null) {
            return;
        }
        int[] indexes = this.table.getSelectedRows();
        if (indexes.length > 0) {
            this.opcodeList.removeOpcodes(indexes);
        }
    }

    protected void addUDO() {
        if (this.opcodeList != null) {
            UserDefinedOpcode udo = new UserDefinedOpcode();
            udo.opcodeName = udo.opcodeName + this.opcodeList.size();
            this.opcodeList.addOpcode(udo);
        }
    }

    public void addUDO(UserDefinedOpcode udo) {
        if (this.opcodeList != null) {
            this.opcodeList.addOpcode(udo);
        }
    }

    private void addUDO(UserDefinedOpcode udo, int row) {
        if (this.opcodeList != null) {
            this.opcodeList.addOpcode(row, udo);
        }
    }

    public void setOpcodeList(OpcodeList opcodeList) {
        if (opcodeList == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.table.setModel((TableModel)opcodeList);
        this.opcodeList = opcodeList;
        if (this.browser != null && this.browser.isVisible()) {
            this.browser.setOpcodeList(opcodeList);
        }
    }

    public UserDefinedOpcode[] getSelectedUDOs() {
        int[] indexes = this.table.getSelectedRows();
        if (indexes.length == 0) {
            return null;
        }
        UserDefinedOpcode[] udos = new UserDefinedOpcode[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            udos[i] = this.opcodeList.getOpcode(indexes[i]);
        }
        return udos;
    }

    protected void cutUDO() {
        if (this.getSelectedUDOs() != null) {
            this.copyUDO();
            this.removeUDO();
        }
    }

    protected void copyUDO() {
        UserDefinedOpcode[] udos = this.getSelectedUDOs();
        if (udos != null) {
            UserDefinedOpcode[] copies = new UserDefinedOpcode[udos.length];
            for (int i = 0; i < udos.length; ++i) {
                copies[i] = new UserDefinedOpcode(udos[i]);
            }
            UDOBuffer.getInstance().setBufferedObject(copies);
        }
    }

    protected void pasteUDO() {
        UDOBuffer buffer = UDOBuffer.getInstance();
        Object obj = buffer.getBufferedObject();
        if (obj == null) {
            return;
        }
        this.handlePaste(obj);
    }

    private void handlePaste(Object obj) {
        if (obj instanceof UserDefinedOpcode) {
            this.opcodeList.addOpcode(new UserDefinedOpcode((UserDefinedOpcode)obj));
        } else if (obj instanceof UserDefinedOpcode[]) {
            UserDefinedOpcode[] udos = (UserDefinedOpcode[])obj;
            UserDefinedOpcode[] copies = new UserDefinedOpcode[udos.length];
            for (int i = 0; i < udos.length; ++i) {
                copies[i] = new UserDefinedOpcode(udos[i]);
            }
            this.opcodeList.addOpcodes(copies);
        } else if (obj instanceof UDOCategory) {
            UDOCategory cat = (UDOCategory)obj;
            ArrayList udos = cat.getAllUserDefinedOpcodes();
            UserDefinedOpcode[] copies = new UserDefinedOpcode[udos.size()];
            for (int i = 0; i < udos.size(); ++i) {
                copies[i] = new UserDefinedOpcode((UserDefinedOpcode)udos.get(i));
            }
            this.opcodeList.addOpcodes(copies);
        }
    }

    protected void exportCsoundUdo() {
        UserDefinedOpcode[] selected = this.getSelectedUDOs();
        if (selected == null || selected.length != 1) {
            return;
        }
        File retVal = FileChooserManager.getDefault().showSaveDialog((Object)EXPORT_CSOUND_UDO_DIALOG, SwingUtilities.getRoot(this));
        if (retVal != null) {
            int overWrite;
            File f = retVal;
            if (f.exists() && (overWrite = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(this), "Please confirm you would like to overwrite this file.")) != 0) {
                return;
            }
            String udoText = selected[0].generateCode();
            try (PrintWriter out = new PrintWriter(new FileWriter(f));){
                out.print(udoText);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void exportBlueUdo() {
        UserDefinedOpcode[] selected = this.getSelectedUDOs();
        if (selected == null || selected.length != 1) {
            return;
        }
        File retVal = FileChooserManager.getDefault().showSaveDialog((Object)EXPORT_BLUE_UDO_DIALOG, SwingUtilities.getRoot(this));
        if (retVal != null) {
            int overWrite;
            File f = retVal;
            if (f.exists() && (overWrite = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(this), "Please confirm you would like to overwrite this file.")) != 0) {
                return;
            }
            Element node = selected[0].saveAsXML();
            try (PrintWriter out = new PrintWriter(new FileWriter(f));){
                out.print(node.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void importBlueUdo() {
        File f;
        List retVal = FileChooserManager.getDefault().showOpenDialog((Object)IMPORT_BLUE_UDO_DIALOG, SwingUtilities.getRoot(this));
        if (retVal != null && retVal.size() == 1 && (f = (File)retVal.get(0)).exists()) {
            try {
                String text = TextUtilities.getTextFromFile((File)f);
                Document d = new Document(f);
                UserDefinedOpcode udo = UserDefinedOpcode.loadFromXML((Element)d.getRoot());
                this.opcodeList.add((Object)udo);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected void importCsoundUdo() {
        File f;
        List retVal = FileChooserManager.getDefault().showOpenDialog((Object)IMPORT_CSOUND_UDO_DIALOG, SwingUtilities.getRoot(this));
        if (retVal != null && retVal.size() == 1 && (f = (File)retVal.get(0)).exists()) {
            try {
                String text = TextUtilities.getTextFromFile((File)f);
                OpcodeList opList = UDOUtilities.parseUDOText((String)text);
                this.opcodeList.addAll((Collection)opList);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    class OpcodeListDropTarget
    extends DropTargetAdapter {
        DropTarget target;
        JTable targetTable;

        public OpcodeListDropTarget(JTable table) {
            this.targetTable = table;
            this.target = new DropTarget(this.targetTable, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (!dtde.isDataFlavorSupported(TransferableUDO.UDO_FLAVOR) && !dtde.isDataFlavorSupported(TransferableUDO.UDO_CAT_FLAVOR)) {
                dtde.rejectDrag();
                return;
            }
            if (DragManager.getDragSource() != this.targetTable) {
                dtde.acceptDrag(1);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.dragEnter(dtde);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point pt = dtde.getLocation();
            if (!dtde.isDataFlavorSupported(TransferableUDO.UDO_FLAVOR) && !dtde.isDataFlavorSupported(TransferableUDO.UDO_CAT_FLAVOR) || (dtde.getSourceActions() & 1) != 1) {
                dtde.rejectDrop();
                return;
            }
            try {
                Transferable tr = dtde.getTransferable();
                Object transferNode = tr.getTransferData(TransferableUDO.UDO_FLAVOR);
                dtde.acceptDrop(1);
                OpcodeListEditPanel.this.handlePaste(transferNode);
                dtde.dropComplete(true);
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class OpcodeListDragSource
    extends DragSourceAdapter
    implements DragGestureListener {
        DragSource source;
        DragGestureRecognizer recognizer;
        JTable table;
        TransferableUDO transferable;

        public OpcodeListDragSource(JTable table, int actions) {
            this.table = table;
            this.source = new DragSource();
            this.recognizer = this.source.createDefaultDragGestureRecognizer(table, actions, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            OpcodeList opcodeList = (OpcodeList)this.table.getModel();
            UserDefinedOpcode udo = opcodeList.getOpcode(index);
            UserDefinedOpcode cloneNode = new UserDefinedOpcode(udo);
            this.transferable = new TransferableUDO(cloneNode);
            this.source.startDrag(dge, null, this.transferable, this);
            DragManager.setDragSource(this.table);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragManager.setDragSource(null);
        }
    }

    class UDOPopup
    extends JPopupMenu {
        public UDOPopup() {
            JMenuItem cut = new JMenuItem();
            cut.setText(BlueSystem.getString((String)"common.cut"));
            cut.addActionListener(ae -> OpcodeListEditPanel.this.cutUDO());
            JMenuItem copy = new JMenuItem();
            copy.setText(BlueSystem.getString((String)"common.copy"));
            copy.addActionListener(ae -> OpcodeListEditPanel.this.copyUDO());
            final JMenuItem paste = new JMenuItem();
            paste.setText(BlueSystem.getString((String)"common.paste"));
            paste.addActionListener(ae -> OpcodeListEditPanel.this.pasteUDO());
            final JMenu export = new JMenu("Export");
            JMenuItem exportBlueUdo = new JMenuItem();
            exportBlueUdo.setText("Blue UDO");
            exportBlueUdo.addActionListener(ae -> OpcodeListEditPanel.this.exportBlueUdo());
            JMenuItem exportCsoundUdo = new JMenuItem();
            exportCsoundUdo.setText("Csound UDO");
            exportCsoundUdo.addActionListener(ae -> OpcodeListEditPanel.this.exportCsoundUdo());
            export.add(exportBlueUdo);
            export.add(exportCsoundUdo);
            this.add(cut);
            this.add(copy);
            this.add(paste);
            this.addSeparator();
            this.add(export);
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    UDOBuffer buffer = UDOBuffer.getInstance();
                    Object obj = buffer.getBufferedObject();
                    paste.setEnabled(obj != null && (obj instanceof UserDefinedOpcode[] || obj instanceof UserDefinedOpcode || obj instanceof UDOCategory));
                    UserDefinedOpcode[] selected = OpcodeListEditPanel.this.getSelectedUDOs();
                    export.setEnabled(selected != null && selected.length == 1);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            File defaultFile = new File(GeneralSettings.getInstance().getDefaultDirectory() + File.separator + "default.blueUDO");
            File defaultCsoundUdoFile = new File(GeneralSettings.getInstance().getDefaultDirectory() + File.separator + "default.udo");
            FileChooserManager fcm = FileChooserManager.getDefault();
            fcm.addFilter((Object)OpcodeListEditPanel.EXPORT_BLUE_UDO_DIALOG, new FileChooser.ExtensionFilter("Blue UDO File", new String[]{"*.blueUDO"}));
            fcm.setDialogTitle((Object)OpcodeListEditPanel.EXPORT_BLUE_UDO_DIALOG, "Export Blue User-Defined Opcode");
            fcm.setSelectedFile((Object)OpcodeListEditPanel.EXPORT_BLUE_UDO_DIALOG, defaultFile);
            fcm.addFilter((Object)OpcodeListEditPanel.EXPORT_CSOUND_UDO_DIALOG, new FileChooser.ExtensionFilter("Csound UDO File", new String[]{"*.udo"}));
            fcm.setDialogTitle((Object)OpcodeListEditPanel.EXPORT_CSOUND_UDO_DIALOG, "Export Csound User-Defined Opcode");
            fcm.setSelectedFile((Object)OpcodeListEditPanel.EXPORT_CSOUND_UDO_DIALOG, defaultCsoundUdoFile);
        }
    }
}

