/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.noteProcessorChain;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorChain;
import blue.ui.core.score.noteProcessorChain.NoteProcessorEditProxy;
import blue.ui.core.score.noteProcessorChain.PropertyEditProxy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class NoteProcessorChainTableModel
extends AbstractTableModel {
    NoteProcessorChain npc;
    ArrayList props = new ArrayList();
    ArrayList npcProxies = new ArrayList();
    NoteProcessor currentNoteProcessor;

    protected void setCurrentNoteProcessor(NoteProcessor np) {
        this.currentNoteProcessor = np;
    }

    public void setCurrentNoteProcessor(int row) {
        for (NoteProcessorEditProxy element : this.npcProxies) {
            if (row < element.getStartRow() || row > element.getEndRow()) continue;
            this.currentNoteProcessor = element.getNoteProcessor();
            return;
        }
        this.currentNoteProcessor = null;
    }

    public int[] getHilightRows() {
        if (this.currentNoteProcessor == null) {
            return null;
        }
        for (NoteProcessorEditProxy element : this.npcProxies) {
            if (element.getNoteProcessor() != this.currentNoteProcessor) continue;
            return new int[]{element.getStartRow(), element.getEndRow()};
        }
        return null;
    }

    public boolean isTitleRow(int row) {
        Object obj = this.props.get(row);
        return obj instanceof NoteProcessorEditProxy;
    }

    public void setNoteProcessorChain(NoteProcessorChain npc) {
        this.npc = npc;
        this.props.clear();
        this.npcProxies.clear();
        this.currentNoteProcessor = null;
        if (npc == null) {
            this.fireTableDataChanged();
            return;
        }
        int startRow = 0;
        for (int i = 0; i < npc.size(); ++i) {
            startRow += this.setupNoteProcessor((NoteProcessor)npc.get(i), startRow);
        }
        this.fireTableDataChanged();
    }

    public int setupNoteProcessor(NoteProcessor np, int startRow) {
        Method[] m = np.getClass().getDeclaredMethods();
        ArrayList<Method> getMethods = new ArrayList<Method>();
        ArrayList<Method> setMethods = new ArrayList<Method>();
        for (int i = 0; i < m.length; ++i) {
            if (m[i].getName().toLowerCase().startsWith("get")) {
                getMethods.add(m[i]);
            }
            if (!m[i].getName().toLowerCase().startsWith("set")) continue;
            setMethods.add(m[i]);
        }
        int rowCount = 0;
        for (int i = 0; i < getMethods.size(); ++i) {
            Method getTemp = (Method)getMethods.get(i);
            Method setTemp = this.findSetMethod(getTemp, setMethods);
            if (setTemp == null) continue;
            String propName = setTemp.getName().substring(3);
            PropertyEditProxy proxy = new PropertyEditProxy(np, propName, getTemp, setTemp);
            this.props.add(proxy);
            ++rowCount;
        }
        NoteProcessorEditProxy npeProxy = new NoteProcessorEditProxy(np, startRow, startRow + rowCount);
        this.props.add(startRow, npeProxy);
        this.npcProxies.add(npeProxy);
        return rowCount + 1;
    }

    private Method findSetMethod(Method getMethod, ArrayList a) {
        String name = getMethod.getName().substring(3);
        for (int i = 0; i < a.size(); ++i) {
            Method temp = (Method)a.get(i);
            if (!temp.getName().endsWith(name)) continue;
            return temp;
        }
        return null;
    }

    public void addNoteProcessor(NoteProcessor np) {
        this.npc.add((Object)np);
        this.setNoteProcessorChain(this.npc);
    }

    public void removeNoteProcessor() {
        if (this.currentNoteProcessor == null) {
            return;
        }
        this.npc.remove((Object)this.currentNoteProcessor);
        this.setNoteProcessorChain(this.npc);
    }

    public void pushUpNoteProcessor() {
        if (this.currentNoteProcessor == null) {
            return;
        }
        int index = this.npc.indexOf((Object)this.currentNoteProcessor);
        if (index > 0) {
            NoteProcessor a = (NoteProcessor)this.npc.remove(index - 1);
            this.npc.add(index, (Object)a);
            NoteProcessor temp = this.currentNoteProcessor;
            this.setNoteProcessorChain(this.npc);
            this.setCurrentNoteProcessor(temp);
        }
    }

    public void pushDownNoteProcessor() {
        if (this.currentNoteProcessor == null) {
            return;
        }
        int index = this.npc.indexOf((Object)this.currentNoteProcessor);
        if (index < this.npc.size() - 1) {
            NoteProcessor a = (NoteProcessor)this.npc.remove(index + 1);
            this.npc.add(index, (Object)a);
            NoteProcessor temp = this.currentNoteProcessor;
            this.setNoteProcessorChain(this.npc);
            this.setCurrentNoteProcessor(temp);
        }
    }

    @Override
    public String getColumnName(int i) {
        if (i == 0) {
            return BlueSystem.getString((String)"propertyEditor.property");
        }
        return BlueSystem.getString((String)"propertyEditor.value");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object obj = this.props.get(row);
        if (obj instanceof NoteProcessorEditProxy) {
            if (column == 0) {
                return ((NoteProcessorEditProxy)obj).getName();
            }
            return "";
        }
        PropertyEditProxy temp = (PropertyEditProxy)obj;
        if (column == 0) {
            return temp.getPropertyName();
        }
        return temp.getValue();
    }

    @Override
    public int getRowCount() {
        return this.props.size();
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        Object obj = this.props.get(r);
        if (obj instanceof NoteProcessorEditProxy) {
            return false;
        }
        return c == 1;
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return String.class;
        }
        return PropertyEditProxy.class;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            try {
                PropertyEditProxy temp = (PropertyEditProxy)this.props.get(row);
                temp.setValue(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public NoteProcessor getCurrentNoteProcessor() {
        return this.currentNoteProcessor;
    }
}

