/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.manager;

import blue.BlueSystem;
import blue.score.Score;
import blue.score.layers.LayerGroup;
import blue.score.layers.LayerGroupProvider;
import blue.score.layers.LayerGroupProviderManager;
import blue.ui.core.score.layers.LayerGroupUIProviderManager;
import blue.ui.core.score.manager.LayerGroupTableModel;
import blue.ui.core.score.manager.LayersTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ScoreManagerDialog
extends JDialog {
    private final DefaultTableModel emptyList = new DefaultTableModel();
    private Score score;
    private JPopupMenu addLayerGroupMenu = null;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel5;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JButton lGroupAddButton;
    private JButton lGroupMinusButton;
    private JButton lGroupPushDownButton;
    private JButton lGroupPushUpButton;
    private JTable layerGroupsTable;
    private JButton layersAddButton;
    private JButton layersMinusButton;
    private JPanel layersPanel;
    private JButton layersPushDownButton;
    private JButton layersPushUpButton;
    private JTable layersTable;
    private JScrollPane propertiesScrollPane;
    private JTabbedPane tabs;

    public ScoreManagerDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        TableColumn col = this.layersTable.getTableHeader().getColumnModel().getColumn(0);
        col.setMaxWidth(50);
        col.setMinWidth(50);
        col.setPreferredWidth(50);
    }

    public void setScore(Score score) {
        this.score = score;
        this.layerGroupsTable.setModel(new LayerGroupTableModel(score));
        this.layersTable.setModel(this.emptyList);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.lGroupPushUpButton = new JButton();
        this.lGroupPushDownButton = new JButton();
        this.lGroupAddButton = new JButton();
        this.lGroupMinusButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.layerGroupsTable = new JTable(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return this.getPreferredSize().height < this.getParent().getHeight();
            }
        };
        this.tabs = new JTabbedPane();
        this.layersPanel = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.layersTable = new JTable(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return this.getPreferredSize().height < this.getParent().getHeight();
            }
        };
        this.jPanel2 = new JPanel();
        this.layersPushUpButton = new JButton();
        this.layersPushDownButton = new JButton();
        this.layersAddButton = new JButton();
        this.layersMinusButton = new JButton();
        this.propertiesScrollPane = new JScrollPane();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.title"));
        this.jSplitPane1.setDividerLocation(200);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel5.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(30, 20));
        this.jPanel1.setPreferredSize(new Dimension(160, 20));
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.lGroupPushUpButton.setText(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.lGroupPushUpButton.text"));
        this.lGroupPushUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScoreManagerDialog.this.lGroupPushUpButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.lGroupPushUpButton);
        this.lGroupPushDownButton.setText(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.lGroupPushDownButton.text"));
        this.lGroupPushDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScoreManagerDialog.this.lGroupPushDownButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.lGroupPushDownButton);
        this.lGroupAddButton.setText(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.lGroupAddButton.text"));
        this.lGroupAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScoreManagerDialog.this.lGroupAddButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.lGroupAddButton);
        this.lGroupMinusButton.setText(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.lGroupMinusButton.text"));
        this.lGroupMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScoreManagerDialog.this.lGroupMinusButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.lGroupMinusButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.jPanel5.add((Component)this.jPanel1, gridBagConstraints);
        this.layerGroupsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.layerGroupsTable.setSelectionMode(1);
        this.layerGroupsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ScoreManagerDialog.this.layerGroupsTableMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.layerGroupsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel5.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel5);
        this.layersPanel.setLayout(new GridBagLayout());
        this.layersTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.layersTable.setSelectionMode(1);
        this.jScrollPane4.setViewportView(this.layersTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.layersPanel.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jPanel2.setMinimumSize(new Dimension(30, 20));
        this.jPanel2.setPreferredSize(new Dimension(160, 20));
        this.jPanel2.setLayout(new GridLayout(1, 0));
        this.layersPushUpButton.setText(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.layersPushUpButton.text"));
        this.layersPushUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScoreManagerDialog.this.layersPushUpButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.layersPushUpButton);
        this.layersPushDownButton.setText(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.layersPushDownButton.text"));
        this.layersPushDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScoreManagerDialog.this.layersPushDownButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.layersPushDownButton);
        this.layersAddButton.setText(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.layersAddButton.text"));
        this.layersAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScoreManagerDialog.this.layersAddButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.layersAddButton);
        this.layersMinusButton.setText(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.layersMinusButton.text"));
        this.layersMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScoreManagerDialog.this.layersMinusButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.layersMinusButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.layersPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.tabs.addTab(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.layersPanel.TabConstraints.tabTitle"), this.layersPanel);
        this.tabs.addTab(NbBundle.getMessage(ScoreManagerDialog.class, (String)"ScoreManagerDialog.propertiesScrollPane.TabConstraints.tabTitle"), this.propertiesScrollPane);
        this.jSplitPane1.setRightComponent(this.tabs);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    private void lGroupMinusButtonActionPerformed(ActionEvent evt) {
        if (this.layerGroupsTable.getSelectedRow() == -1) {
            return;
        }
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)"Deleting Layer Groups can not be undone. Please Confirm.", "Confirm Delete", 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.OK_OPTION) {
            LayerGroupTableModel model = this.getLayerGroupListModel();
            ListSelectionModel selection = this.layerGroupsTable.getSelectionModel();
            int startIndex = selection.getMinSelectionIndex();
            int endIndex = selection.getMaxSelectionIndex();
            selection.clearSelection();
            model.removeLayerGroups(startIndex, endIndex);
        }
    }

    private void lGroupAddButtonActionPerformed(ActionEvent evt) {
        JPopupMenu menu = this.getAddLayerGroupMenu();
        Point p = SwingUtilities.convertPoint(this.lGroupAddButton, 0, 0, this);
        menu.show(this, p.x, p.y + this.lGroupAddButton.getHeight());
    }

    private void lGroupPushUpButtonActionPerformed(ActionEvent evt) {
        ListSelectionModel selection = this.layerGroupsTable.getSelectionModel();
        int start = selection.getMinSelectionIndex();
        int end = selection.getMaxSelectionIndex();
        if (start <= 0) {
            return;
        }
        LayerGroupTableModel model = this.getLayerGroupListModel();
        model.pushUpLayerGroups(start, end);
        selection.setSelectionInterval(start - 1, end - 1);
    }

    private void lGroupPushDownButtonActionPerformed(ActionEvent evt) {
        ListSelectionModel selection = this.layerGroupsTable.getSelectionModel();
        int start = selection.getMinSelectionIndex();
        int end = selection.getMaxSelectionIndex();
        if (start < 0 || end >= this.score.size() - 1) {
            return;
        }
        LayerGroupTableModel model = this.getLayerGroupListModel();
        model.pushDownLayerGroups(start, end);
        selection.setSelectionInterval(start + 1, end + 1);
    }

    private void layersPushUpButtonActionPerformed(ActionEvent evt) {
        LayersTableModel model = this.getLayersListModel();
        if (model == null) {
            return;
        }
        ListSelectionModel selection = this.layersTable.getSelectionModel();
        int start = selection.getMinSelectionIndex();
        int end = selection.getMaxSelectionIndex();
        if (end < 0 || start == 0) {
            return;
        }
        model.pushUpLayers(start, end);
        selection.setSelectionInterval(start - 1, end - 1);
    }

    private void layersPushDownButtonActionPerformed(ActionEvent evt) {
        LayersTableModel model = this.getLayersListModel();
        if (model == null) {
            return;
        }
        ListSelectionModel selection = this.layersTable.getSelectionModel();
        int start = selection.getMinSelectionIndex();
        int end = selection.getMaxSelectionIndex();
        if (end < 0 || end >= model.getRowCount() - 1) {
            return;
        }
        model.pushDownLayers(start, end);
        selection.setSelectionInterval(start + 1, end + 1);
    }

    private void layersAddButtonActionPerformed(ActionEvent evt) {
        LayersTableModel model = this.getLayersListModel();
        if (model == null) {
            return;
        }
        ListSelectionModel selection = this.layersTable.getSelectionModel();
        int end = selection.getMaxSelectionIndex();
        end = end < 0 ? model.getRowCount() : ++end;
        model.newLayerAt(end);
        selection.setSelectionInterval(end, end);
    }

    private void layersMinusButtonActionPerformed(ActionEvent evt) {
        LayersTableModel model = this.getLayersListModel();
        if (model == null) {
            return;
        }
        ListSelectionModel selection = this.layersTable.getSelectionModel();
        int start = selection.getMinSelectionIndex();
        int end = selection.getMaxSelectionIndex();
        if (end < 0 || model.getRowCount() < 2) {
            return;
        }
        int len = end - start + 1;
        String message = BlueSystem.getString((String)"soundLayerEditPanel.delete.message1") + " " + len + " " + BlueSystem.getString((String)"soundLayerEditPanel.delete.message2");
        if (JOptionPane.showConfirmDialog(null, message) == 0) {
            model.removeLayers(start, end);
            selection.clearSelection();
        }
    }

    private void layerGroupsTableMouseClicked(MouseEvent evt) {
        if (this.layerGroupsTable.isEditing()) {
            return;
        }
        int rowIndex = this.layerGroupsTable.getSelectedRow();
        if (rowIndex < 0) {
            this.layersTable.setModel(this.emptyList);
            this.propertiesScrollPane.setViewportView(null);
        } else {
            LayerGroup layerGroup = (LayerGroup)this.score.get(rowIndex);
            this.layersTable.setModel(new LayersTableModel(layerGroup));
            TableColumn col = this.layersTable.getTableHeader().getColumnModel().getColumn(0);
            col.setMaxWidth(50);
            col.setMinWidth(50);
            col.setPreferredWidth(50);
            this.propertiesScrollPane.setViewportView(null);
            LayerGroupUIProviderManager manager = LayerGroupUIProviderManager.getInstance();
            JComponent comp = manager.getLayerGroupPropertiesPanel(layerGroup);
            if (comp != null) {
                this.propertiesScrollPane.setViewportView(comp);
            }
        }
    }

    private LayerGroupTableModel getLayerGroupListModel() {
        return (LayerGroupTableModel)this.layerGroupsTable.getModel();
    }

    private LayersTableModel getLayersListModel() {
        if (this.layersTable.getModel() == this.emptyList) {
            return null;
        }
        return (LayersTableModel)this.layersTable.getModel();
    }

    private JPopupMenu getAddLayerGroupMenu() {
        if (this.addLayerGroupMenu == null) {
            this.addLayerGroupMenu = new JPopupMenu();
            ActionListener listener = e -> {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                LayerGroupProvider provider = (LayerGroupProvider)menuItem.getClientProperty("provider");
                LayerGroup layerGroup = provider.createLayerGroup();
                LayerGroupTableModel model = this.getLayerGroupListModel();
                int index = this.layerGroupsTable.getSelectionModel().getMaxSelectionIndex();
                if (index < 0 || index > model.getRowCount()) {
                    index = model.getRowCount();
                    model.addLayerGroup(index, layerGroup);
                } else {
                    model.addLayerGroup(index, layerGroup);
                }
                ListSelectionModel selection = this.layerGroupsTable.getSelectionModel();
                selection.setSelectionInterval(index, index);
            };
            LayerGroupProviderManager manager = LayerGroupProviderManager.getInstance();
            for (LayerGroupProvider provider : manager) {
                JMenuItem item = new JMenuItem("Add " + provider.getLayerGroupName() + " Layer Group");
                item.putClientProperty("provider", provider);
                item.addActionListener(listener);
                this.addLayerGroupMenu.add(item);
            }
        }
        return this.addLayerGroupMenu;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ScoreManagerDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> {
            ScoreManagerDialog dialog = new ScoreManagerDialog((Frame)new JFrame(), true);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            dialog.setVisible(true);
        });
    }
}

