/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.manager;

import blue.score.Score;
import blue.score.layers.LayerGroup;
import java.util.ArrayList;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

public class LayerGroupTableModel
extends AbstractTableModel {
    private Score score;
    private final ArrayList<ListDataListener> listeners = new ArrayList();

    public LayerGroupTableModel(Score score) {
        this.score = score;
    }

    @Override
    public int getRowCount() {
        return this.score.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            ((LayerGroup)this.score.get(rowIndex)).setName((String)aValue);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return ((LayerGroup)this.score.get(rowIndex)).getName();
    }

    @Override
    public String getColumnName(int column) {
        return "Name";
    }

    public void addLayerGroup(int index, LayerGroup layerGroup) {
        this.score.add(index, (Object)layerGroup);
        this.fireTableRowsInserted(index, index);
    }

    void removeLayerGroups(int minSelectionIndex, int maxSelectionIndex) {
        for (int i = 0; i < maxSelectionIndex - minSelectionIndex + 1; ++i) {
            this.score.remove(minSelectionIndex);
        }
        this.fireTableRowsDeleted(minSelectionIndex, maxSelectionIndex);
    }

    void pushUpLayerGroups(int start, int end) {
        this.score.pushUpItems(start, end);
        this.fireTableRowsUpdated(start - 1, end);
    }

    void pushDownLayerGroups(int start, int end) {
        this.score.pushDownItems(start, end);
        this.fireTableRowsUpdated(start, end + 1);
    }
}

