/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject.actions;

import blue.BlueSystem;
import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.score.layers.ScoreObjectLayer;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ScoreTopComponent;
import blue.ui.core.score.layers.soundObject.ScoreTimeCanvas;
import blue.ui.core.score.undo.AddScoreObjectEdit;
import blue.ui.nbutilities.lazyplugin.LazyPlugin;
import blue.ui.nbutilities.lazyplugin.LazyPluginFactory;
import blue.undo.BlueUndoManager;
import blue.utility.ScoreUtilities;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.undo.UndoableEdit;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.windows.WindowManager;

public final class AddSoundObjectActionsPresenter
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    Map<String, Class> sObjNameClassMap = new HashMap<String, Class>();
    JMenu menu = null;
    WeakReference<Point> pRef = null;
    WeakReference<ScoreTimeCanvas> sTimeCanvasRef = null;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.pRef == null || this.sTimeCanvasRef == null) {
            return;
        }
        ScoreTimeCanvas sTimeCanvas = (ScoreTimeCanvas)this.sTimeCanvasRef.get();
        Point p = (Point)this.pRef.get();
        int sLayerIndex = sTimeCanvas.getPolyObject().getLayerNumForY((int)p.getY());
        ScoreTopComponent stc = (ScoreTopComponent)WindowManager.getDefault().findTopComponent("ScoreTopComponent");
        LazyPlugin plugin = (LazyPlugin)((JMenuItem)e.getSource()).getClientProperty("plugin");
        try {
            SoundObject sObj = (SoundObject)((SoundObject)plugin.getInstance()).getClass().newInstance();
            if (sObj instanceof PolyObject) {
                ((PolyObject)sObj).newLayerAt(0);
            }
            TimeState timeState = stc.getTimeState();
            double start = p.getX() / (double)timeState.getPixelSecond();
            if (timeState.isSnapEnabled()) {
                start = ScoreUtilities.getSnapValueStart((double)start, (double)timeState.getSnapValue());
            }
            sObj.setStartTime(start);
            sTimeCanvas.getPolyObject().addSoundObject(sLayerIndex, sObj);
            BlueUndoManager.setUndoManager((String)"score");
            BlueUndoManager.addEdit((UndoableEdit)new AddScoreObjectEdit((ScoreObjectLayer)sTimeCanvas.getPolyObject().get(sLayerIndex), (ScoreObject)sObj));
        }
        catch (IllegalAccessException | InstantiationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public JMenuItem getPopupPresenter() {
        if (this.menu == null) {
            this.menu = new JMenu("Add SoundObject");
            List plugins = LazyPluginFactory.loadPlugins((String)"blue/score/soundObjects", SoundObject.class);
            for (LazyPlugin plugin : plugins) {
                JMenuItem temp = new JMenuItem();
                temp.setText(BlueSystem.getString((String)"soundLayerPopup.addNew") + " " + plugin.getDisplayName());
                temp.putClientProperty("plugin", plugin);
                temp.setActionCommand(plugin.getDisplayName());
                temp.addActionListener(this);
                this.menu.add(temp);
            }
        }
        return this.menu;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        this.pRef = new WeakReference<Object>(actionContext.lookup(Point.class));
        this.sTimeCanvasRef = new WeakReference<Object>(actionContext.lookup(ScoreTimeCanvas.class));
        return this;
    }
}

