/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject;

import blue.BlueSystem;
import blue.score.TimeState;
import blue.soundObject.AudioFile;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.ui.core.score.layers.soundObject.ScoreTimeCanvas;
import blue.utility.SoundFileUtilities;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ScoreTimelineDropTargetListener
implements DropTargetListener {
    DropTarget target;
    private ScoreTimeCanvas sTimeCanvas;
    TimeState timeState;

    public ScoreTimelineDropTargetListener(ScoreTimeCanvas sTimeCanvas) {
        this.sTimeCanvas = sTimeCanvas;
        this.target = new DropTarget(sTimeCanvas, this);
    }

    public void setTimeState(TimeState timeState) {
        this.timeState = timeState;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        boolean isFile = dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        if (!isFile && dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            isFile = true;
        }
        if (isFile) {
            dtde.acceptDrag(0x40000000);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(0x40000000);
                List list = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() != 1) {
                    dtde.dropComplete(false);
                    return;
                }
                String s = list.get(0).toString().trim();
                if (!(s.toLowerCase().endsWith("wav") || s.toLowerCase().endsWith("aif") || s.toLowerCase().endsWith("aiff"))) {
                    dtde.dropComplete(false);
                    return;
                }
                String sObjName = s.substring(s.lastIndexOf(File.separator) + 1);
                Point p = dtde.getLocation();
                int index = this.sTimeCanvas.pObj.getLayerNumForY(p.y);
                AudioFile af = new AudioFile();
                af.setName(sObjName);
                af.setSoundFileName(BlueSystem.getRelativePath((String)s));
                PolyObject pObj = this.sTimeCanvas.getPolyObject();
                float startTime = (float)p.x / (float)this.timeState.getPixelSecond();
                float dur = SoundFileUtilities.getDurationInSeconds((String)s);
                af.setStartTime((double)startTime);
                af.setSubjectiveDuration((double)dur);
                pObj.addSoundObject(index, (SoundObject)af);
                dtde.dropComplete(true);
                return;
            }
            if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrop(0x40000000);
                String str = (String)tr.getTransferData(DataFlavor.stringFlavor);
                if (!str.startsWith("file://")) {
                    dtde.dropComplete(false);
                    return;
                }
                if (!((str = str.substring(7).trim()).toLowerCase().endsWith("wav") || str.toLowerCase().endsWith("aif") || str.toLowerCase().endsWith("aiff"))) {
                    System.err.println("Could not open file: " + str);
                    dtde.dropComplete(false);
                    return;
                }
                str = URLDecoder.decode(str);
                File f = new File(str = str.replaceAll(" ", "\\ "));
                if (!f.exists()) {
                    dtde.dropComplete(false);
                    return;
                }
                String sObjName = str.substring(str.lastIndexOf(File.separator) + 1);
                Point p = dtde.getLocation();
                int index = this.sTimeCanvas.pObj.getLayerNumForY(p.y);
                AudioFile af = new AudioFile();
                af.setName(sObjName);
                af.setSoundFileName(str);
                PolyObject pObj = this.sTimeCanvas.getPolyObject();
                float startTime = (float)p.x / (float)this.timeState.getPixelSecond();
                float dur = SoundFileUtilities.getDurationInSeconds((String)str);
                af.setStartTime((double)startTime);
                af.setSubjectiveDuration((double)dur);
                pObj.addSoundObject(index, (SoundObject)af);
                dtde.dropComplete(true);
                return;
            }
            dtde.rejectDrop();
        }
        catch (UnsupportedFlavorException | IOException | UnsupportedAudioFileException e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }
}

