/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor.blueX7;

import blue.orchestra.blueX7.EnvelopePoint;
import blue.ui.core.orchestra.editor.blueX7.EnvelopeEditor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class EnvelopeMouseListener
implements MouseListener,
MouseMotionListener {
    EnvelopeEditor env;
    EnvelopePoint p;
    int minX;
    int maxX;

    public EnvelopeMouseListener(EnvelopeEditor env) {
        this.env = env;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.env.points != null) {
            int pointX = e.getX();
            int pointY = e.getY();
            int xMaxWidth = this.env.getWidth() / 4;
            int yMaxHeight = this.env.getHeight();
            int runningX = 0;
            for (int i = 0; i < this.env.points.length; ++i) {
                int newX = runningX + (int)((float)this.env.points[i].x / 99.0f * (float)xMaxWidth);
                int newY = (int)((1.0f - (float)this.env.points[i].y / 99.0f) * (float)yMaxHeight);
                if (pointX > newX - 3 && pointX < newX + 3 && pointY > newY - 3 && pointY < newY + 3) {
                    this.p = this.env.points[i];
                    this.minX = runningX;
                    this.maxX = runningX + xMaxWidth;
                }
                runningX += (int)((float)this.env.points[i].x / 99.0f * (float)xMaxWidth);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.p = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.p != null) {
            int xMaxWidth = this.env.getWidth() / 4;
            int yMaxHeight = this.env.getHeight();
            int newX = e.getX() - this.minX;
            int newY = e.getY();
            if (newX < 0) {
                newX = 0;
            } else if (newX > xMaxWidth) {
                newX = xMaxWidth;
            }
            if (newY < 0) {
                newY = 0;
            } else if (newY > yMaxHeight) {
                newY = yMaxHeight;
            }
            newX = Math.round((float)newX / (float)xMaxWidth * 99.0f);
            newY = Math.round((1.0f - (float)newY / (float)yMaxHeight) * 99.0f);
            this.p.x = newX;
            this.p.y = newY;
            this.env.repaint();
            if (this.env.pl != null) {
                this.env.pl.updateLabels();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

