/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra;

import blue.BlueSystem;
import blue.CopyBuffer;
import blue.orchestra.Instrument;
import blue.orchestra.InstrumentCategory;
import blue.ui.core.orchestra.UserInstrumentLibrary;
import blue.ui.nbutilities.lazyplugin.LazyPlugin;
import blue.ui.nbutilities.lazyplugin.LazyPluginFactory;
import blue.ui.utilities.FileChooserManager;
import blue.utility.ObjectUtilities;
import electric.xml.Document;
import electric.xml.Element;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

class UserInstrumentTreePopup
extends JPopupMenu {
    private static final String IMPORT_DIALOG = "instr.import";
    private static final String EXPORT_DIALOG = "instr.export";
    Object userObj;
    UserInstrumentLibrary instrGUI;
    JMenuItem addCategoryMenuItem = new JMenuItem(BlueSystem.getString((String)"codeRepository.addGroup"));
    JMenuItem removeCategoryMenuItem = new JMenuItem(BlueSystem.getString((String)"codeRepository.removeGroup"));
    JMenu addInstrumentMenu;
    JMenuItem removeInstrumentMenuItem = new JMenuItem(BlueSystem.getString((String)"instrument.remove"));
    JMenuItem cutMenuItem = new JMenuItem(BlueSystem.getString((String)"instrument.cut"));
    JMenuItem copyMenuItem = new JMenuItem(BlueSystem.getString((String)"instrument.copy"));
    JMenuItem pasteMenuItem = new JMenuItem(BlueSystem.getString((String)"instrument.paste"));
    JPopupMenu.Separator sep = new JPopupMenu.Separator();
    Action importItem;
    Action exportItem;

    public UserInstrumentTreePopup() {
        this.addCategoryMenuItem.addActionListener(e -> this.addInstrumentCategory());
        this.removeCategoryMenuItem.addActionListener(e -> this.removeInstrumentCategory());
        this.removeInstrumentMenuItem.addActionListener(e -> this.removeInstrument());
        this.cutMenuItem.addActionListener(e -> this.cutNode());
        this.copyMenuItem.addActionListener(e -> this.copyNode());
        this.pasteMenuItem.addActionListener(e -> this.pasteNode());
        this.importItem = new AbstractAction(BlueSystem.getString((String)"common.import")){

            @Override
            public void actionPerformed(ActionEvent e) {
                List retVal = FileChooserManager.getDefault().showOpenDialog((Object)UserInstrumentTreePopup.IMPORT_DIALOG, SwingUtilities.getRoot(UserInstrumentTreePopup.this.instrGUI));
                if (!retVal.isEmpty()) {
                    File f = (File)retVal.get(0);
                    try {
                        Document doc = new Document(f);
                        Element root = doc.getRoot();
                        if (root.getName().equals("instrument")) {
                            Instrument tempInstr = (Instrument)ObjectUtilities.loadFromXML((Element)root);
                            UserInstrumentTreePopup.this.addInstrument(tempInstr);
                        } else {
                            JOptionPane.showMessageDialog(SwingUtilities.getRoot(UserInstrumentTreePopup.this.instrGUI), "Error: File did not contain instrument", "Error", 0);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot(UserInstrumentTreePopup.this.instrGUI), "Error: Could not read instrument from file", "Error", 0);
                    }
                }
            }
        };
        this.exportItem = new AbstractAction(BlueSystem.getString((String)"common.export")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UserInstrumentTreePopup.this.userObj == null || !(UserInstrumentTreePopup.this.userObj instanceof Instrument)) {
                    return;
                }
                File retVal = FileChooserManager.getDefault().showSaveDialog((Object)UserInstrumentTreePopup.EXPORT_DIALOG, SwingUtilities.getRoot(UserInstrumentTreePopup.this.instrGUI));
                if (retVal != null) {
                    int overWrite;
                    File f = retVal;
                    if (f.exists() && (overWrite = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(UserInstrumentTreePopup.this.instrGUI), "Please confirm you would like to overwrite this file.")) != 0) {
                        return;
                    }
                    Element node = ((Instrument)UserInstrumentTreePopup.this.userObj).saveAsXML();
                    try {
                        PrintWriter out = new PrintWriter(new FileWriter(f));
                        out.print(node.toString());
                        out.flush();
                        out.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        this.addInstrumentMenu = this.getAddInstrumentMenu();
        this.add(this.addCategoryMenuItem);
        this.add(this.removeCategoryMenuItem);
        this.add(this.sep);
        this.add(this.addInstrumentMenu);
        this.add(this.removeInstrumentMenuItem);
        this.addSeparator();
        this.add(this.cutMenuItem);
        this.add(this.copyMenuItem);
        this.add(this.pasteMenuItem);
        this.addSeparator();
        this.add(this.importItem);
        this.add(this.exportItem);
    }

    public void setUserObj(Object obj) {
        this.userObj = obj;
    }

    public void setInstrumentGUI(UserInstrumentLibrary instrGUI) {
        this.instrGUI = instrGUI;
    }

    protected void cutNode() {
        if (this.userObj == this.instrGUI.iLibrary.getRoot() || this.userObj == null) {
            return;
        }
        this.copyNode();
        this.deleteNode();
    }

    protected void deleteNode() {
        if (this.userObj == this.instrGUI.iLibrary.getRoot()) {
            return;
        }
        if (this.userObj instanceof Instrument) {
            this.removeInstrument();
        } else {
            this.removeInstrumentCategory();
        }
    }

    protected void copyNode() {
        if (this.userObj == this.instrGUI.iLibrary.getRoot()) {
            return;
        }
        if (this.userObj instanceof Instrument) {
            Object bufferedObj = ((Instrument)this.userObj).deepCopy();
        } else {
            InstrumentCategory bufferedObj = new InstrumentCategory((InstrumentCategory)this.userObj);
        }
        CopyBuffer.setBufferedObject((String)CopyBuffer.INSTRUMENT, (Object)this.userObj);
    }

    protected void pasteNode() {
        if (this.userObj instanceof Instrument) {
            return;
        }
        Object bufferedObj = CopyBuffer.getBufferedObject((String)CopyBuffer.INSTRUMENT);
        if (bufferedObj instanceof Instrument) {
            this.addInstrument((Instrument)bufferedObj);
        } else {
            this.addInstrumentCategory(new InstrumentCategory((InstrumentCategory)bufferedObj));
        }
    }

    private void addInstrumentCategory() {
        InstrumentCategory newCategory = new InstrumentCategory();
        this.addInstrumentCategory(newCategory);
    }

    private void addInstrumentCategory(InstrumentCategory iCategory) {
        if (this.userObj instanceof Instrument) {
            return;
        }
        this.instrGUI.iLibrary.addCategory((InstrumentCategory)this.userObj, iCategory);
    }

    private void removeInstrumentCategory() {
        InstrumentCategory category = (InstrumentCategory)this.userObj;
        if (0 == JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), "Please confirm deleting folder (this action is not undoable at this time).", "Confirm", 2, 3)) {
            this.instrGUI.iLibrary.removeCategory(category);
        }
    }

    private void addInstrument(Instrument instr) {
        Instrument newInstrument = (Instrument)instr.deepCopy();
        InstrumentCategory currentCategory = (InstrumentCategory)this.userObj;
        this.instrGUI.iLibrary.addInstrument(currentCategory, newInstrument);
    }

    private void removeInstrument() {
        Instrument instrument = (Instrument)this.userObj;
        this.instrGUI.removeInstrument(instrument);
    }

    public void show(UserInstrumentLibrary instrGui, Object userObj, int x, int y) {
        this.instrGUI = instrGui;
        this.userObj = userObj;
        if (userObj instanceof InstrumentCategory) {
            this.addCategoryMenuItem.setVisible(true);
            if (((InstrumentCategory)userObj).isRoot()) {
                this.removeCategoryMenuItem.setVisible(false);
            } else {
                this.removeCategoryMenuItem.setVisible(true);
            }
            this.addInstrumentMenu.setVisible(true);
            this.removeInstrumentMenuItem.setVisible(false);
            this.sep.setVisible(true);
            this.importItem.setEnabled(true);
            this.exportItem.setEnabled(false);
        } else {
            this.addCategoryMenuItem.setVisible(false);
            this.removeCategoryMenuItem.setVisible(false);
            this.addInstrumentMenu.setVisible(false);
            this.removeInstrumentMenuItem.setVisible(true);
            this.sep.setVisible(false);
            this.importItem.setEnabled(false);
            this.exportItem.setEnabled(true);
        }
        this.setBufferMenuItems();
        super.show(instrGui, x, y);
    }

    private void setBufferMenuItems() {
        this.pasteMenuItem.setEnabled(CopyBuffer.getBufferedObject((String)CopyBuffer.INSTRUMENT) != null);
        if (this.userObj instanceof InstrumentCategory && ((InstrumentCategory)this.userObj).isRoot()) {
            this.cutMenuItem.setEnabled(false);
            this.copyMenuItem.setEnabled(false);
        } else {
            this.cutMenuItem.setEnabled(true);
            this.copyMenuItem.setEnabled(true);
        }
        this.cutMenuItem.setText(BlueSystem.getString((String)"common.cut"));
        this.copyMenuItem.setText(BlueSystem.getString((String)"common.copy"));
        this.pasteMenuItem.setText(BlueSystem.getString((String)"common.paste"));
    }

    private JMenu getAddInstrumentMenu() {
        JMenu instrumentMenu = new JMenu("Add Instrument");
        List plugins = LazyPluginFactory.loadPlugins((String)"blue/instruments", Instrument.class);
        this.setLabel("Add Instrument");
        ActionListener al = e -> {
            LazyPlugin plugin = (LazyPlugin)((JMenuItem)e.getSource()).getClientProperty("plugin");
            Instrument instrTemplate = (Instrument)plugin.getInstance();
            try {
                Instrument newInstrument = (Instrument)instrTemplate.getClass().newInstance();
                this.addInstrument(newInstrument);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        };
        for (LazyPlugin plugin : plugins) {
            JMenuItem temp = new JMenuItem();
            temp.setText(plugin.getDisplayName());
            temp.putClientProperty("plugin", plugin);
            temp.addActionListener(al);
            instrumentMenu.add(temp);
        }
        return instrumentMenu;
    }
}

