/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core;

import blue.BlueConstants;
import blue.BlueSystem;
import blue.MainToolBar;
import blue.WindowSettingManager;
import blue.automation.ParameterTimeManager;
import blue.automation.ParameterTimeManagerFactory;
import blue.automation.ParameterTimeManagerImpl;
import blue.midi.MidiInputManager;
import blue.osc.OSCManager;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.score.layers.LayerGroupProvider;
import blue.score.layers.LayerGroupProviderManager;
import blue.scripting.PythonProxy;
import blue.settings.ProjectDefaultsSettings;
import blue.soundObject.PolyObjectLayerGroupProvider;
import blue.ui.core.BackupFileSaver;
import blue.ui.core.OSCActions;
import blue.ui.core.TempFileCleaner;
import blue.ui.core.blueLive.BlueLiveToolBar;
import blue.ui.core.midi.MidiInputEngine;
import blue.ui.core.render.RealtimeRenderManager;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Locale;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javax.sound.midi.Receiver;
import javax.swing.SwingUtilities;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    BackupFileSaver backupFileSaver;
    private PropertyChangeListener windowTitlePropertyChangeListener;
    private final TempFileCleaner tempFileCleaner = new TempFileCleaner();
    private static final Logger logger = Logger.getLogger(Installer.class.getName());
    Lookup.Result<LayerGroupProvider> result = null;
    private LookupListener lookupListener;

    public void restored() {
        Locale.setDefault(Locale.Category.FORMAT, Locale.ENGLISH);
        System.setProperty("jffi.unsafe.disabled", "true");
        PolyObjectLayerGroupProvider.setDefaultHeightIndexProvider(() -> ProjectDefaultsSettings.getInstance().layerHeightDefault);
        ParameterTimeManagerFactory.setInstance((ParameterTimeManager)new ParameterTimeManagerImpl());
        this.windowTitlePropertyChangeListener = evt -> SwingUtilities.invokeLater(() -> {
            if (WindowManager.getDefault().getMainWindow() != null) {
                this.setWindowTitle();
            }
        });
        BlueProjectManager.getInstance().addPropertyChangeListener(this.windowTitlePropertyChangeListener);
        BlueProjectManager.getInstance().addPropertyChangeListener((PropertyChangeListener)this.tempFileCleaner);
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            this.setWindowTitle();
            this.backupFileSaver = new BackupFileSaver();
            Thread t = new Thread(this.backupFileSaver);
            t.setPriority(1);
            t.setDaemon(true);
            t.start();
        });
        PythonProxy.setLibDir((File)InstalledFileLocator.getDefault().locate("pythonLib", "jython", false));
        SwingUtilities.invokeLater(() -> MidiInputManager.getInstance().addReceiver((Receiver)MidiInputEngine.getInstance()));
        OSCManager oscManager = OSCManager.getInstance();
        OSCActions.installActions(oscManager);
        oscManager.start();
        Lookup lkp = Lookups.forPath((String)"blue/score/layers");
        this.result = lkp.lookupResult(LayerGroupProvider.class);
        this.result.addLookupListener(this.lookupListener);
        LayerGroupProviderManager.getInstance().updateProviders(this.result.allInstances());
        this.lookupListener = ev -> LayerGroupProviderManager.getInstance().updateProviders(this.result.allInstances());
        Platform.setImplicitExit((boolean)false);
        new JFXPanel();
    }

    public void uninstalled() {
        ParameterTimeManagerFactory.setInstance(null);
        BlueProjectManager.getInstance().removePropertyChangeListener(this.windowTitlePropertyChangeListener);
        BlueProjectManager.getInstance().removePropertyChangeListener((PropertyChangeListener)this.tempFileCleaner);
        MidiInputManager.getInstance().removeReceiver((Receiver)MidiInputEngine.getInstance());
        RealtimeRenderManager.getInstance().stopAuditioning();
        RealtimeRenderManager.getInstance().shutdown();
        logger.info("blue-ui-core Installer uninstalled");
    }

    private void setWindowTitle() {
        BlueProjectManager bpm = BlueProjectManager.getInstance();
        BlueProject proj = bpm.getCurrentProject();
        String title = "blue - " + BlueConstants.getVersion();
        if (proj != null) {
            title = title + " - ";
            title = proj.getDataFile() == null ? title + "New Project" : title + proj.getDataFile().getName();
        }
        String t = title;
        SwingUtilities.invokeLater(() -> WindowManager.getDefault().getMainWindow().setTitle(t));
    }

    public boolean closing() {
        return BlueProjectManager.getInstance().closeAllFiles();
    }

    public void close() {
        this.backupFileSaver.quitFileSaver();
        this.saveLibraries();
        WindowSettingManager.getInstance().save();
        MainToolBar.getInstance().stopRendering();
        BlueLiveToolBar.getInstance().stopRendering();
        this.result.removeLookupListener(this.lookupListener);
        RealtimeRenderManager.getInstance().stopRendering();
        RealtimeRenderManager.getInstance().stopBlueLiveRendering();
        super.close();
    }

    public void saveLibraries() {
        BlueSystem.saveUserInstrumentLibrary();
        BlueSystem.saveUDOLibrary();
        BlueSystem.saveSoundObjectLibrary();
    }
}

