/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.blueShare;

import blue.BlueSystem;
import blue.WindowSettingManager;
import blue.WindowSettingsSavable;
import blue.tools.blueShare.effects.BlueShareEffectCategory;
import blue.tools.blueShare.effects.EffectExportPane;
import blue.tools.blueShare.effects.EffectImportPane;
import blue.tools.blueShare.effects.EffectManagementPane;
import blue.tools.blueShare.instruments.BlueShareInstrumentCategory;
import blue.tools.blueShare.instruments.InstrumentExportPane;
import blue.tools.blueShare.instruments.InstrumentImportPane;
import blue.tools.blueShare.instruments.InstrumentManagementPane;
import blue.tools.blueShare.soundObjects.BlueShareSoundObjectCategory;
import blue.tools.blueShare.soundObjects.SoundObjectExportPane;
import blue.tools.blueShare.soundObjects.SoundObjectImportPane;
import blue.tools.blueShare.soundObjects.SoundObjectManagementPane;
import blue.utility.GUI;
import electric.xml.Element;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;

public class BlueShareDialog
extends JDialog
implements WindowSettingsSavable {
    InstrumentImportPane iPane = new InstrumentImportPane();
    InstrumentExportPane iExportPane = new InstrumentExportPane();
    EffectImportPane ePane = new EffectImportPane();
    EffectExportPane eExportPane = new EffectExportPane();
    SoundObjectImportPane sPane = new SoundObjectImportPane();
    SoundObjectExportPane sExportPane = new SoundObjectExportPane();

    public BlueShareDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle(".: Blue Share :.");
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane instrumentTabs = this.getInstrumentPane();
        JTabbedPane effectTabs = this.getEffectsPane();
        JTabbedPane soundObjectTabs = this.getSoundObjectsPane();
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("Instruments", instrumentTabs);
        tabs.add("Effects", effectTabs);
        tabs.add("SoundObjects", soundObjectTabs);
        this.getContentPane().add(tabs);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                BlueShareDialog.this.dispose();
            }
        });
        this.setSize(800, 600);
        GUI.centerOnScreen((Component)this);
        WindowSettingManager.getInstance().registerWindow("BlueShareDialog", this);
    }

    public void setInstrumentCategories(BlueShareInstrumentCategory[] categories) {
        this.iPane.setCategories(categories);
        this.iExportPane.setCategories(categories);
    }

    public void setEffectCategories(BlueShareEffectCategory[] effectCategories) {
        this.ePane.setCategories(effectCategories);
        this.eExportPane.setCategories(effectCategories);
    }

    public void setSoundObjectCategories(BlueShareSoundObjectCategory[] sobjCategories) {
        this.sPane.setCategories(sobjCategories);
        this.sExportPane.setCategories(sobjCategories);
    }

    private JTabbedPane getInstrumentPane() {
        InstrumentManagementPane iManagePane = new InstrumentManagementPane();
        JTabbedPane tabs = new JTabbedPane();
        tabs.add(BlueSystem.getString((String)"common.import"), this.iPane);
        tabs.add(BlueSystem.getString((String)"common.export"), this.iExportPane);
        tabs.add(BlueSystem.getString((String)"common.manage"), iManagePane);
        return tabs;
    }

    private JTabbedPane getEffectsPane() {
        EffectManagementPane eManagePane = new EffectManagementPane();
        JTabbedPane tabs = new JTabbedPane();
        tabs.add(BlueSystem.getString((String)"common.import"), this.ePane);
        tabs.add(BlueSystem.getString((String)"common.export"), this.eExportPane);
        tabs.add(BlueSystem.getString((String)"common.manage"), eManagePane);
        return tabs;
    }

    private JTabbedPane getSoundObjectsPane() {
        SoundObjectManagementPane sManagePane = new SoundObjectManagementPane();
        JTabbedPane tabs = new JTabbedPane();
        tabs.add(BlueSystem.getString((String)"common.import"), this.sPane);
        tabs.add(BlueSystem.getString((String)"common.export"), this.sExportPane);
        tabs.add(BlueSystem.getString((String)"common.manage"), sManagePane);
        return tabs;
    }

    @Override
    public void loadWindowSettings(Element settings) {
        WindowSettingManager.setBasicSettings(settings, this);
    }

    @Override
    public Element saveWindowSettings() {
        return WindowSettingManager.getBasicSettings(this);
    }
}

