/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pattern;

import blue.soundObject.PatternObject;
import blue.soundObject.editor.pattern.PatternCanvasMouseListener;
import blue.soundObject.editor.pattern.PatternsConstants;
import blue.soundObject.pattern.Pattern;
import blue.utility.GUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class PatternCanvas
extends JComponent
implements TableModelListener,
PropertyChangeListener {
    private static final Color PATTERN_COLOR = new Color(198, 226, 255);
    private PatternObject patObj;

    public PatternCanvas() {
        PatternCanvasMouseListener mListener = new PatternCanvasMouseListener(this);
        this.addMouseListener(mListener);
        this.addMouseMotionListener(mListener);
    }

    public void setPatternObject(PatternObject patObj) {
        if (this.patObj != null) {
            this.patObj.removeTableModelListener((TableModelListener)this);
            this.patObj.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.patObj = patObj;
        this.patObj.addTableModelListener((TableModelListener)this);
        this.patObj.addPropertyChangeListener((PropertyChangeListener)this);
        this.checkSize();
        this.repaint();
    }

    private void checkSize() {
        int viewHeight = PatternsConstants.patternViewHeight;
        int width = this.patObj.getBeats() * this.patObj.getSubDivisions() * viewHeight;
        int height = this.patObj.size() * viewHeight;
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        if (this.patObj == null) {
            return;
        }
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.patObj.size() == 0) {
            return;
        }
        int subDivisions = this.patObj.getSubDivisions();
        int steps = this.patObj.getBeats() * subDivisions;
        int h = PatternsConstants.patternViewHeight;
        int patternWidth = steps * h;
        int patternHeight = this.patObj.size() * h;
        g.setColor(PATTERN_COLOR);
        for (i = 0; i < this.patObj.size(); ++i) {
            Pattern p = this.patObj.getPattern(i);
            for (int j = 0; j < steps; ++j) {
                if (!p.values[j]) continue;
                int x1 = j * h;
                int y1 = i * h;
                g.fillRect(x1, y1, h, h);
            }
        }
        g.setColor(Color.darkGray);
        for (i = 0; i < this.patObj.size(); ++i) {
            g.drawLine(0, (i + 1) * h, patternWidth, (i + 1) * h);
        }
        for (i = 0; i < steps; ++i) {
            if (i % subDivisions == 0) {
                g.setColor(Color.gray);
            } else {
                g.setColor(Color.darkGray);
            }
            g.drawLine(i * h, 0, i * h, patternHeight);
        }
        g.setColor(Color.gray);
        g.drawLine(steps * h, 0, steps * h, patternHeight);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.checkSize();
        this.revalidate();
        this.repaint();
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        PatternCanvas canvas = new PatternCanvas();
        PatternObject patternObject = new PatternObject();
        patternObject.addPattern(0);
        patternObject.addPattern(1);
        patternObject.addPattern(2);
        patternObject.addPattern(3);
        canvas.setPatternObject(patternObject);
        GUI.showComponentAsStandalone((Component)canvas, (String)"Pattern Canvas", (boolean)true);
    }

    public PatternObject getPatternObject() {
        return this.patObj;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.patObj && evt.getPropertyName().equals("time")) {
            this.checkSize();
            this.repaint();
        }
    }
}

