/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.jmask.Constant;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConstantEditor
extends JPanel
implements DurationSettable {
    private Constant constant;
    Border normalBorder;
    Border errorBorder;
    private JLabel constantLabel;
    private JTextField valueText;

    public ConstantEditor(final Constant constant) {
        this.constant = constant;
        this.initComponents();
        this.normalBorder = this.valueText.getBorder();
        this.errorBorder = BorderFactory.createLineBorder(Color.RED);
        this.valueText.setText(Double.toString(constant.getValue()));
        this.valueText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                try {
                    double val = Double.parseDouble(ConstantEditor.this.valueText.getText());
                    constant.setValue(val);
                    if (ConstantEditor.this.valueText.getBorder() != ConstantEditor.this.normalBorder) {
                        ConstantEditor.this.valueText.setBorder(ConstantEditor.this.normalBorder);
                    }
                }
                catch (NumberFormatException nfe) {
                    ConstantEditor.this.valueText.setBorder(ConstantEditor.this.errorBorder);
                }
            }
        });
    }

    private void initComponents() {
        this.constantLabel = new JLabel();
        this.valueText = new JTextField();
        this.constantLabel.setText("Constant");
        this.valueText.setText("jTextField1");
        this.valueText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ConstantEditor.this.valueTextFocusLost(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.constantLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueText, -1, 232, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.constantLabel).addComponent(this.valueText, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void valueTextFocusLost(FocusEvent evt) {
        if (this.valueText.getBorder() == this.errorBorder) {
            this.valueText.setText(Double.toString(this.constant.getValue()));
        }
    }

    @Override
    public void setDuration(double duration) {
    }
}

