/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.components.DragDirection;
import blue.components.lines.Line;
import blue.components.lines.LineList;
import blue.components.lines.LinePoint;
import blue.jfx.BlueFX;
import blue.utility.NumberUtilities;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Glow;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javax.swing.event.TableModelListener;
import org.controlsfx.tools.Utils;

public class LineView
extends Canvas {
    private final LineList lineList;
    ObjectProperty<Line> selectedLine = new SimpleObjectProperty();
    LinePoint selectedPoint = null;
    double leftBoundaryX = -1.0;
    double rightBoundaryX = -1.0;
    double pressX = 0.0;
    double pressY = 0.0;
    DragDirection direction = DragDirection.NOT_SET;
    BooleanProperty locked = new SimpleBooleanProperty(false);
    ContextMenu editPointsMenu = new ContextMenu();

    public LineView(LineList lineList) {
        this.getGraphicsContext2D().applyEffect((Effect)new Glow(0.75));
        this.lineList = lineList;
        this.repaint();
        this.boundsInParentProperty().addListener((obs, old, newVal) -> this.repaint());
        this.selectedLine.addListener((obs, old, newVal) -> BlueFX.runOnFXThread(() -> this.repaint()));
        if (lineList.size() > 0) {
            this.setSelectedLine((Line)lineList.get(0));
        }
        MenuItem editPoints = new MenuItem("Edit Points");
        editPoints.setOnAction(e -> BlueFX.runOnFXThread(() -> this.editPoints()));
        this.editPointsMenu.getItems().add((Object)editPoints);
        this.setOnMousePressed(e -> this.mousePressed((MouseEvent)e));
        this.setOnMouseDragged(e -> this.mouseDragged((MouseEvent)e));
        this.setOnMouseReleased(e -> this.mouseReleased((MouseEvent)e));
        this.setOnMouseMoved(e -> this.mouseMoved((MouseEvent)e));
        ListChangeListener lcl = e -> BlueFX.runOnFXThread(() -> this.repaint());
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                lineList.removeListener(lcl);
            } else {
                lineList.addListener(lcl);
            }
        });
    }

    public final void setSelectedLine(Line line) {
        this.selectedLine.set((Object)line);
    }

    public final Line getSelectedLine() {
        return (Line)this.selectedLine.get();
    }

    public final ObjectProperty<Line> selectedLineProperty() {
        return this.selectedLine;
    }

    public final void setLocked(boolean value) {
        this.locked.set(value);
    }

    public final boolean isLocked() {
        return this.locked.get();
    }

    public final BooleanProperty lockedProperty() {
        return this.locked;
    }

    public void repaint() {
        GraphicsContext gc = this.getGraphicsContext2D();
        double w = this.getWidth();
        double h = this.getHeight();
        gc.setFill((Paint)Color.BLACK);
        gc.fillRect(0.0, 0.0, w, h);
        gc.setLineWidth(0.0);
        for (Line line : this.lineList) {
            boolean current = line == this.getSelectedLine();
            Color c = current ? line.getColorFX() : line.getColorFX().darker();
            gc.setStroke((Paint)c);
            gc.setFill((Paint)c);
            this.drawLine(line, gc, w, h);
            if (!current) continue;
            this.drawPoints(line, gc, w, h);
        }
        this.drawSelectedPoint(gc);
    }

    private void drawLine(Line line, GraphicsContext gc, double w, double h) {
        double min = line.getMin();
        double max = line.getMax();
        gc.beginPath();
        for (int i = 0; i < line.size(); ++i) {
            LinePoint lp = line.getLinePoint(i);
            double x = Math.floor(lp.getX() * w);
            double y = Math.floor(this.yToScreen(lp.getY(), min, max));
            if (i == 0) {
                gc.moveTo(x, y);
                continue;
            }
            gc.lineTo(x, y);
            gc.stroke();
        }
        gc.closePath();
    }

    private void drawPoints(Line line, GraphicsContext gc, double w, double h) {
        double min = line.getMin();
        double max = line.getMax();
        for (int i = 0; i < line.size(); ++i) {
            LinePoint lp = line.getLinePoint(i);
            double x = Math.floor(lp.getX() * w);
            double y = Math.floor(this.yToScreen(lp.getY(), min, max));
            gc.fillRect(x - 2.0, y - 2.0, 5.0, 5.0);
        }
    }

    private void drawSelectedPoint(GraphicsContext gc) {
        if (this.selectedPoint != null) {
            double min = this.getSelectedLine().getMin();
            double max = this.getSelectedLine().getMax();
            double x = Math.floor(this.selectedPoint.getX() * this.getWidth());
            double y = Math.floor(this.yToScreen(this.selectedPoint.getY(), min, max));
            gc.setFill((Paint)Color.RED);
            gc.fillRect(x - 2.0, y - 2.0, 5.0, 5.0);
            this.drawPointInformation(gc, x, y);
        }
    }

    private void drawPointInformation(GraphicsContext g2d, double x, double y) {
        g2d.setFill((Paint)Color.WHITE);
        double range = this.getSelectedLine().getMax() - this.getSelectedLine().getMin();
        double yVal = this.selectedPoint.getY();
        double xVal = this.selectedPoint.getX();
        String xText = "x: " + NumberUtilities.formatDouble((double)xVal);
        String yText = "y: " + NumberUtilities.formatDouble((double)yVal);
        int width = 95;
        int height = 28;
        double xLoc = x + 5.0;
        double yLoc = y + 5.0;
        if (x + (double)width > this.getWidth()) {
            xLoc = x - (double)width - 5.0;
        }
        if (y + (double)height > this.getHeight()) {
            yLoc = y - 14.0 - 5.0;
        }
        g2d.fillText(xText, xLoc, yLoc);
        g2d.fillText(yText, xLoc, yLoc + 14.0);
    }

    private void mousePressed(MouseEvent me) {
        if (this.getSelectedLine() == null) {
            return;
        }
        this.pressX = me.getX();
        this.pressY = me.getY();
        me.consume();
        if (this.selectedPoint != null) {
            if (me.isSecondaryButtonDown()) {
                if (this.isLocked()) {
                    return;
                }
                LinePoint first = this.getSelectedLine().getLinePoint(0);
                LinePoint last = this.getSelectedLine().getLinePoint(this.getSelectedLine().size() - 1);
                if (this.selectedPoint != first && this.selectedPoint != last) {
                    this.getSelectedLine().removeLinePoint(this.selectedPoint);
                    this.selectedPoint = null;
                    this.repaint();
                }
            } else {
                this.setBoundaryXValues();
            }
        } else if (me.isSecondaryButtonDown()) {
            this.editPointsMenu.show((Node)this, me.getScreenX(), me.getScreenY());
        } else if (me.isPrimaryButtonDown() && !this.isLocked()) {
            this.selectedPoint = this.insertGraphPoint(me.getX(), me.getY());
            this.repaint();
            this.setBoundaryXValues();
        }
    }

    private void mouseMoved(MouseEvent me) {
        if (this.getSelectedLine() == null) {
            return;
        }
        me.consume();
        double x = me.getX();
        double y = me.getY();
        LinePoint foundPoint = this.findGraphPoint(x, y);
        if (foundPoint != null) {
            if (this.selectedPoint != foundPoint) {
                this.selectedPoint = foundPoint;
                this.repaint();
            }
        } else if (this.selectedPoint != null) {
            this.selectedPoint = null;
            this.repaint();
        }
    }

    private void mouseReleased(MouseEvent me) {
        this.direction = DragDirection.NOT_SET;
        if (this.getSelectedLine() != null) {
            me.consume();
            this.repaint();
        }
    }

    private void mouseDragged(MouseEvent me) {
        if (this.getSelectedLine() == null || this.selectedPoint == null) {
            return;
        }
        me.consume();
        double x = me.getX();
        double y = me.getY();
        if (this.direction == DragDirection.NOT_SET) {
            double magy;
            double magx = Math.abs(x - this.pressX);
            DragDirection dragDirection = this.direction = magx > (magy = Math.abs(y - this.pressY)) ? DragDirection.LEFT_RIGHT : DragDirection.UP_DOWN;
        }
        if (me.isControlDown()) {
            if (this.direction == DragDirection.LEFT_RIGHT) {
                y = this.pressY;
            } else {
                x = this.pressX;
            }
        }
        x = Math.min(this.rightBoundaryX, Math.max(this.leftBoundaryX, x));
        y = Math.min(this.getHeight(), Math.max(0.0, y));
        this.selectedPoint.setLocation(x / this.getWidth(), this.screenToY(y, this.getSelectedLine().getMin(), this.getSelectedLine().getMax()));
        this.repaint();
    }

    public LinePoint findGraphPoint(double x, double y) {
        double min = this.getSelectedLine().getMin();
        double max = this.getSelectedLine().getMax();
        for (int i = 0; i < this.getSelectedLine().size(); ++i) {
            LinePoint point = this.getSelectedLine().getLinePoint(i);
            double tempX = point.getX() * this.getWidth();
            double tempY = this.yToScreen(point.getY(), min, max);
            if (!(tempX >= x - 3.0) || !(tempX <= x + 3.0) || !(tempY >= y - 3.0) || !(tempY <= y + 3.0)) continue;
            return point;
        }
        return null;
    }

    private double yToScreen(double yVal, double min, double max) {
        double range = max - min;
        double percent = (yVal - min) / range;
        return this.getHeight() * (1.0 - percent);
    }

    private double screenToY(double screenY, double min, double max) {
        double p = 1.0 - screenY / this.getHeight();
        return p * (max - min) + min;
    }

    private LinePoint insertGraphPoint(double x, double y) {
        if (x < 0.0 || x > this.getWidth() || y < 0.0 || y > this.getHeight()) {
            return null;
        }
        double min = this.getSelectedLine().getMin();
        double max = this.getSelectedLine().getMax();
        LinePoint point = new LinePoint();
        point.setLocation(x / this.getWidth(), this.screenToY(y, min, max));
        int index = 1;
        for (int i = 0; i < this.getSelectedLine().size() - 1; ++i) {
            LinePoint p1 = this.getSelectedLine().getLinePoint(i);
            LinePoint p2 = this.getSelectedLine().getLinePoint(i + 1);
            if (!(point.getX() >= p1.getX()) || !(point.getX() <= p2.getX())) continue;
            index = i + 1;
            break;
        }
        this.getSelectedLine().addLinePoint(index, point);
        return point;
    }

    private void setBoundaryXValues() {
        if (this.selectedPoint == null || this.getSelectedLine() == null) {
            return;
        }
        int size = this.getSelectedLine().size();
        if (this.selectedPoint == this.getSelectedLine().getLinePoint(0)) {
            this.leftBoundaryX = 0.0;
            this.rightBoundaryX = 0.0;
            return;
        }
        if (this.selectedPoint == this.getSelectedLine().getLinePoint(size - 1)) {
            this.leftBoundaryX = this.getWidth();
            this.rightBoundaryX = this.getWidth();
            return;
        }
        for (int i = 0; i < size; ++i) {
            if (this.getSelectedLine().getLinePoint(i) != this.selectedPoint) continue;
            LinePoint p1 = this.getSelectedLine().getLinePoint(i - 1);
            LinePoint p2 = this.getSelectedLine().getLinePoint(i + 1);
            this.leftBoundaryX = p1.getX() * this.getWidth();
            this.rightBoundaryX = p2.getX() * this.getWidth();
            return;
        }
    }

    private void editPoints() {
        TableView table = new TableView();
        TableColumn xCol = new TableColumn("x");
        TableColumn yCol = new TableColumn("y");
        table.getColumns().setAll((Object[])new TableColumn[]{xCol, yCol});
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        table.setItems(this.getSelectedLine().getObservableList());
        table.setEditable(true);
        xCol.setCellValueFactory((Callback)new PropertyValueFactory("x"));
        xCol.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new DoubleStringConverter()));
        xCol.setOnEditCommit(te -> {
            LinePoint lp = (LinePoint)te.getRowValue();
            if (this.getSelectedLine().getLinePoint(0) == lp || this.getSelectedLine().getLinePoint(this.getSelectedLine().size() - 1) == lp) {
                return;
            }
            lp.setX(Utils.clamp((double)0.0, (double)((Double)te.getNewValue()), (double)1.0));
        });
        xCol.setEditable(true);
        yCol.setCellValueFactory((Callback)new PropertyValueFactory("y"));
        yCol.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new DoubleStringConverter()));
        yCol.setOnEditCommit(te -> ((LinePoint)te.getRowValue()).setY(Utils.clamp((double)this.getSelectedLine().getMin(), (double)((Double)te.getNewValue()), (double)this.getSelectedLine().getMax())));
        yCol.setEditable(true);
        Dialog d = new Dialog();
        d.initOwner(this.getScene().getWindow());
        d.initModality(Modality.APPLICATION_MODAL);
        d.getDialogPane().setContent((Node)new ScrollPane((Node)table));
        d.getDialogPane().getStylesheets().add((Object)BlueFX.getBlueFxCss());
        d.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
        d.setTitle("Edit Points");
        TableModelListener tml = tme -> this.repaint();
        this.getSelectedLine().addTableModelListener(tml);
        Optional res = d.showAndWait();
        this.getSelectedLine().removeTableModelListener(tml);
    }
}

