/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.jfx.controls.ValuePanel;
import blue.orchestra.blueSynthBuilder.BSBHSlider;
import blue.orchestra.editor.blueSynthBuilder.jfx.ResizeableView;
import blue.utility.NumberUtilities;
import java.math.BigDecimal;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;
import javafx.util.StringConverter;
import org.openide.util.Exceptions;

public class BSBHSliderView
extends BorderPane
implements ResizeableView {
    Slider slider;
    ValuePanel valuePanel;
    BSBHSlider bsbHSlider;

    public BSBHSliderView(BSBHSlider bsbHSlider) {
        this.setUserData(bsbHSlider);
        this.bsbHSlider = bsbHSlider;
        this.slider = new Slider();
        this.slider.setOrientation(Orientation.HORIZONTAL);
        this.slider.setPrefHeight(30.0);
        this.valuePanel = new ValuePanel();
        this.valuePanel.setPrefHeight(30.0);
        this.valuePanel.setPrefWidth(50.0);
        this.setCenter((Node)this.slider);
        StringConverter<Number> converter = new StringConverter<Number>(){

            public String toString(Number object) {
                return object == null ? "" : NumberUtilities.formatDouble((double)object.doubleValue());
            }

            public Number fromString(String string) {
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException nfe) {
                    return 0.0;
                }
            }
        };
        ChangeListener vdeListener = (obs, old, newVal) -> {
            if (newVal.booleanValue()) {
                this.setRight((Node)this.valuePanel);
            } else {
                this.setRight(null);
            }
        };
        boolean[] val = new boolean[]{false};
        ChangeListener sliderToViewListener = (obs, old, newVal) -> {
            if (!val[0]) {
                val[0] = true;
                if (!Platform.isFxApplicationThread()) {
                    CountDownLatch latch = new CountDownLatch(1);
                    Platform.runLater(() -> {
                        try {
                            this.slider.setValue(bsbHSlider.getValue());
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    this.slider.setValue(bsbHSlider.getValue());
                }
                val[0] = false;
            }
        };
        ChangeListener viewToSliderListener = (obs, old, newVal) -> {
            if (!val[0]) {
                val[0] = true;
                bsbHSlider.setValue(this.slider.getValue());
                val[0] = false;
            }
        };
        ChangeListener tickListener = (obs, old, newVal) -> this.updateTickCount();
        this.sceneProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$new$5(viewToSliderListener, bsbHSlider, sliderToViewListener, vdeListener, tickListener, (StringConverter)converter, arg_0, arg_1, arg_2));
    }

    protected void updateTickCount() {
        BigDecimal bd = this.bsbHSlider.getResolution();
        if (bd.doubleValue() <= 0.0) {
            this.slider.setSnapToTicks(false);
            return;
        }
        this.slider.setSnapToTicks(true);
        BigDecimal range = new BigDecimal(this.bsbHSlider.getMaximum() - this.bsbHSlider.getMinimum());
        this.slider.setMajorTickUnit(this.bsbHSlider.getResolution().doubleValue());
    }

    @Override
    public boolean canResizeWidgetWidth() {
        return true;
    }

    @Override
    public boolean canResizeWidgetHeight() {
        return false;
    }

    @Override
    public int getWidgetMinimumWidth() {
        int base = this.bsbHSlider.isValueDisplayEnabled() ? 50 : 0;
        return 45 + base;
    }

    @Override
    public int getWidgetMinimumHeight() {
        return -1;
    }

    @Override
    public int getWidgetWidth() {
        int base = this.bsbHSlider.isValueDisplayEnabled() ? 50 : 0;
        return base + this.bsbHSlider.getSliderWidth();
    }

    @Override
    public void setWidgetWidth(int width) {
        int base = this.bsbHSlider.isValueDisplayEnabled() ? 50 : 0;
        this.bsbHSlider.setSliderWidth(Integer.valueOf(Math.max(45, width - base)));
    }

    @Override
    public int getWidgetHeight() {
        return -1;
    }

    @Override
    public void setWidgetHeight(int height) {
    }

    @Override
    public void setWidgetX(int x) {
        this.bsbHSlider.setX(x);
    }

    @Override
    public int getWidgetX() {
        return this.bsbHSlider.getX();
    }

    @Override
    public void setWidgetY(int y) {
    }

    @Override
    public int getWidgetY() {
        return -1;
    }

    private /* synthetic */ void lambda$new$5(ChangeListener viewToSliderListener, BSBHSlider bsbHSlider, ChangeListener sliderToViewListener, ChangeListener vdeListener, ChangeListener tickListener, StringConverter converter, ObservableValue obs, Scene old, Scene newVal) {
        if (newVal == null) {
            this.slider.maxProperty().unbind();
            this.slider.minProperty().unbind();
            this.slider.prefWidthProperty().unbind();
            this.slider.valueProperty().removeListener(viewToSliderListener);
            bsbHSlider.valueProperty().removeListener(sliderToViewListener);
            bsbHSlider.valueDisplayEnabledProperty().removeListener(vdeListener);
            Bindings.unbindBidirectional((Object)this.valuePanel.valueProperty(), (Object)bsbHSlider.valueProperty());
            bsbHSlider.maximumProperty().removeListener(tickListener);
            bsbHSlider.minimumProperty().removeListener(tickListener);
            bsbHSlider.resolutionProperty().removeListener(tickListener);
        } else {
            this.slider.maxProperty().bind((ObservableValue)bsbHSlider.maximumProperty());
            this.slider.minProperty().bind((ObservableValue)bsbHSlider.minimumProperty());
            this.slider.prefWidthProperty().bind((ObservableValue)bsbHSlider.sliderWidthProperty());
            bsbHSlider.valueDisplayEnabledProperty().addListener(vdeListener);
            this.slider.setValue(bsbHSlider.getValue());
            this.slider.valueProperty().addListener(viewToSliderListener);
            bsbHSlider.valueProperty().addListener(sliderToViewListener);
            Bindings.bindBidirectional((Property)this.valuePanel.valueProperty(), (Property)bsbHSlider.valueProperty(), (StringConverter)converter);
            if (bsbHSlider.isValueDisplayEnabled()) {
                this.setRight((Node)this.valuePanel);
            } else {
                this.setRight(null);
            }
            this.slider.setMinorTickCount(0);
            this.updateTickCount();
            bsbHSlider.maximumProperty().addListener(tickListener);
            bsbHSlider.minimumProperty().addListener(tickListener);
            bsbHSlider.resolutionProperty().addListener(tickListener);
        }
    }
}

