/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.clojure;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.CharStream;
import org.netbeans.spi.lexer.LexerInput;

public class AntlrCharStream
implements CharStream {
    private int line = 1;
    private int charPositionInLine = 0;
    private LexerInput input;
    private String name;
    private int index = 0;
    private List<CharStreamState> markers;
    private int markDepth = 0;
    private int lastMarker;
    private boolean ignoreCase = false;

    public AntlrCharStream(LexerInput input, String name, boolean ignoreCase) {
        this.input = input;
        this.name = name;
        this.ignoreCase = ignoreCase;
    }

    public String substring(int start, int stop) {
        return this.input.readText(start, stop).toString();
    }

    public int LT(int i) {
        return this.LA(i);
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setCharPositionInLine(int pos) {
        this.charPositionInLine = pos;
    }

    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public void consume() {
        int c = this.input.read();
        ++this.index;
        ++this.charPositionInLine;
        if (c == 10) {
            ++this.line;
            this.charPositionInLine = 0;
        }
    }

    public int LA(int i) {
        if (i == 0) {
            return 0;
        }
        int c = 0;
        for (int j = 0; j < i; ++j) {
            c = this.read();
        }
        this.backup(i);
        if (this.ignoreCase && c != -1) {
            return Character.toLowerCase((char)c);
        }
        return c;
    }

    public int mark() {
        if (this.markers == null) {
            this.markers = new ArrayList<CharStreamState>();
            this.markers.add(null);
        }
        ++this.markDepth;
        CharStreamState state = null;
        if (this.markDepth >= this.markers.size()) {
            state = new CharStreamState();
            this.markers.add(state);
        } else {
            state = this.markers.get(this.markDepth);
        }
        state.index = this.index;
        state.line = this.line;
        state.charPositionInLine = this.charPositionInLine;
        this.lastMarker = this.markDepth;
        return this.markDepth;
    }

    public void rewind() {
        this.rewind(this.lastMarker);
    }

    public void rewind(int marker) {
        CharStreamState state = this.markers.get(marker);
        this.seek(state.index);
        this.line = state.line;
        this.charPositionInLine = state.charPositionInLine;
        this.release(marker);
    }

    public void release(int marker) {
        this.markDepth = marker;
        --this.markDepth;
    }

    public void seek(int index) {
        if (index < this.index) {
            this.backup(this.index - index);
            this.index = index;
            return;
        }
        while (this.index < index) {
            this.consume();
        }
    }

    public int index() {
        return this.index;
    }

    public int size() {
        return -1;
    }

    public String getSourceName() {
        return this.name;
    }

    private int read() {
        int result = this.input.read();
        if (result == -1) {
            result = -1;
        }
        return result;
    }

    private void backup(int count) {
        this.input.backup(count);
    }

    private class CharStreamState {
        int index;
        int line;
        int charPositionInLine;

        private CharStreamState() {
        }
    }
}

