/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import blue.services.render.DeviceInfo;
import blue.services.render.DiskRenderService;
import blue.services.render.RealtimeRenderServiceFactory;
import blue.settings.DriverUtilities;
import blue.settings.RealtimeRenderSettings;
import blue.settings.RealtimeRenderSettingsOptionsPanelController;
import blue.ui.utilities.FileChooserManager;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

final class RealtimeRenderSettingsPanel
extends JPanel {
    private final RealtimeRenderSettingsOptionsPanelController controller;
    private boolean loading = false;
    private JTextField advancedText;
    private JCheckBox audioDriverCBox;
    private JComboBox audioDriverCombo;
    private JButton audioInButton;
    private JCheckBox audioInCBox;
    private JTextField audioInText;
    private JButton audioOutButton;
    private JCheckBox audioOutCBox;
    private JTextField audioOutText;
    private JCheckBox benchmarkCBox;
    private JTextField csoundExecText;
    private JCheckBox disableDisplaysCBox;
    private JCheckBox hardwareBufferCBox;
    private JSpinner hardwareBufferSpinner;
    private JButton jButton5;
    private JButton jButton6;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JTextField ksmpsText;
    private JCheckBox midiDriverCBox;
    private JComboBox midiDriverCombo;
    private JButton midiInButton;
    private JCheckBox midiInCBox;
    private JTextField midiInText;
    private JButton midiOutButton;
    private JCheckBox midiOutCBox;
    private JTextField midiOutText;
    private JTextField nchnlsText;
    private JCheckBox noteAmpCBox;
    private JCheckBox outOfRangeCBox;
    private JComboBox renderServiceComboBox;
    private JCheckBox softwareBufferCBox;
    private JSpinner softwareBufferSpinner;
    private JTextField srText;
    private JCheckBox warningsCBox;
    private JCheckBox zeroDBFSCheckBox;
    private JTextField zeroDBFSText;

    RealtimeRenderSettingsPanel(RealtimeRenderSettingsOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        SimpleDocumentListener changeListener = new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!RealtimeRenderSettingsPanel.this.loading) {
                    RealtimeRenderSettingsPanel.this.controller.changed();
                }
            }
        };
        this.csoundExecText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.srText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.ksmpsText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.nchnlsText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.audioOutText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.audioInText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.midiOutText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.midiInText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.advancedText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.zeroDBFSText.getDocument().addDocumentListener((DocumentListener)changeListener);
    }

    private void fireUpdate() {
        if (!this.loading) {
            this.controller.changed();
        }
    }

    private Object chooseDriver(List<DeviceInfo> vals) throws HeadlessException {
        if (vals == null || vals.size() == 0) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)"Could not discover devices for this driver.", "Error", -1, 0, null, null);
            DialogDisplayer.getDefault().notify(nd);
            return null;
        }
        Object retVal = JOptionPane.showInputDialog(WindowManager.getDefault().getMainWindow(), "Choose Device:", "Choose Device", -1, null, vals.toArray(), vals.get(0));
        return retVal;
    }

    private void initComponents() {
        this.jPanel6 = new JPanel();
        this.renderServiceComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.csoundExecText = new JTextField();
        this.jButton5 = new JButton();
        this.jLabel5 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.nchnlsText = new JTextField();
        this.ksmpsText = new JTextField();
        this.srText = new JTextField();
        this.zeroDBFSCheckBox = new JCheckBox();
        this.zeroDBFSText = new JTextField();
        this.jPanel2 = new JPanel();
        this.softwareBufferCBox = new JCheckBox();
        this.hardwareBufferCBox = new JCheckBox();
        this.softwareBufferSpinner = new JSpinner();
        this.hardwareBufferSpinner = new JSpinner();
        this.jPanel4 = new JPanel();
        this.advancedText = new JTextField();
        this.jButton6 = new JButton();
        this.jPanel3 = new JPanel();
        this.noteAmpCBox = new JCheckBox();
        this.outOfRangeCBox = new JCheckBox();
        this.warningsCBox = new JCheckBox();
        this.benchmarkCBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.audioOutText = new JTextField();
        this.audioInText = new JTextField();
        this.midiInText = new JTextField();
        this.midiOutText = new JTextField();
        this.audioInCBox = new JCheckBox();
        this.midiInCBox = new JCheckBox();
        this.midiOutCBox = new JCheckBox();
        this.audioOutButton = new JButton();
        this.audioInButton = new JButton();
        this.midiInButton = new JButton();
        this.midiOutButton = new JButton();
        this.audioOutCBox = new JCheckBox();
        this.audioDriverCBox = new JCheckBox();
        this.midiDriverCBox = new JCheckBox();
        this.audioDriverCombo = new JComboBox();
        this.midiDriverCombo = new JComboBox();
        this.jPanel7 = new JPanel();
        this.disableDisplaysCBox = new JCheckBox();
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jPanel6.border.title")));
        this.renderServiceComboBox.setModel(new DefaultComboBoxModel<RealtimeRenderServiceFactory>(RealtimeRenderSettings.getAvailableRealtimeRenderServices()));
        this.renderServiceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.renderServiceComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jLabel4.text_1"));
        this.csoundExecText.setText(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.csoundExecText.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton5, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jButton5.text_1"));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.jButton5ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jLabel5.text"));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.csoundExecText, -1, 370, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5)).addComponent(this.renderServiceComboBox, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jButton5).addComponent(this.csoundExecText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.renderServiceComboBox, -2, -1, -2).addComponent(this.jLabel5)).addContainerGap()));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jPanel5.border.title_1")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jLabel1.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jLabel2.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jLabel3.text_1"));
        this.nchnlsText.setText(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.nchnlsText.text_1"));
        this.ksmpsText.setText(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.ksmpsText.text_1"));
        this.srText.setText(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.srText.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.zeroDBFSCheckBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.zeroDBFSCheckBox.text"));
        this.zeroDBFSCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.zeroDBFSCheckBoxActionPerformed(evt);
            }
        });
        this.zeroDBFSText.setText(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.zeroDBFSText.text"));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.zeroDBFSCheckBox)).addGap(58, 58, 58).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.zeroDBFSText).addComponent(this.nchnlsText).addComponent(this.ksmpsText).addComponent(this.srText, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.srText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ksmpsText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.nchnlsText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.zeroDBFSCheckBox).addComponent(this.zeroDBFSText, -2, -1, -2))));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jPanel2.border.title_1")));
        Mnemonics.setLocalizedText((AbstractButton)this.softwareBufferCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.softwareBufferCBox.text_1"));
        this.softwareBufferCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.softwareBufferCBox.setMargin(new Insets(0, 0, 0, 0));
        this.softwareBufferCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.softwareBufferCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.hardwareBufferCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.hardwareBufferCBox.text_1"));
        this.hardwareBufferCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.hardwareBufferCBox.setMargin(new Insets(0, 0, 0, 0));
        this.hardwareBufferCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.hardwareBufferCBoxActionPerformed(evt);
            }
        });
        this.softwareBufferSpinner.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.softwareBufferSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RealtimeRenderSettingsPanel.this.softwareBufferSpinnerStateChanged(evt);
            }
        });
        this.hardwareBufferSpinner.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.hardwareBufferSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RealtimeRenderSettingsPanel.this.hardwareBufferSpinnerStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hardwareBufferCBox).addComponent(this.softwareBufferCBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.hardwareBufferSpinner).addComponent(this.softwareBufferSpinner, -1, 86, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.softwareBufferCBox).addComponent(this.softwareBufferSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hardwareBufferCBox).addComponent(this.hardwareBufferSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jPanel4.border.title_1")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jButton6.text_1"));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.jButton6ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.advancedText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.advancedText, -2, -1, -2).addComponent(this.jButton6)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jPanel3.border.title_1")));
        Mnemonics.setLocalizedText((AbstractButton)this.noteAmpCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.noteAmpCBox.text_1"));
        this.noteAmpCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noteAmpCBox.setMargin(new Insets(0, 0, 0, 0));
        this.noteAmpCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.noteAmpCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.outOfRangeCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.outOfRangeCBox.text_1"));
        this.outOfRangeCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.outOfRangeCBox.setMargin(new Insets(0, 0, 0, 0));
        this.outOfRangeCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.outOfRangeCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.warningsCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.warningsCBox.text_1"));
        this.warningsCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.warningsCBox.setMargin(new Insets(0, 0, 0, 0));
        this.warningsCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.warningsCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.benchmarkCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.benchmarkCBox.text_1"));
        this.benchmarkCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.benchmarkCBox.setMargin(new Insets(0, 0, 0, 0));
        this.benchmarkCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.benchmarkCBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outOfRangeCBox).addComponent(this.noteAmpCBox).addComponent(this.warningsCBox).addComponent(this.benchmarkCBox)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.noteAmpCBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outOfRangeCBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.warningsCBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.benchmarkCBox).addContainerGap(10, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jPanel1.border.title_1")));
        Mnemonics.setLocalizedText((AbstractButton)this.audioInCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.audioInCBox.text_1"));
        this.audioInCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.audioInCBox.setMargin(new Insets(0, 0, 0, 0));
        this.audioInCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.audioInCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.midiInCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.midiInCBox.text_1"));
        this.midiInCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.midiInCBox.setMargin(new Insets(0, 0, 0, 0));
        this.midiInCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.midiInCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.midiOutCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.midiOutCBox.text_1"));
        this.midiOutCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.midiOutCBox.setMargin(new Insets(0, 0, 0, 0));
        this.midiOutCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.midiOutCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.audioOutButton, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.audioOutButton.text_1"));
        this.audioOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.audioOutButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.audioInButton, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.audioInButton.text_1"));
        this.audioInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.audioInButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.midiInButton, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.midiInButton.text_1"));
        this.midiInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.midiInButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.midiOutButton, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.midiOutButton.text_1"));
        this.midiOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.midiOutButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.audioOutCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.audioOutCBox.text_1"));
        this.audioOutCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.audioOutCBox.setMargin(new Insets(0, 0, 0, 0));
        this.audioOutCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.audioOutCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.audioDriverCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.audioDriverCBox.text_1"));
        this.audioDriverCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.audioDriverCBox.setMargin(new Insets(0, 0, 0, 0));
        this.audioDriverCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.audioDriverCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.midiDriverCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.midiDriverCBox.text_1"));
        this.midiDriverCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.midiDriverCBox.setMargin(new Insets(0, 0, 0, 0));
        this.midiDriverCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.midiDriverCBoxActionPerformed(evt);
            }
        });
        this.audioDriverCombo.setModel(new DefaultComboBoxModel<String>(RealtimeRenderSettings.getAudioDrivers()));
        this.audioDriverCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.audioDriverComboActionPerformed(evt);
            }
        });
        this.midiDriverCombo.setModel(new DefaultComboBoxModel<String>(RealtimeRenderSettings.getMIDIDrivers()));
        this.midiDriverCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.midiDriverComboActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.audioDriverCBox).addComponent(this.midiDriverCBox).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.midiOutCBox).addComponent(this.audioOutCBox, GroupLayout.Alignment.TRAILING).addComponent(this.audioInCBox).addComponent(this.midiInCBox))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.midiOutText).addComponent(this.midiInText).addComponent(this.audioInText).addComponent(this.audioOutText)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.midiOutButton, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.midiInButton, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.audioInButton, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.audioOutButton, GroupLayout.Alignment.TRAILING))).addComponent(this.audioDriverCombo, 0, -1, Short.MAX_VALUE).addComponent(this.midiDriverCombo, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.audioDriverCBox).addComponent(this.audioDriverCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.audioOutButton).addComponent(this.audioOutCBox).addComponent(this.audioOutText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.audioInButton).addComponent(this.audioInCBox).addComponent(this.audioInText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.midiDriverCBox).addComponent(this.midiDriverCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.midiInButton).addComponent(this.midiInText, -2, -1, -2).addComponent(this.midiInCBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.midiOutCBox).addComponent(this.midiOutButton).addComponent(this.midiOutText, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.jPanel7.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.disableDisplaysCBox, (String)NbBundle.getMessage(RealtimeRenderSettingsPanel.class, (String)"RealtimeRenderSettingsPanel.disableDisplaysCBox.text"));
        this.disableDisplaysCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealtimeRenderSettingsPanel.this.disableDisplaysCBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.disableDisplaysCBox).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.disableDisplaysCBox).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(20, 20, 20)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel6, -2, 92, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addGap(3, 3, 3).addComponent(this.jPanel1, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap()));
    }

    private void audioInCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void midiInCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void midiOutCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void audioOutButtonActionPerformed(ActionEvent evt) {
        RealtimeRenderServiceFactory factory;
        DiskRenderService service;
        String command;
        List<DeviceInfo> vals;
        Object val;
        String driver = null;
        if (this.audioDriverCBox.isSelected()) {
            driver = (String)this.audioDriverCombo.getSelectedItem();
        }
        if ((val = this.chooseDriver(vals = DriverUtilities.getAudioDevices(command = this.csoundExecText.getText(), driver, service = (factory = (RealtimeRenderServiceFactory)this.renderServiceComboBox.getSelectedItem()).createDiskRenderService(), false))) != null) {
            DeviceInfo info = (DeviceInfo)val;
            this.audioOutText.setText(info.getDeviceId());
            this.fireUpdate();
        }
    }

    private void audioInButtonActionPerformed(ActionEvent evt) {
        RealtimeRenderServiceFactory factory;
        DiskRenderService service;
        String command;
        List<DeviceInfo> vals;
        Object val;
        String driver = null;
        if (this.audioDriverCBox.isSelected()) {
            driver = (String)this.audioDriverCombo.getSelectedItem();
        }
        if ((val = this.chooseDriver(vals = DriverUtilities.getAudioDevices(command = this.csoundExecText.getText(), driver, service = (factory = (RealtimeRenderServiceFactory)this.renderServiceComboBox.getSelectedItem()).createDiskRenderService(), true))) != null) {
            DeviceInfo info = (DeviceInfo)val;
            this.audioInText.setText(info.getDeviceId());
            this.fireUpdate();
        }
    }

    private void midiInButtonActionPerformed(ActionEvent evt) {
        RealtimeRenderServiceFactory factory;
        DiskRenderService service;
        String command;
        List<DeviceInfo> vals;
        Object val;
        String driver = null;
        if (this.midiDriverCBox.isSelected()) {
            driver = (String)this.midiDriverCombo.getSelectedItem();
        }
        if ((val = this.chooseDriver(vals = DriverUtilities.getMidiDevices(command = this.csoundExecText.getText(), driver, service = (factory = (RealtimeRenderServiceFactory)this.renderServiceComboBox.getSelectedItem()).createDiskRenderService(), true))) != null) {
            DeviceInfo info = (DeviceInfo)val;
            this.midiInText.setText(info.getDeviceId());
            this.fireUpdate();
        }
    }

    private void midiOutButtonActionPerformed(ActionEvent evt) {
        RealtimeRenderServiceFactory factory;
        DiskRenderService service;
        String command;
        List<DeviceInfo> vals;
        Object val;
        String driver = null;
        if (this.midiDriverCBox.isSelected()) {
            driver = (String)this.midiDriverCombo.getSelectedItem();
        }
        if ((val = this.chooseDriver(vals = DriverUtilities.getMidiDevices(command = this.csoundExecText.getText(), driver, service = (factory = (RealtimeRenderServiceFactory)this.renderServiceComboBox.getSelectedItem()).createDiskRenderService(), false))) != null) {
            DeviceInfo info = (DeviceInfo)val;
            this.midiOutText.setText(info.getDeviceId());
            this.fireUpdate();
        }
    }

    private void audioOutCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void audioDriverCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void midiDriverCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void audioDriverComboActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void midiDriverComboActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        List retVal = FileChooserManager.getDefault().showOpenDialog(this.getClass(), (Component)this);
        if (!retVal.isEmpty()) {
            File f = (File)retVal.get(0);
            try {
                String path = f.getCanonicalPath();
                if (f.exists() && f.isFile()) {
                    this.csoundExecText.setText(path);
                    this.fireUpdate();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void softwareBufferCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void hardwareBufferCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void softwareBufferSpinnerStateChanged(ChangeEvent evt) {
        this.fireUpdate();
    }

    private void hardwareBufferSpinnerStateChanged(ChangeEvent evt) {
        this.fireUpdate();
    }

    private void noteAmpCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void outOfRangeCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void warningsCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void benchmarkCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        File manualDir = InstalledFileLocator.getDefault().locate("csoundManual", "csound-manual", false);
        File index = new File(manualDir, "CommandFlags.html");
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(index.toURL());
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void disableDisplaysCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void zeroDBFSCheckBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void renderServiceComboBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    void load() {
        this.loading = true;
        RealtimeRenderSettings settings = RealtimeRenderSettings.getInstance();
        this.csoundExecText.setText(settings.csoundExecutable);
        this.srText.setText(settings.defaultSr);
        this.ksmpsText.setText(settings.defaultKsmps);
        this.nchnlsText.setText(settings.defaultNchnls);
        this.audioDriverCBox.setSelected(settings.audioDriverEnabled);
        this.audioDriverCombo.setSelectedItem(settings.audioDriver);
        this.audioOutCBox.setSelected(settings.audioOutEnabled);
        this.audioOutText.setText(settings.audioOutText);
        this.audioInCBox.setSelected(settings.audioInEnabled);
        this.audioInText.setText(settings.audioInText);
        this.midiDriverCBox.setSelected(settings.midiDriverEnabled);
        this.midiDriverCombo.setSelectedItem(settings.midiDriver);
        this.midiOutCBox.setSelected(settings.midiOutEnabled);
        this.midiOutText.setText(settings.midiOutText);
        this.midiInCBox.setSelected(settings.midiInEnabled);
        this.midiInText.setText(settings.midiInText);
        this.hardwareBufferCBox.setSelected(settings.hardwareBufferEnabled);
        this.hardwareBufferSpinner.setValue(new Integer(settings.hardwareBufferSize));
        this.softwareBufferCBox.setSelected(settings.softwareBufferEnabled);
        this.softwareBufferSpinner.setValue(new Integer(settings.softwareBufferSize));
        this.noteAmpCBox.setSelected(settings.noteAmpsEnabled);
        this.outOfRangeCBox.setSelected(settings.outOfRangeEnabled);
        this.warningsCBox.setSelected(settings.warningsEnabled);
        this.benchmarkCBox.setSelected(settings.benchmarkEnabled);
        this.disableDisplaysCBox.setSelected(settings.displaysDisabled);
        this.advancedText.setText(settings.advancedSettings);
        this.zeroDBFSCheckBox.setSelected(settings.useZeroDbFS);
        this.zeroDBFSText.setText(settings.zeroDbFS);
        this.renderServiceComboBox.setSelectedItem(settings.renderServiceFactory);
        this.loading = false;
    }

    void store() {
        RealtimeRenderSettings settings = RealtimeRenderSettings.getInstance();
        settings.csoundExecutable = this.csoundExecText.getText();
        settings.defaultSr = this.srText.getText();
        settings.defaultKsmps = this.ksmpsText.getText();
        settings.defaultNchnls = this.nchnlsText.getText();
        settings.audioDriverEnabled = this.audioDriverCBox.isSelected();
        settings.audioDriver = this.audioDriverCombo.getSelectedItem().toString();
        settings.audioOutEnabled = this.audioOutCBox.isSelected();
        settings.audioOutText = this.audioOutText.getText();
        settings.audioInEnabled = this.audioInCBox.isSelected();
        settings.audioInText = this.audioInText.getText();
        settings.midiDriverEnabled = this.midiDriverCBox.isSelected();
        settings.midiDriver = this.midiDriverCombo.getSelectedItem().toString();
        settings.midiOutEnabled = this.midiOutCBox.isSelected();
        settings.midiOutText = this.midiOutText.getText();
        settings.midiInEnabled = this.midiInCBox.isSelected();
        settings.midiInText = this.midiInText.getText();
        settings.hardwareBufferEnabled = this.hardwareBufferCBox.isSelected();
        settings.hardwareBufferSize = (Integer)this.hardwareBufferSpinner.getValue();
        settings.softwareBufferEnabled = this.softwareBufferCBox.isSelected();
        settings.softwareBufferSize = (Integer)this.softwareBufferSpinner.getValue();
        settings.noteAmpsEnabled = this.noteAmpCBox.isSelected();
        settings.warningsEnabled = this.warningsCBox.isSelected();
        settings.outOfRangeEnabled = this.outOfRangeCBox.isSelected();
        settings.benchmarkEnabled = this.benchmarkCBox.isSelected();
        settings.displaysDisabled = this.disableDisplaysCBox.isSelected();
        settings.advancedSettings = this.advancedText.getText();
        settings.useZeroDbFS = this.zeroDBFSCheckBox.isSelected();
        settings.zeroDbFS = this.zeroDBFSText.getText();
        settings.renderServiceFactory = (RealtimeRenderServiceFactory)this.renderServiceComboBox.getSelectedItem();
        settings.save();
    }

    boolean valid() {
        return true;
    }
}

