/*
 * Decompiled with CFR 0.152.
 */
package blue.util;

import java.util.List;

public class ObservableListEvent<E> {
    public static final int DATA_ADDED = 0;
    public static final int DATA_REMOVED = 1;
    public static final int DATA_CHANGED = 2;
    public static final int DATA_SET = 4;
    public static final int DATA_PUSHED_UP = 8;
    public static final int DATA_PUSHED_DOWN = 16;
    private final int startIndex;
    private final int endIndex;
    private final int type;
    private final int subType;
    private final List<E> source;
    private final List<E> affectedItems;

    public ObservableListEvent(List<E> source, int type, int subType, int startIndex, int endIndex, List<E> affectedItems) {
        this.source = source;
        this.type = type;
        this.subType = subType;
        this.startIndex = Math.min(startIndex, endIndex);
        this.endIndex = Math.max(startIndex, endIndex);
        this.affectedItems = affectedItems;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getType() {
        return this.type;
    }

    public int getSubType() {
        return this.subType;
    }

    public List<E> getSource() {
        return this.source;
    }

    public List<E> getAffectedItems() {
        return this.affectedItems;
    }
}

