/*
 * Decompiled with CFR 0.152.
 */
package blue.udo;

import blue.udo.UserDefinedOpcode;
import electric.xml.Element;
import electric.xml.Elements;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class OpcodeList
extends ArrayList<UserDefinedOpcode>
implements TableModel {
    private static final MessageFormat fmt = new MessageFormat("uniqueUDO{0}");
    private transient int counter = 0;
    private transient Vector<TableModelListener> listeners;

    public OpcodeList() {
    }

    public OpcodeList(OpcodeList opList) {
        for (UserDefinedOpcode udo : opList) {
            this.add(new UserDefinedOpcode(udo));
        }
    }

    public void addOpcodes(UserDefinedOpcode[] udos) {
        for (UserDefinedOpcode udo : udos) {
            this.add(udo);
        }
        this.fireTableDataChanged();
    }

    public void addOpcode(UserDefinedOpcode udo) {
        this.add(udo);
        this.fireTableDataChanged();
    }

    public void addOpcode(int index, UserDefinedOpcode udo) {
        if (index < 0 || index >= this.size()) {
            this.add(udo);
        } else {
            this.add(index, udo);
        }
        this.fireTableDataChanged();
    }

    public UserDefinedOpcode getOpcode(int index) {
        if (index < 0 || index > this.size() - 1) {
            return null;
        }
        return (UserDefinedOpcode)this.get(index);
    }

    public void removeOpcode(int index) {
        this.remove(index);
        this.fireTableDataChanged();
    }

    public void removeOpcodes(int[] indexes) {
        for (int i = indexes.length - 1; i >= 0; --i) {
            this.remove(indexes[i]);
        }
        this.fireTableDataChanged();
    }

    public void pushUpUDO(int[] rows) {
        UserDefinedOpcode a = (UserDefinedOpcode)this.remove(rows[0] - 1);
        this.add(rows[rows.length - 1], a);
        this.fireTableDataChanged();
    }

    public void pushDownUDO(int[] rows) {
        UserDefinedOpcode a = (UserDefinedOpcode)this.remove(rows[rows.length - 1] + 1);
        this.add(rows[0], a);
        this.fireTableDataChanged();
    }

    public String getNameOfEquivalentCopy(UserDefinedOpcode udo) {
        if (udo == null) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            UserDefinedOpcode temp = this.getOpcode(i);
            if (!temp.isEquivalent(udo)) continue;
            return temp.getOpcodeName();
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        UserDefinedOpcode udo = (UserDefinedOpcode)this.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return udo.getOpcodeName();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            String val = (String)aValue;
            this.getOpcode(rowIndex).setOpcodeName(val);
            this.fireTableDataChanged();
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Opcode Name";
            }
        }
        return "";
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    private void fireTableDataChanged() {
        if (this.listeners == null) {
            return;
        }
        TableModelEvent tme = new TableModelEvent(this);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(tme);
        }
    }

    public static OpcodeList loadFromXML(Element data) {
        OpcodeList retVal = new OpcodeList();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            UserDefinedOpcode udo = UserDefinedOpcode.loadFromXML(node);
            retVal.addOpcode(udo);
        }
        return retVal;
    }

    public Element saveAsXML() {
        Element retVal = new Element("opcodeList");
        for (UserDefinedOpcode udo : this) {
            retVal.addElement(udo.saveAsXML());
        }
        return retVal;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (UserDefinedOpcode udo : this) {
            buffer.append(udo.generateCode()).append("\n");
        }
        return buffer.toString();
    }

    public boolean isNameUnique(String name) {
        for (UserDefinedOpcode udo : this) {
            if (!udo.getOpcodeName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public String getUniqueName() {
        Object[] obj = new Object[]{new Integer(this.counter++)};
        String uniqueName = fmt.format(obj);
        while (!this.isNameUnique(uniqueName)) {
            obj[0] = new Integer(this.counter++);
            uniqueName = fmt.format(obj);
        }
        return uniqueName;
    }

    public static void main(String[] args) {
    }
}

