/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.tracker;

import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class TrackerNote {
    boolean tied = false;
    boolean off = false;
    ArrayList<String> fields;

    public TrackerNote() {
        this.fields = new ArrayList();
    }

    public TrackerNote(TrackerNote tn) {
        this.tied = tn.tied;
        this.off = tn.off;
        this.fields = new ArrayList<String>(tn.fields);
    }

    public boolean isTied() {
        return this.tied;
    }

    public void setTied(boolean tied) {
        this.tied = tied;
    }

    public boolean isOff() {
        return this.off;
    }

    public void setOff(boolean off) {
        this.off = off;
    }

    public int getNumFields() {
        return 1 + this.fields.size();
    }

    public void addColumn() {
        this.fields.add("");
    }

    public void removeColumn(int index) {
        int adjustIndex = index + 1;
        if (adjustIndex < 0 || adjustIndex > this.fields.size() - 1) {
            return;
        }
        this.fields.remove(adjustIndex);
    }

    public void setValue(int col, String value) {
        switch (col) {
            case 0: {
                System.err.println("Error: TrackerNote: SetValue with column 0 should not be called");
                return;
            }
        }
        int index = col - 1;
        this.fields.set(index, value);
        this.setOff(false);
    }

    public String getValue(int col) {
        if (this.off) {
            return "OFF";
        }
        switch (col) {
            case 0: {
                return this.isTied() ? "-" : "";
            }
        }
        int index = col - 1;
        return this.fields.get(index);
    }

    public boolean isActive() {
        for (String field : this.fields) {
            if (field.length() == 0) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public Element saveAsXML() {
        Element retVal = new Element("trackerNote");
        retVal.addElement(XMLUtilities.writeBoolean("tied", this.tied));
        retVal.addElement(XMLUtilities.writeBoolean("off", this.off));
        for (String val : this.fields) {
            retVal.addElement("field").setAttribute("val", val);
        }
        return retVal;
    }

    public static TrackerNote loadFromXML(Element data) {
        TrackerNote retVal = new TrackerNote();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            String nodeVal = node.getTextString();
            switch (nodeName) {
                case "tied": {
                    retVal.tied = Boolean.valueOf(nodeVal);
                    break;
                }
                case "off": {
                    retVal.off = Boolean.valueOf(nodeVal);
                    break;
                }
                case "pitch": {
                    String val = nodeVal == null ? "" : nodeVal;
                    retVal.fields.add(val);
                    break;
                }
                case "amp": {
                    String val = nodeVal == null ? "" : nodeVal;
                    retVal.fields.add(val);
                    break;
                }
                case "field": 
                case "otherField": {
                    String atVal = node.getAttributeValue("val");
                    atVal = atVal == null ? "" : atVal;
                    retVal.fields.add(atVal);
                }
            }
        }
        return retVal;
    }

    public void copyValues(TrackerNote note) {
        this.setTied(note.isTied());
        this.setOff(note.isOff());
        this.fields = new ArrayList<String>(note.fields);
    }

    public void clear() {
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fields.set(i, "");
        }
        this.setTied(false);
        this.setOff(false);
    }
}

