/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.tracker;

import blue.soundObject.pianoRoll.Scale;
import blue.utility.ScoreUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class Column {
    public static final int TYPE_PCH = 0;
    public static final int TYPE_BLUE_PCH = 1;
    public static final int TYPE_MIDI = 2;
    public static final int TYPE_STR = 3;
    public static final int TYPE_NUM = 4;
    public static final String[] TYPES = new String[]{"PCH", "blue PCH", "MIDI", "String", "Number"};
    private Scale scale;
    private boolean outputFrequency = true;
    protected String name = "col";
    private double rangeMin = 0.0;
    private double rangeMax = 0.0;
    protected int type = 3;
    private boolean restrictedToInteger = false;
    private boolean usingRange = false;

    public Column() {
        this.setScale(Scale.get12TET());
    }

    public Column(Column col) {
        this.scale = new Scale(col.scale);
        this.outputFrequency = col.outputFrequency;
        this.name = col.name;
        this.rangeMin = col.rangeMin;
        this.rangeMax = col.rangeMax;
        this.type = col.type;
        this.restrictedToInteger = col.restrictedToInteger;
        this.usingRange = col.usingRange;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isRestrictedToInteger() {
        return this.restrictedToInteger;
    }

    public void setRestrictedToInteger(boolean restrictedToInteger) {
        this.restrictedToInteger = restrictedToInteger;
    }

    public boolean isUsingRange() {
        return this.usingRange;
    }

    public void setUsingRange(boolean usingRange) {
        this.usingRange = usingRange;
    }

    public double getRangeMin() {
        return this.rangeMin;
    }

    public void setRangeMin(double rangeMin) {
        this.rangeMin = rangeMin;
    }

    public double getRangeMax() {
        return this.rangeMax;
    }

    public void setRangeMax(double rangeMax) {
        this.rangeMax = rangeMax;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public Scale getScale() {
        return this.scale;
    }

    public boolean isOutputFrequency() {
        return this.outputFrequency;
    }

    public void setOutputFrequency(boolean outputFrequency) {
        this.outputFrequency = outputFrequency;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public boolean isValid(String input) {
        String val = input.trim();
        if (val.length() == 0) {
            return true;
        }
        boolean retVal = false;
        switch (this.type) {
            case 0: {
                String[] parts = val.split("\\.");
                if (parts.length != 2 || parts[0].length() == 0 || parts[1].length() == 0) {
                    retVal = false;
                    break;
                }
                try {
                    double fVal = Double.parseDouble(val);
                    retVal = true;
                }
                catch (NumberFormatException nfe) {
                    retVal = false;
                }
                break;
            }
            case 1: {
                String[] parts = val.split("\\.");
                if (parts.length != 2 || parts[0].length() == 0 || parts[1].length() == 0) {
                    retVal = false;
                    break;
                }
                try {
                    int oct = Integer.parseInt(parts[0]);
                    int pch = Integer.parseInt(parts[1]);
                    if (parts[1].startsWith("0") && parts[1].length() > 1) {
                        retVal = false;
                        break;
                    }
                    retVal = true;
                }
                catch (NumberFormatException nfe) {
                    retVal = false;
                }
                break;
            }
            case 4: {
                try {
                    if (this.restrictedToInteger) {
                        int num = Integer.parseInt(val);
                        if (this.usingRange) {
                            retVal = num >= (int)this.rangeMin && num <= (int)this.rangeMax;
                            break;
                        }
                        retVal = true;
                        break;
                    }
                    double num = Double.parseDouble(val);
                    if (this.usingRange) {
                        retVal = num >= this.rangeMin && num <= this.rangeMax;
                        break;
                    }
                    retVal = true;
                }
                catch (NumberFormatException nfe) {
                    retVal = false;
                }
                break;
            }
            case 2: {
                try {
                    int num = Integer.parseInt(val);
                    retVal = num >= 0 && num < 128;
                }
                catch (NumberFormatException nfe) {
                    retVal = false;
                }
                break;
            }
            case 3: {
                retVal = true;
            }
        }
        return retVal;
    }

    public String getDefaultValue() {
        String retVal = "";
        switch (this.type) {
            case 0: 
            case 1: {
                retVal = "8.00";
                break;
            }
            case 4: {
                if (this.restrictedToInteger) {
                    retVal = Integer.toString((int)this.rangeMax);
                    break;
                }
                retVal = Double.toString(this.rangeMax);
                break;
            }
            case 2: {
                retVal = "60";
                break;
            }
            case 3: {
                retVal = "";
            }
        }
        return retVal;
    }

    public String getIncrementValue(String val) {
        String retVal = null;
        switch (this.type) {
            case 0: {
                double baseTen = ScoreUtilities.getBaseTen(val);
                int octave = (int)((baseTen += 1.0) / 12.0);
                double strPch = baseTen % 12.0 / 100.0;
                retVal = Double.toString((double)octave + strPch);
                if (!retVal.endsWith(".0") && !retVal.endsWith(".1")) break;
                retVal = retVal + "0";
                break;
            }
            case 1: {
                String[] parts = val.split("\\.");
                int scaleDegrees = this.getScale().getNumScaleDegrees();
                int iBaseTen = Integer.parseInt(parts[0]) * scaleDegrees;
                iBaseTen += Integer.parseInt(parts[1]);
                int iOctave = ++iBaseTen / scaleDegrees;
                int iScaleDegree = iBaseTen % scaleDegrees;
                retVal = iOctave + "." + iScaleDegree;
                break;
            }
            case 4: {
                double dNumVal = Double.parseDouble(val);
                dNumVal += 1.0;
                if (this.usingRange && dNumVal > this.rangeMax) {
                    dNumVal = this.rangeMax;
                }
                if (this.restrictedToInteger) {
                    retVal = Integer.toString((int)dNumVal);
                    break;
                }
                retVal = Double.toString(dNumVal);
                break;
            }
            case 2: {
                int midiVal = Integer.parseInt(val) + 1;
                if (midiVal > 127) {
                    return null;
                }
                retVal = Integer.toString(midiVal);
                break;
            }
            case 3: {
                retVal = null;
            }
        }
        return retVal;
    }

    public String getDecrementValue(String val) {
        String retVal = null;
        switch (this.type) {
            case 0: {
                double baseTen = ScoreUtilities.getBaseTen(val);
                int octave = (int)((baseTen -= 1.0) / 12.0);
                double strPch = baseTen % 12.0 / 100.0;
                retVal = Double.toString((double)octave + strPch);
                if (!retVal.endsWith(".0") && !retVal.endsWith(".1")) break;
                retVal = retVal + "0";
                break;
            }
            case 1: {
                String[] parts = val.split("\\.");
                int scaleDegrees = this.getScale().getNumScaleDegrees();
                int iBaseTen = Integer.parseInt(parts[0]) * scaleDegrees;
                iBaseTen += Integer.parseInt(parts[1]);
                int iOctave = --iBaseTen / scaleDegrees;
                int iScaleDegree = iBaseTen % scaleDegrees;
                retVal = iOctave + "." + iScaleDegree;
                break;
            }
            case 4: {
                double dNumVal = Double.parseDouble(val);
                dNumVal -= 1.0;
                if (this.usingRange && dNumVal < this.rangeMin) {
                    dNumVal = this.rangeMin;
                }
                if (this.restrictedToInteger) {
                    retVal = Integer.toString((int)dNumVal);
                    break;
                }
                retVal = Double.toString(dNumVal);
                break;
            }
            case 2: {
                int midiVal = Integer.parseInt(val) - 1;
                if (midiVal < 0) {
                    return null;
                }
                retVal = Integer.toString(midiVal);
                break;
            }
            case 3: {
                retVal = null;
            }
        }
        return retVal;
    }

    public Element saveAsXML() {
        Element retVal = new Element("track");
        retVal.addElement("name").setText(this.name);
        retVal.addElement(XMLUtilities.writeDouble("rangeMin", this.rangeMin));
        retVal.addElement(XMLUtilities.writeDouble("rangeMax", this.rangeMax));
        retVal.addElement(XMLUtilities.writeInt("type", this.type));
        retVal.addElement(XMLUtilities.writeBoolean("restrictedToInteger", this.restrictedToInteger));
        retVal.addElement(XMLUtilities.writeBoolean("usingRange", this.usingRange));
        retVal.addElement(this.getScale().saveAsXML());
        retVal.addElement(XMLUtilities.writeBoolean("outputFrequency", this.outputFrequency));
        return retVal;
    }

    public static Column loadFromXML(Element data) {
        Column retVal = new Column();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            String nodeVal = node.getTextString();
            switch (nodeName) {
                case "scale": {
                    retVal.setScale(Scale.loadFromXML(node));
                    break;
                }
                case "outputFrequency": {
                    retVal.outputFrequency = Boolean.valueOf(nodeVal);
                    break;
                }
                case "name": {
                    retVal.name = nodeVal;
                    break;
                }
                case "rangeMin": {
                    retVal.rangeMin = Double.parseDouble(nodeVal);
                    break;
                }
                case "rangeMax": {
                    retVal.rangeMax = Double.parseDouble(nodeVal);
                    break;
                }
                case "type": {
                    retVal.type = Integer.parseInt(nodeVal);
                    break;
                }
                case "restrictedToInteger": {
                    retVal.restrictedToInteger = Boolean.valueOf(nodeVal);
                    break;
                }
                case "usingRange": {
                    retVal.usingRange = Boolean.valueOf(nodeVal);
                }
            }
        }
        return retVal;
    }

    public static class AmpColumn
    extends Column {
        public AmpColumn() {
            this.name = "db";
            this.type = 4;
            this.setRangeMax(90.0);
        }
    }

    public static class PitchColumn
    extends Column {
        public PitchColumn() {
            this.name = "pch";
            this.type = 0;
        }
    }
}

