/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class SwingHTMLFontParser {
    static final Pattern SIZE_REGEX = Pattern.compile("size=\"([^\"]*)\"", 2);
    static final int[] SIZE_MAP = new int[]{8, 10, 12, 14, 18, 24, 36};

    public static Font parseFont(String text) {
        Matcher m = SIZE_REGEX.matcher(text);
        int retVal = 2;
        if (m.find()) {
            try {
                String t = m.group(1);
                int v = Integer.parseInt(m.group(1));
                retVal = t.charAt(0) == '+' || t.charAt(0) == '-' ? (retVal += v + 1) : v - 1;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                retVal = 0;
            }
        }
        retVal = Math.min(Math.max(0, retVal), 6);
        FontWeight weight = FontWeight.NORMAL;
        if (text.contains("<b>") || retVal > 2) {
            weight = FontWeight.BOLD;
        }
        Font f = Font.font((String)"System Regular", (FontWeight)weight, (double)SIZE_MAP[retVal]);
        return f;
    }

    protected static String stripHTML(String text) {
        return text.replaceAll("\\<[^>]*?>", "");
    }
}

