/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.noteProcessor.NoteProcessor;
import blue.utility.ObjectUtilities;
import java.text.MessageFormat;

public class NoteProcessorException
extends Exception {
    protected String message;
    protected int pfield;
    protected NoteProcessor noteProcessor;
    private static final MessageFormat messageFormat = new MessageFormat("pfield {0}: {1}");

    public NoteProcessorException(NoteProcessor noteProcessor) {
        this(noteProcessor, null);
    }

    public NoteProcessorException(NoteProcessor noteProcessor, String message) {
        this(noteProcessor, message, -1);
    }

    public NoteProcessorException(NoteProcessor noteProcessor, String message, int pfield) {
        this.noteProcessor = noteProcessor;
        this.message = message;
        this.pfield = pfield;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            return null;
        }
        if (this.pfield == -1) {
            return this.message;
        }
        Object[] args = new Object[]{new Integer(this.pfield), this.message};
        return messageFormat.format(args);
    }

    public String getProcessorName() {
        return ObjectUtilities.getShortClassName(this.noteProcessor);
    }

    public int getPField() {
        return this.pfield;
    }
}

