/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.noteProcessor.ValueTimeMapper;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import electric.xml.Element;

public class LineAddProcessor
implements NoteProcessor {
    private String lineAddString = "0 0";
    private int pfield = 4;

    public LineAddProcessor() {
    }

    public LineAddProcessor(LineAddProcessor lap) {
        this.lineAddString = lap.lineAddString;
        this.pfield = lap.pfield;
    }

    @Override
    public void processNotes(NoteList in) throws NoteProcessorException {
        double addVal = 0.0;
        double oldVal = 0.0;
        ValueTimeMapper tm = ValueTimeMapper.createValueTimeMapper(this.lineAddString);
        if (tm == null) {
            throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.lineAddStringErr"), this.pfield);
        }
        for (int i = 0; i < in.size(); ++i) {
            Note temp = (Note)in.get(i);
            try {
                oldVal = Double.parseDouble(temp.getPField(this.pfield));
                addVal = tm.getValueForBeat(temp.getStartTime());
            }
            catch (NumberFormatException ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.pfieldNotDouble"), this.pfield);
            }
            catch (Exception ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield);
            }
            if (Double.isNaN(addVal)) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.noteBeatErr"), this.pfield);
            }
            temp.setPField(Double.toString(oldVal + addVal), this.pfield);
        }
    }

    public String toString() {
        return "[line add]";
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i + " 1 3 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        LineAddProcessor lap = new LineAddProcessor();
        lap.setLineAddString("0 0 3 -3 6 0");
        try {
            lap.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    public String getPfield() {
        return Integer.toString(this.pfield);
    }

    public void setPfield(String pfield) {
        this.pfield = Integer.parseInt(pfield);
    }

    public String getLineAddString() {
        return this.lineAddString;
    }

    public void setLineAddString(String string) {
        this.lineAddString = string;
    }

    public static NoteProcessor loadFromXML(Element data) {
        LineAddProcessor lap = new LineAddProcessor();
        lap.setPfield(data.getElement("pfield").getTextString());
        lap.setLineAddString(data.getElement("lineAddString").getTextString());
        return lap;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("pfield").setText(this.getPfield());
        retVal.addElement("lineAddString").setText(this.getLineAddString());
        return retVal;
    }

    @Override
    public LineAddProcessor deepCopy() {
        return new LineAddProcessor(this);
    }
}

