/*
 * Decompiled with CFR 0.152.
 */
package blue.components.lines;

import blue.components.lines.Line;
import blue.components.lines.LinePoint;
import blue.soundObject.SoundObject;

public class SoundObjectParameterLine
extends Line {
    SoundObject source = null;

    public SoundObjectParameterLine(SoundObject source, Line line) {
        super(true);
        this.channel = line.getChannel();
        this.color = line.getColor();
        this.endPointsLinked = line.isEndPointsLinked();
        this.isZak = line.isZak();
        this.max = line.getMax();
        this.min = line.getMin();
        this.points = line.getObservableList();
        this.uniqueID = line.getUniqueID();
        this.varName = line.getVarName();
        this.source = source;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public double getValue(double time) {
        double start = this.source.getStartTime();
        if (time < start) {
            return ((LinePoint)this.points.get(0)).getY();
        }
        if (time > start + this.source.getSubjectiveDuration()) {
            return ((LinePoint)this.points.get(this.points.size() - 1)).getY();
        }
        double t = (time - start) / this.source.getSubjectiveDuration();
        return super.getValue(t);
    }

    public double getSourceStart() {
        return this.source.getStartTime();
    }

    public double getSourceDuration() {
        return this.source.getSubjectiveDuration();
    }
}

