/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueLookAndFeel;
import blue.plaf.BlueTheme;
import blue.plaf.BlueViewBorder;
import blue.plaf.MacFullScreenUtil;
import blue.plaf.netbeans.BlueLFCustoms;
import java.awt.Color;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    Logger logger = Logger.getLogger("blue.plaf.Installer");
    private Object customs = new BlueLFCustoms();

    public void validate() throws IllegalStateException {
        Preferences prefs = NbPreferences.root().node("laf");
        prefs.put("laf", BlueLookAndFeel.class.getName());
        UIManager.put("Nb.BlueLFCustoms", this.customs);
        UIManager.put("nb.dark.theme", true);
        boolean isMac = System.getProperty("os.name").toLowerCase().startsWith("mac");
        Object[] macEntries = null;
        if (isMac) {
            try {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                macEntries = new Object[7];
                macEntries[0] = UIManager.get("MenuBarUI");
                macEntries[3] = UIManager.get("CheckboxMenuItemUI");
                macEntries[4] = UIManager.get("RadioButtonMenuItemUI");
                macEntries[5] = UIManager.get("PopupMenuUI");
                macEntries[6] = UIManager.get("PopupMenuSeparatorUI");
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (UnsupportedLookAndFeelException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        try {
            Integer in = (Integer)UIManager.get("customFontSize");
            if (in == null || in <= 11) {
                UIManager.put("customFontSize", 12);
            } else {
                UIManager.put("customFontSize", (int)in);
            }
            UIManager.installLookAndFeel("Blue", BlueLookAndFeel.class.getName());
            UIManager.put("Nb.BlueLFCustoms", this.customs);
            UIManager.put("swing.boldMetal", false);
            MetalLookAndFeel.setCurrentTheme(new BlueTheme());
            BlueLookAndFeel plaf = new BlueLookAndFeel();
            UIManager.setLookAndFeel(plaf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UIManager.put("EditorTabDisplayerUI", "org.netbeans.swing.tabcontrol.plaf.AquaEditorTabDisplayerUI");
        UIManager.put("ViewTabDisplayerUI", "org.netbeans.swing.tabcontrol.plaf.AquaViewTabDisplayerUI");
        UIManager.put("SlidingButtonUI", "org.netbeans.swing.tabcontrol.plaf.AquaSlidingButtonUI");
        UIManager.put("TabbedContainer.editor.contentBorder", BorderFactory.createEmptyBorder());
        UIManager.put("TabbedContainer.editor.outerBorder", new BlueViewBorder(UIManager.getColor("SplitPane.highlight"), UIManager.getColor("SplitPane.darkShadow")));
        UIManager.put("TabbedContainer.view.contentBorder", BorderFactory.createEmptyBorder());
        UIManager.put("TabbedContainer.view.outerBorder", new BlueViewBorder(UIManager.getColor("SplitPane.highlight"), UIManager.getColor("SplitPane.darkShadow")));
        UIManager.put("nb.output.foreground", Color.WHITE);
        if (isMac && macEntries != null) {
            UIManager.put("MenuBarUI", macEntries[0]);
            UIManager.put("CheckboxMenuItemUI", macEntries[3]);
            UIManager.put("RadioButtonMenuItemUI", macEntries[4]);
            UIManager.put("PopupMenuUI", macEntries[5]);
            UIManager.put("PopupMenuSeparatorUI", macEntries[6]);
        }
        if (isMac) {
            this.replaceCtrlShortcutsWithMacShortcuts();
        }
        this.logger.info("Finished blue PLAF installation");
    }

    public void restored() {
        WindowManager.getDefault().invokeWhenUIReady(() -> MacFullScreenUtil.setWindowCanFullScreen(WindowManager.getDefault().getMainWindow()));
    }

    protected void replaceCtrlShortcutsWithMacShortcuts() {
        for (Object keyObj : UIManager.getLookAndFeelDefaults().keySet()) {
            Object val;
            String key = keyObj.toString();
            if (!key.contains("InputMap") || !((val = UIManager.getLookAndFeelDefaults().get(key)) instanceof InputMapUIResource)) continue;
            InputMapUIResource map = (InputMapUIResource)val;
            for (KeyStroke keyStroke : map.allKeys()) {
                int modifiers = keyStroke.getModifiers();
                if ((modifiers & 2) <= 0) continue;
                modifiers -= 128;
                modifiers -= 2;
                KeyStroke k = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), modifiers += 260);
                Object mapVal = map.get(keyStroke);
                map.remove(keyStroke);
                map.put(k, mapVal);
            }
        }
    }
}

