/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.udo;

import blue.udo.UDOCategory;
import blue.udo.UDOLibrary;
import blue.udo.UserDefinedOpcode;
import blue.ui.core.udo.TransferableUDO;
import blue.utility.ListUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class UDOTreeDropTarget
implements DropTargetListener {
    DropTarget target;
    JTree targetTree;

    public UDOTreeDropTarget(JTree tree) {
        this.targetTree = tree;
        this.target = new DropTarget(this.targetTree, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (!dtde.isDataFlavorSupported(TransferableUDO.UDO_FLAVOR) && !dtde.isDataFlavorSupported(TransferableUDO.UDO_CAT_FLAVOR)) {
            dtde.rejectDrag();
            return;
        }
        Point p = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath path = tree.getClosestPathForLocation(p.x, p.y);
        if (path.getLastPathComponent() instanceof UDOCategory) {
            dtde.acceptDrag(dtde.getDropAction());
        } else if (dtde.isDataFlavorSupported(TransferableUDO.UDO_FLAVOR)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.dragEnter(dtde);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point pt = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath parentpath = tree.getClosestPathForLocation(pt.x, pt.y);
        Object node = parentpath.getLastPathComponent();
        if (dtde.isDataFlavorSupported(TransferableUDO.UDO_CAT_FLAVOR)) {
            if (!(node instanceof UDOCategory)) {
                dtde.rejectDrop();
                return;
            }
            if (dtde.getDropAction() == 2) {
                dtde.acceptDrop(dtde.getDropAction());
                Transferable tr = dtde.getTransferable();
                try {
                    Object transferNode = tr.getTransferData(TransferableUDO.UDO_CAT_FLAVOR);
                    UDOCategory udoCategory = (UDOCategory)transferNode;
                    UDOCategory parentNode = (UDOCategory)node;
                    UDOLibrary udoLibrary = (UDOLibrary)tree.getModel();
                    udoLibrary.addCategory(parentNode, udoCategory);
                    dtde.dropComplete(true);
                }
                catch (UnsupportedFlavorException | IOException e) {
                    dtde.dropComplete(false);
                }
            } else {
                dtde.rejectDrop();
            }
        } else if (dtde.isDataFlavorSupported(TransferableUDO.UDO_FLAVOR)) {
            dtde.acceptDrop(dtde.getDropAction());
            try {
                Transferable tr = dtde.getTransferable();
                Object transferNode = tr.getTransferData(TransferableUDO.UDO_FLAVOR);
                UserDefinedOpcode udo = (UserDefinedOpcode)transferNode;
                UDOLibrary udoLibrary = (UDOLibrary)tree.getModel();
                if (node instanceof UDOCategory) {
                    UDOCategory parentNode = (UDOCategory)node;
                    udoLibrary.addUDO(parentNode, udo);
                } else if (node instanceof UserDefinedOpcode) {
                    UDOCategory parentNode = (UDOCategory)parentpath.getPathComponent(parentpath.getPathCount() - 2);
                    int index = ListUtil.indexOfByRef((List)parentNode.getUserDefinedOpcodes(), (Object)node);
                    int closestRow = tree.getClosestRowForLocation(pt.x, pt.y);
                    Rectangle bounds = tree.getRowBounds(closestRow);
                    if (pt.y > bounds.y + bounds.height) {
                        udoLibrary.addUDO(parentNode, udo);
                    } else {
                        udoLibrary.addUDO(parentNode, index, udo);
                    }
                }
                dtde.dropComplete(true);
            }
            catch (UnsupportedFlavorException | IOException e) {
                dtde.dropComplete(false);
            }
        } else {
            dtde.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }
}

