/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.undo;

import blue.BlueSystem;
import blue.score.ScoreObject;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class ResizeScoreObjectEdit
extends AbstractUndoableEdit {
    private ScoreObject sObj;
    private double initialDuration;
    private double endingDuration;
    private ResizeScoreObjectEdit nextEdit = null;

    public ResizeScoreObjectEdit(ScoreObject sObj, double initialDuration, double endingDuration) {
        this.initialDuration = initialDuration;
        this.endingDuration = endingDuration;
        this.sObj = sObj;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.sObj.setSubjectiveDuration(this.endingDuration);
        if (this.nextEdit != null) {
            this.nextEdit.redo();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.sObj.setSubjectiveDuration(this.initialDuration);
        if (this.nextEdit != null) {
            this.nextEdit.undo();
        }
    }

    @Override
    public String getPresentationName() {
        return BlueSystem.getString((String)"scoreGUI.action.resizeSoundObject");
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof ResizeScoreObjectEdit) {
            if (this.nextEdit == null) {
                this.nextEdit = (ResizeScoreObjectEdit)anEdit;
                return true;
            }
            return this.nextEdit.addEdit(anEdit);
        }
        return false;
    }
}

