/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.project;

import blue.BlueData;
import blue.BlueSystem;
import blue.MainToolBar;
import blue.ProjectProperties;
import blue.gui.ExceptionDialog;
import blue.services.render.DiskRenderJob;
import blue.services.render.DiskRenderService;
import blue.settings.DiskRenderSettings;
import blue.settings.GeneralSettings;
import blue.ui.utilities.FileChooserManager;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class RenderToDiskUtility {
    private static final String FILE_CHOOSER_ID = "renderToDiskDialog";
    private static RenderToDiskUtility instance = null;

    private RenderToDiskUtility() {
    }

    public static RenderToDiskUtility getInstance() {
        if (instance == null) {
            instance = new RenderToDiskUtility();
        }
        return instance;
    }

    public void renderToDisk(BlueData data, Consumer<File> completionCallback) {
        if (MainToolBar.getInstance().isRendering()) {
            MainToolBar.getInstance().stopRendering();
        }
        try {
            DiskRenderCommand command = this.getDiskCommandLine(data);
            if (command == null) {
                return;
            }
            DiskRenderJob job = new DiskRenderJob(command.args, command.filename, data, BlueSystem.getCurrentProjectDirectory());
            this.play(job, completionCallback);
        }
        catch (Exception ex) {
            ExceptionDialog.showExceptionDialog(WindowManager.getDefault().getMainWindow(), ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DiskRenderCommand getDiskCommandLine(BlueData data) throws IOException {
        String fileOutput;
        String[] args;
        ProjectProperties props = data.getProjectProperties();
        if (props.diskCompleteOverride) {
            String command = props.diskAdvancedSettings;
            if (!GeneralSettings.getInstance().isMessageColorsEnabled()) {
                command = command + " -+msg_color=false ";
            }
            args = command.split("\\s+");
            fileOutput = RenderToDiskUtility.getFileOutputFromCommand(command);
            return new DiskRenderCommand(args, fileOutput);
        } else {
            String fileName = "";
            if (props.askOnRender || props.fileName.trim().length() == 0) {
                File retVal = FileChooserManager.getDefault().showSaveDialog((Object)FILE_CHOOSER_ID, (Component)WindowManager.getDefault().getMainWindow());
                if (retVal == null) return null;
                fileName = retVal.getCanonicalPath();
            } else {
                fileName = props.fileName;
            }
            fileOutput = fileName;
            DiskRenderSettings settings = DiskRenderSettings.getInstance();
            String command = settings.getCommandLine() + " " + this.getMessageLevelFlag(props) + " " + props.diskAdvancedSettings + " -o \"" + fileName + "\"";
            args = command.split("\\s+");
        }
        return new DiskRenderCommand(args, fileOutput);
    }

    public void play(DiskRenderJob job, Consumer<File> completionCallback) {
        RunProxy runProxy = new RunProxy(job, completionCallback);
        new Thread(runProxy).start();
    }

    protected static String getFileOutputFromCommand(String command) {
        String[] parts = command.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].toLowerCase();
            if (!part.endsWith(".wav") && !part.endsWith(".aiff") && !part.endsWith(".aif")) continue;
            if (parts[i].charAt(0) == '-') {
                return parts[i].substring(parts[i].indexOf("o") + 1);
            }
            return parts[i];
        }
        return null;
    }

    private String getMessageLevelFlag(ProjectProperties props) {
        int val = 0;
        if (props.diskNoteAmpsEnabled) {
            ++val;
        }
        if (props.diskOutOfRangeEnabled) {
            val += 2;
        }
        if (props.diskWarningsEnabled) {
            val += 4;
        }
        if (props.diskBenchmarkEnabled) {
            val += 128;
        }
        return "-m" + val;
    }

    private class DiskRenderCommand {
        public String[] args;
        public String filename;

        public DiskRenderCommand(String[] args, String filename) {
            this.args = args;
            this.filename = filename;
        }
    }

    class RunProxy
    implements Runnable,
    Cancellable {
        boolean cancelled = false;
        DiskRenderService diskRenderService;
        DiskRenderJob job;
        private final Consumer<File> completionCallback;

        private RunProxy(DiskRenderJob job, Consumer<File> completionCallback) {
            this.job = job;
            this.completionCallback = completionCallback;
            this.diskRenderService = DiskRenderSettings.getInstance().renderServiceFactory.createInstance();
        }

        public boolean cancel() {
            if (this.diskRenderService.isRunning()) {
                this.diskRenderService.stop();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)"Rendering to Disk", (Cancellable)this);
            handle.start();
            handle.progress("Rendering...");
            try {
                this.diskRenderService.renderToDisk(this.job);
                if (this.completionCallback != null && !this.cancelled) {
                    String fileOut = this.job.getFilename();
                    if (fileOut == null) {
                        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Could not parse file name from command line");
                        return;
                    }
                    File f = BlueSystem.findFile((String)fileOut);
                    if (f == null) {
                        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Could not find generated file: " + fileOut);
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.completionCallback.accept(f));
                }
            }
            catch (Exception ioe) {
                this.diskRenderService.stop();
                Exceptions.printStackTrace((Throwable)ioe);
            }
            finally {
                handle.finish();
            }
        }
    }
}

