/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra;

import blue.Arrangement;
import blue.ArrangementEvent;
import blue.ArrangementListener;
import blue.BlueSystem;
import blue.CopyBuffer;
import blue.TransferableInstrument;
import blue.gui.DragManager;
import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.mixer.Mixer;
import blue.orchestra.BlueSynthBuilder;
import blue.orchestra.GenericInstrument;
import blue.orchestra.Instrument;
import blue.settings.GeneralSettings;
import blue.ui.nbutilities.lazyplugin.LazyPlugin;
import blue.ui.nbutilities.lazyplugin.LazyPluginFactory;
import blue.ui.utilities.FileChooserManager;
import blue.ui.utilities.UiUtilities;
import blue.undo.BlueUndoManager;
import blue.utility.ObjectUtilities;
import electric.xml.Document;
import electric.xml.Element;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.openide.util.Exceptions;

public class ArrangementEditPanel
extends JComponent
implements ArrangementListener {
    private static final String IMPORT_DIALOG = "instr.import";
    private static final String EXPORT_DIALOG = "instr.export";
    private static MessageFormat toolTipFormat = new MessageFormat("<html><b>Instrument Type:</b> {0}</html>");
    private final AddInstrumentPopup popup = new AddInstrumentPopup();
    private final InstrumentTablePopup convertPopup = new InstrumentTablePopup();
    JTable arrangementTable;
    Arrangement arrangement = null;
    private Mixer mixer = null;

    public ArrangementEditPanel() {
        Insets smallButtonInsets = new Insets(0, 3, 0, 3);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), new EmptyBorder(3, 3, 3, 3)));
        JLabel label = new JLabel("Orchestra");
        JButton addButton = new JButton("+");
        addButton.setMargin(smallButtonInsets);
        addButton.setToolTipText("Add Instrument");
        addButton.addActionListener(e -> {
            int x1 = addButton.getWidth();
            int y1 = 0;
            this.popup.show(addButton, x1, y1);
        });
        topPanel.add((Component)label, "Center");
        topPanel.add((Component)addButton, "East");
        this.arrangementTable = new JTable(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return this.getPreferredSize().height < this.getParent().getHeight();
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                if (rowIndex < 0) {
                    return null;
                }
                TableModel model = this.getModel();
                if (rowIndex < model.getRowCount()) {
                    Instrument instr = ArrangementEditPanel.this.arrangement.getInstrument(rowIndex);
                    Object[] args = new Object[]{ObjectUtilities.getShortClassName((Object)instr)};
                    tip = toolTipFormat.format(args);
                }
                return tip;
            }
        };
        this.arrangementTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ArrangementEditPanel.this.arrangementTable.isEditing()) {
                    return;
                }
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    ArrangementEditPanel.this.convertPopup.show(ArrangementEditPanel.this.arrangementTable, e.getX(), e.getY());
                }
            }
        });
        this.arrangementTable.setSelectionMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.arrangementTable);
        tableScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)tableScrollPane, "Center");
        new ArrangementDragSource(this.arrangementTable, 1);
        new ArrangementTableDropTarget(this.arrangementTable);
        File defaultFile = new File(GeneralSettings.getInstance().getDefaultDirectory() + File.separator + "default.binstr");
        FileChooser.ExtensionFilter presetFilter = new FileChooser.ExtensionFilter("blue Instrument File", new String[]{"*.binstr"});
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.addFilter((Object)IMPORT_DIALOG, presetFilter);
        fcm.setDialogTitle((Object)IMPORT_DIALOG, "Import Instrument");
        fcm.setSelectedFile((Object)IMPORT_DIALOG, defaultFile);
        fcm.addFilter((Object)EXPORT_DIALOG, presetFilter);
        fcm.setDialogTitle((Object)EXPORT_DIALOG, "Export Instrument");
        fcm.setSelectedFile((Object)EXPORT_DIALOG, defaultFile);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.arrangementTable.getSelectionModel().addListSelectionListener(listener);
    }

    public Instrument getSelectedInstrument() {
        if (this.arrangement == null) {
            return null;
        }
        int row = this.arrangementTable.getSelectedRow();
        if (row >= 0) {
            return this.arrangement.getInstrument(row);
        }
        return null;
    }

    private void setupTableProperties() {
        TableColumnModel model = this.arrangementTable.getTableHeader().getColumnModel();
        model.getColumn(0).setPreferredWidth(25);
        model.getColumn(0).setMaxWidth(25);
        model.getColumn(0).setMinWidth(25);
        model.getColumn(1).setPreferredWidth(60);
        model.getColumn(1).setResizable(true);
        model.getColumn(2).setPreferredWidth(180);
        this.arrangementTable.getTableHeader().setReorderingAllowed(false);
        this.arrangementTable.getTableHeader().setPreferredSize(new Dimension(17, 21));
    }

    private void addInstrument(Instrument instr) {
        int selectedRow = this.arrangementTable.getSelectedRow();
        this.addInstrument(instr, selectedRow);
    }

    private void addInstrument(Instrument instr, int selectedRow) {
        if (this.arrangement == null) {
            return;
        }
        if (selectedRow < 0) {
            this.arrangement.addInstrument(null, instr);
        } else {
            String instrumentId = (String)this.arrangement.getValueAt(selectedRow, 1);
            this.arrangement.addInstrument(instrumentId, instr);
        }
        String instrId = this.arrangement.getInstrumentId(instr);
        if (instrId != null) {
            OrchestraEdit edit = new OrchestraEdit(this.arrangement, instr, instrId, 0);
            BlueUndoManager.setUndoManager((String)"orchestra");
            BlueUndoManager.addEdit((UndoableEdit)edit);
        }
    }

    public void convertToBSB() {
        int selectedRow = this.arrangementTable.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        String instrumentId = (String)this.arrangement.getValueAt(selectedRow, 1);
        Instrument instr = this.arrangement.getInstrument(selectedRow);
        if (instr instanceof GenericInstrument) {
            GenericInstrument genInstr = (GenericInstrument)instr;
            BlueSynthBuilder bsb = new BlueSynthBuilder();
            bsb.setName(genInstr.getName());
            bsb.setComment(genInstr.getComment());
            bsb.setGlobalOrc(genInstr.getGlobalOrc());
            bsb.setGlobalSco(genInstr.getGlobalSco());
            bsb.setInstrumentText(genInstr.getText());
            bsb.setOpcodeList(genInstr.getOpcodeList());
            this.arrangement.replaceInstrument(instrumentId, (Instrument)bsb);
        }
    }

    public void removeInstrument() {
        int selectedRow = this.arrangementTable.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        Instrument instr = this.arrangement.removeInstrument(selectedRow);
        String instrId = this.arrangement.getInstrumentId(instr);
        if (instrId != null) {
            OrchestraEdit edit = new OrchestraEdit(this.arrangement, instr, instrId, 1);
            BlueUndoManager.setUndoManager((String)"orchestra");
            BlueUndoManager.addEdit((UndoableEdit)edit);
        }
    }

    public void cutInstrument() {
        this.copyInstrument();
        this.removeInstrument();
    }

    public void copyInstrument() {
        int selectedRow = this.arrangementTable.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        Instrument instr = this.arrangement.getInstrument(selectedRow);
        Object clone = instr.deepCopy();
        CopyBuffer.setBufferedObject((String)CopyBuffer.INSTRUMENT, (Object)clone);
    }

    public void pasteInstrument() {
        Object obj = CopyBuffer.getBufferedObject((String)CopyBuffer.INSTRUMENT);
        if (obj == null || !(obj instanceof Instrument)) {
            return;
        }
        Instrument instr = (Instrument)obj;
        Instrument clone = (Instrument)instr.deepCopy();
        if (clone instanceof BlueSynthBuilder) {
            ((BlueSynthBuilder)clone).clearParameters();
        }
        this.addInstrument(clone);
    }

    public void setMixer(Mixer mixer) {
        this.mixer = mixer;
    }

    public void setArrangement(Arrangement arrangement) {
        if (this.arrangementTable.isEditing()) {
            this.arrangementTable.getCellEditor().cancelCellEditing();
        }
        if (this.arrangement != null) {
            this.arrangement.removeArrangementListener((ArrangementListener)this);
        }
        this.arrangement = arrangement;
        this.arrangement.addArrangementListener((ArrangementListener)this);
        if (arrangement != null) {
            this.arrangementTable.setModel((TableModel)arrangement);
            this.arrangementTable.setEnabled(true);
            this.setupTableProperties();
        } else {
            this.arrangementTable.setEnabled(false);
            this.arrangementTable.setModel(new DefaultTableModel(new Object[0], 0));
        }
        this.reconcileWithArrangement();
    }

    public void arrangementChanged(ArrangementEvent arrEvt) {
        switch (arrEvt.getType()) {
            case 0: {
                this.reconcileWithArrangement();
            }
        }
    }

    private void reconcileWithArrangement() {
        int i;
        ChannelList channels = this.mixer.getChannels();
        ArrayList<String> idList = new ArrayList<String>();
        for (i = 0; i < this.arrangement.size(); ++i) {
            String instrId = this.arrangement.getInstrumentAssignment((int)i).arrangementId;
            if (idList.contains(instrId)) continue;
            idList.add(instrId);
        }
        for (i = channels.size() - 1; i >= 0; --i) {
            Channel channel = (Channel)channels.get(i);
            if (idList.contains(channel.getName())) continue;
            channels.remove((Object)channel);
        }
        for (i = 0; i < idList.size(); ++i) {
            channels.checkOrCreate((String)idList.get(i));
        }
        channels.sort();
    }

    public void deselect() {
        this.arrangementTable.clearSelection();
    }

    private static class OrchestraEdit
    extends AbstractUndoableEdit {
        public static final int ADD = 0;
        public static final int REMOVE = 1;
        private final Arrangement arrangement;
        private final int type;
        private final Instrument instr;
        private final String instrId;

        public OrchestraEdit(Arrangement arrangement, Instrument instr, String instrId, int type) {
            this.arrangement = arrangement;
            this.instr = instr;
            this.instrId = instrId;
            this.type = type;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (this.type == 0) {
                this.arrangement.addInstrumentWithId(this.instr, this.instrId);
            } else {
                this.arrangement.removeInstrument(this.instrId);
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.type == 0) {
                this.arrangement.removeInstrument(this.instrId);
            } else {
                this.arrangement.addInstrumentWithId(this.instr, this.instrId);
            }
        }

        @Override
        public String getPresentationName() {
            if (this.type == 0) {
                return "Add Instrument";
            }
            return "Remove Instrument";
        }
    }

    private class AddInstrumentPopup
    extends JPopupMenu {
        public AddInstrumentPopup() {
            List plugins = LazyPluginFactory.loadPlugins((String)"blue/instruments", Instrument.class);
            this.setLabel("Add Instrument");
            ActionListener al = e -> {
                LazyPlugin plugin = (LazyPlugin)((JMenuItem)e.getSource()).getClientProperty("plugin");
                this.fireAddInstrument((Instrument)plugin.getInstance());
            };
            for (LazyPlugin plugin : plugins) {
                JMenuItem temp = new JMenuItem();
                temp.setText(plugin.getDisplayName());
                temp.putClientProperty("plugin", plugin);
                temp.addActionListener(al);
                this.add(temp);
            }
            this.pack();
        }

        private void fireAddInstrument(Instrument instrTemplate) {
            try {
                Instrument np = (Instrument)instrTemplate.getClass().newInstance();
                ArrangementEditPanel.this.addInstrument(np);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    class InstrumentTablePopup
    extends JPopupMenu {
        JMenuItem removeInstrumentMenuItem = new JMenuItem(BlueSystem.getString((String)"instrument.remove"));
        JMenuItem cutMenuItem = new JMenuItem(BlueSystem.getString((String)"instrument.cut"));
        JMenuItem copyMenuItem = new JMenuItem(BlueSystem.getString((String)"instrument.copy"));
        JMenuItem pasteMenuItem = new JMenuItem(BlueSystem.getString((String)"instrument.paste"));
        JMenuItem convertToBSB = new JMenuItem();
        Action exportItem;

        public InstrumentTablePopup() {
            this.removeInstrumentMenuItem.addActionListener(e -> ArrangementEditPanel.this.removeInstrument());
            this.cutMenuItem.addActionListener(e -> ArrangementEditPanel.this.cutInstrument());
            this.copyMenuItem.addActionListener(e -> ArrangementEditPanel.this.copyInstrument());
            this.pasteMenuItem.addActionListener(e -> ArrangementEditPanel.this.pasteInstrument());
            this.convertToBSB.setText("Convert to BlueSynthBuilder");
            this.convertToBSB.addActionListener(e -> ArrangementEditPanel.this.convertToBSB());
            AbstractAction importItem = new AbstractAction(BlueSystem.getString((String)"common.import")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List retVal = FileChooserManager.getDefault().showOpenDialog((Object)ArrangementEditPanel.IMPORT_DIALOG, SwingUtilities.getRoot(SwingUtilities.getRoot(ArrangementEditPanel.this)));
                    if (!retVal.isEmpty()) {
                        File f = (File)retVal.get(0);
                        try {
                            Document doc = new Document(f);
                            Element root = doc.getRoot();
                            if (root.getName().equals("instrument")) {
                                Instrument tempInstr = (Instrument)ObjectUtilities.loadFromXML((Element)root);
                                ArrangementEditPanel.this.addInstrument(tempInstr);
                            } else {
                                JOptionPane.showMessageDialog(SwingUtilities.getRoot(ArrangementEditPanel.this), "Error: File did not contain instrument", "Error", 0);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JOptionPane.showMessageDialog(SwingUtilities.getRoot(ArrangementEditPanel.this), "Error: Could not read instrument from file", "Error", 0);
                        }
                    }
                }
            };
            this.exportItem = new AbstractAction(BlueSystem.getString((String)"common.export")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedRow = ArrangementEditPanel.this.arrangementTable.getSelectedRow();
                    if (selectedRow < 0) {
                        return;
                    }
                    Instrument instr = ArrangementEditPanel.this.arrangement.getInstrument(selectedRow);
                    File retVal = FileChooserManager.getDefault().showSaveDialog((Object)ArrangementEditPanel.EXPORT_DIALOG, SwingUtilities.getRoot(ArrangementEditPanel.this));
                    if (retVal != null) {
                        int overWrite;
                        File f = retVal;
                        if (f.exists() && (overWrite = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(ArrangementEditPanel.this), "Please confirm you would like to overwrite this file.")) != 0) {
                            return;
                        }
                        Element node = instr.saveAsXML();
                        try (PrintWriter out = new PrintWriter(new FileWriter(f));){
                            out.print(node.toString());
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            };
            this.add(this.removeInstrumentMenuItem);
            this.addSeparator();
            this.add(this.cutMenuItem);
            this.add(this.copyMenuItem);
            this.add(this.pasteMenuItem);
            this.addSeparator();
            this.add(this.convertToBSB);
            this.addSeparator();
            this.add(importItem);
            this.add(this.exportItem);
            this.setupPopupListener();
        }

        private void setupPopupListener() {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    int rowIndex = ArrangementEditPanel.this.arrangementTable.getSelectedRow();
                    boolean selected = rowIndex >= 0;
                    InstrumentTablePopup.this.cutMenuItem.setEnabled(selected);
                    InstrumentTablePopup.this.copyMenuItem.setEnabled(selected);
                    InstrumentTablePopup.this.removeInstrumentMenuItem.setEnabled(selected);
                    InstrumentTablePopup.this.exportItem.setEnabled(selected);
                    if (selected) {
                        Instrument instr = ArrangementEditPanel.this.arrangement.getInstrument(rowIndex);
                        InstrumentTablePopup.this.convertToBSB.setEnabled(instr instanceof GenericInstrument);
                    } else {
                        InstrumentTablePopup.this.convertToBSB.setEnabled(false);
                    }
                    Object bufferedObj = CopyBuffer.getBufferedObject((String)CopyBuffer.INSTRUMENT);
                    boolean bufferFull = bufferedObj != null && bufferedObj instanceof Instrument;
                    InstrumentTablePopup.this.pasteMenuItem.setEnabled(bufferFull);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    }

    class ArrangementTableDropTarget
    extends DropTargetAdapter {
        DropTarget target;
        JTable targetTable;

        public ArrangementTableDropTarget(JTable table) {
            this.targetTable = table;
            this.target = new DropTarget(this.targetTable, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (!dtde.isDataFlavorSupported(TransferableInstrument.INSTR_FLAVOR)) {
                dtde.rejectDrag();
                return;
            }
            if (DragManager.getDragSource() != this.targetTable) {
                dtde.acceptDrag(1);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.dragEnter(dtde);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point pt = dtde.getLocation();
            if (!dtde.isDataFlavorSupported(TransferableInstrument.INSTR_FLAVOR) || (dtde.getSourceActions() & 1) != 1) {
                dtde.rejectDrop();
                return;
            }
            try {
                int listIndex;
                Transferable tr = dtde.getTransferable();
                Object transferNode = tr.getTransferData(TransferableInstrument.INSTR_FLAVOR);
                Instrument instrument = (Instrument)transferNode;
                int h = this.targetTable.getRowHeight();
                int n = listIndex = pt != null ? pt.y / h : -1;
                if (listIndex < 0) {
                    dtde.rejectDrop();
                    return;
                }
                if (listIndex >= this.targetTable.getRowCount()) {
                    listIndex = this.targetTable.getRowCount() - 1;
                }
                dtde.acceptDrop(1);
                if (instrument instanceof BlueSynthBuilder) {
                    ((BlueSynthBuilder)instrument).clearParameters();
                }
                ArrangementEditPanel.this.addInstrument(instrument, listIndex);
                dtde.dropComplete(true);
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class ArrangementDragSource
    extends DragSourceAdapter
    implements DragGestureListener {
        DragSource source;
        DragGestureRecognizer recognizer;
        JTable table;
        TransferableInstrument transferable;

        public ArrangementDragSource(JTable table, int actions) {
            this.table = table;
            this.source = new DragSource();
            this.recognizer = this.source.createDefaultDragGestureRecognizer(table, actions, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            Arrangement arr = (Arrangement)this.table.getModel();
            Instrument instr = arr.getInstrument(index);
            Object cloneNode = instr.deepCopy();
            this.transferable = new TransferableInstrument(cloneNode);
            this.source.startDrag(dge, null, (Transferable)this.transferable, this);
            DragManager.setDragSource(this.table);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (dsde.getDropSuccess()) {
                // empty if block
            }
        }
    }
}

