/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Field;
import java.util.Vector;
import tcl.lang.ClassRep;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.reflect.PkgInvoker;

class FieldSig
implements InternalRep {
    Class targetCls;
    Class sigCls;
    Field field;
    PkgInvoker pkgInvoker;

    FieldSig(Class tc, Class sc, PkgInvoker p, Field f) {
        this.targetCls = tc;
        this.sigCls = sc;
        this.pkgInvoker = p;
        this.field = f;
    }

    public InternalRep duplicate() {
        return new FieldSig(this.targetCls, this.sigCls, this.pkgInvoker, this.field);
    }

    public void dispose() {
    }

    static FieldSig get(Interp interp, TclObject signature, Class targetCls) throws TclException {
        Field field;
        Class sigCls;
        TclObject sigClsObj;
        String fieldName;
        InternalRep rep = signature.getInternalRep();
        if (rep instanceof FieldSig && ((FieldSig)rep).targetCls == targetCls) {
            return (FieldSig)rep;
        }
        int len = TclList.getLength((Interp)interp, (TclObject)signature);
        if (len < 1 || len > 2) {
            throw new TclException(interp, "bad field signature \"" + signature + "\"");
        }
        if (len == 1) {
            fieldName = signature.toString();
            sigClsObj = null;
        } else {
            fieldName = TclList.index((Interp)interp, (TclObject)signature, (int)0).toString();
            sigClsObj = TclList.index((Interp)interp, (TclObject)signature, (int)1);
        }
        if (sigClsObj != null) {
            sigCls = ClassRep.get(interp, sigClsObj);
            if (!sigCls.isAssignableFrom(targetCls)) {
                throw new TclException(interp, "\"" + sigCls.getName() + "\" is not a superclass of \"" + targetCls.getName() + "\"");
            }
            if (!PkgInvoker.isAccessible(sigCls)) {
                throw new TclException(interp, "Class \"" + sigCls.getName() + "\" is not accessible");
            }
        } else {
            sigCls = targetCls;
        }
        try {
            field = FieldSig.getAccessibleField(sigCls, fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new TclException(interp, "no accessible field \"" + signature + "\" found in class " + sigCls.getName());
        }
        FieldSig sig = new FieldSig(targetCls, sigCls, PkgInvoker.getPkgInvoker(targetCls), field);
        signature.setInternalRep(sig);
        return sig;
    }

    static Field[] getAccessibleFields(Class cls) {
        if (PkgInvoker.usesDefaultInvoker(cls)) {
            return cls.getFields();
        }
        Object[] fields = cls.getDeclaredFields();
        Vector<Field> vec = new Vector<Field>();
        boolean skipped_any = false;
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (PkgInvoker.isAccessible(f)) {
                vec.addElement(f);
                continue;
            }
            skipped_any = true;
        }
        if (skipped_any) {
            fields = new Field[vec.size()];
            vec.copyInto(fields);
        }
        return fields;
    }

    static Field getAccessibleField(Class cls, String fieldName) throws NoSuchFieldException {
        if (PkgInvoker.usesDefaultInvoker(cls)) {
            return cls.getField(fieldName);
        }
        Field f = cls.getDeclaredField(fieldName);
        if (!PkgInvoker.isAccessible(f)) {
            throw new NoSuchFieldException();
        }
        return f;
    }
}

