/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.OSCBundle;
import de.sciss.net.OSCException;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacket;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;

public class OSCPacketCodec {
    private static final OSCPacketCodec defaultCodec = new OSCPacketCodec();
    public static final int MODE_READ_DOUBLE = 1;
    public static final int MODE_READ_DOUBLE_AS_FLOAT = 2;
    private static final int MODE_READ_DOUBLE_MASK = 3;
    public static final int MODE_READ_LONG = 4;
    public static final int MODE_READ_LONG_AS_INTEGER = 8;
    private static final int MODE_READ_LONG_MASK = 12;
    public static final int MODE_WRITE_DOUBLE = 16;
    public static final int MODE_WRITE_DOUBLE_AS_FLOAT = 32;
    private static final int MODE_WRITE_DOUBLE_MASK = 48;
    public static final int MODE_WRITE_LONG = 64;
    public static final int MODE_WRITE_LONG_AS_INTEGER = 128;
    private static final int MODE_WRITE_LONG_MASK = 192;
    public static final int MODE_READ_SYMBOL_AS_STRING = 256;
    public static final int MODE_WRITE_PACKET_AS_BLOB = 512;
    public static final int MODE_STRICT_V1 = 0;
    public static final int MODE_MODEST = 938;
    public static final int MODE_GRACEFUL = 933;
    public static final int MODE_FAT_V1 = 853;
    private final Atom[] atomDecoders = new Atom[128];
    private final Class[] atomEncoderC = new Class[128];
    private final Atom[] atomEncoderA = new Atom[128];
    protected String charsetName;
    private static final byte[] bndlIdentifier = new byte[]{35, 98, 117, 110, 100, 108, 101, 0};
    private static final byte[] pad = new byte[4];

    public OSCPacketCodec() {
        this(933);
    }

    public OSCPacketCodec(int mode) {
        this(mode, "UTF-8");
    }

    public OSCPacketCodec(int mode, String charset) {
        Atom a;
        int encIdx = 0;
        this.atomDecoders[a.getTypeTag(null)] = a = new IntegerAtom();
        this.atomEncoderC[encIdx] = Integer.class;
        this.atomEncoderA[encIdx++] = a;
        this.atomDecoders[a.getTypeTag(null)] = a = new FloatAtom();
        this.atomEncoderC[encIdx] = Float.class;
        this.atomEncoderA[encIdx++] = a;
        this.atomDecoders[a.getTypeTag(null)] = a = new StringAtom();
        this.atomEncoderC[encIdx] = String.class;
        this.atomEncoderA[encIdx++] = a;
        this.atomDecoders[a.getTypeTag(null)] = a = new BlobAtom();
        this.atomEncoderC[encIdx] = [B.class;
        this.atomEncoderA[encIdx++] = a;
        this.setStringCharsetCodec(charset);
        this.setSupportMode(mode);
    }

    public static OSCPacketCodec getDefaultCodec() {
        return defaultCodec;
    }

    public void setStringCharsetCodec(String charsetName) {
        this.charsetName = charsetName;
    }

    public void putDecoder(byte typeTag, Atom a) {
        this.atomDecoders[typeTag] = a;
    }

    public void putEncoder(Class javaClass, Atom a) {
        int encIdx = 0;
        while (this.atomEncoderC[encIdx] != javaClass && this.atomEncoderC[encIdx] != null) {
            ++encIdx;
        }
        if (a != null) {
            this.atomEncoderC[encIdx] = javaClass;
            this.atomEncoderA[encIdx] = a;
        } else if (this.atomEncoderC[encIdx] != null) {
            int encIdx2 = encIdx + 1;
            while (this.atomEncoderC[encIdx2] != null) {
                ++encIdx2;
            }
            System.arraycopy(this.atomEncoderC, encIdx + 1, this.atomEncoderC, encIdx, encIdx2 - encIdx);
            System.arraycopy(this.atomEncoderA, encIdx + 1, this.atomEncoderA, encIdx, encIdx2 - encIdx);
        }
    }

    public void setSupportMode(int mode) {
        switch (mode & 3) {
            case 0: {
                this.atomDecoders[100] = null;
                break;
            }
            case 1: {
                this.atomDecoders[100] = new DoubleAtom();
                break;
            }
            case 2: {
                this.atomDecoders[100] = new DoubleAsFloatAtom();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(mode));
            }
        }
        switch (mode & 0xC) {
            case 0: {
                this.atomDecoders[104] = null;
                break;
            }
            case 4: {
                this.atomDecoders[104] = new LongAtom();
                break;
            }
            case 8: {
                this.atomDecoders[104] = new LongAsIntegerAtom();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(mode));
            }
        }
        switch (mode & 0x30) {
            case 0: {
                this.putEncoder(Double.class, null);
                break;
            }
            case 16: {
                this.putEncoder(Double.class, new DoubleAtom());
                break;
            }
            case 32: {
                this.putEncoder(Double.class, new DoubleAsFloatAtom());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(mode));
            }
        }
        switch (mode & 0xC0) {
            case 0: {
                this.putEncoder(Long.class, null);
                break;
            }
            case 64: {
                this.putEncoder(Long.class, new LongAtom());
                break;
            }
            case 128: {
                this.putEncoder(Long.class, new LongAsIntegerAtom());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(mode));
            }
        }
        this.atomDecoders[83] = (mode & 0x100) != 0 ? new StringAtom() : null;
        if ((mode & 0x200) != 0) {
            PacketAtom a = new PacketAtom();
            this.putEncoder(OSCBundle.class, a);
            this.putEncoder(OSCMessage.class, a);
        } else {
            this.putEncoder(OSCBundle.class, null);
            this.putEncoder(OSCMessage.class, null);
        }
    }

    public OSCPacket decode(ByteBuffer b) throws IOException {
        String command = OSCPacketCodec.readString(b);
        OSCPacketCodec.skipToAlign(b);
        if (command.equals("#bundle")) {
            return this.decodeBundle(b);
        }
        return this.decodeMessage(command, b);
    }

    public void encode(OSCPacket p, ByteBuffer b) throws IOException {
        if (p instanceof OSCBundle) {
            this.encodeBundle((OSCBundle)p, b);
        } else {
            this.encodeMessage((OSCMessage)p, b);
        }
    }

    public int getSize(OSCPacket p) throws IOException {
        if (p instanceof OSCBundle) {
            return this.getBundleSize((OSCBundle)p);
        }
        return this.getMessageSize((OSCMessage)p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getBundleSize(OSCBundle bndl) throws IOException {
        List list = bndl.collPackets;
        synchronized (list) {
            int result = bndlIdentifier.length + 8 + (bndl.collPackets.size() << 2);
            for (int i = 0; i < bndl.collPackets.size(); ++i) {
                result += this.getSize((OSCPacket)bndl.collPackets.get(i));
            }
            return result;
        }
    }

    protected int getMessageSize(OSCMessage msg) throws IOException {
        int numArgs = msg.getArgCount();
        int result = (msg.getName().length() + 4 & 0xFFFFFFFC) + (1 + numArgs + 4 & 0xFFFFFFFC);
        for (int i = 0; i < numArgs; ++i) {
            Object o = msg.getArg(i);
            Class<?> cl = o.getClass();
            int j = 0;
            try {
                while (this.atomEncoderC[j] != cl) {
                    ++j;
                }
                result += this.atomEncoderA[j].getAtomSize(o);
                continue;
            }
            catch (NullPointerException e1) {
                throw new OSCException(5, cl.getName());
            }
        }
        return result;
    }

    protected OSCBundle decodeBundle(ByteBuffer b) throws IOException {
        OSCBundle bndl = new OSCBundle();
        int totalLimit = b.limit();
        bndl.setTimeTagRaw(b.getLong());
        try {
            while (b.hasRemaining()) {
                b.limit(b.getInt() + b.position());
                bndl.addPacket(this.decode(b));
                b.limit(totalLimit);
            }
            return bndl;
        }
        catch (IllegalArgumentException e1) {
            throw new OSCException(3, e1.getLocalizedMessage());
        }
    }

    protected OSCMessage decodeMessage(String command, ByteBuffer b) throws IOException {
        byte typ = 0;
        if (b.get() != 44) {
            throw new OSCException(3, null);
        }
        ByteBuffer b2 = b.slice();
        int pos1 = b.position();
        while (b.get() != 0) {
        }
        int numArgs = b.position() - pos1 - 1;
        Object[] args = new Object[numArgs];
        OSCPacketCodec.skipToAlign(b);
        try {
            for (int argIdx = 0; argIdx < numArgs; ++argIdx) {
                typ = b2.get();
                args[argIdx] = this.atomDecoders[typ].decodeAtom(typ, b);
            }
        }
        catch (NullPointerException e1) {
            throw new OSCException(4, String.valueOf((char)typ));
        }
        return new OSCMessage(command, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeBundle(OSCBundle bndl, ByteBuffer b) throws IOException {
        b.put(bndlIdentifier).putLong(bndl.getTimeTag());
        List list = bndl.collPackets;
        synchronized (list) {
            for (int i = 0; i < bndl.collPackets.size(); ++i) {
                b.mark();
                b.putInt(0);
                int pos1 = b.position();
                this.encode((OSCPacket)bndl.collPackets.get(i), b);
                int pos2 = b.position();
                b.reset();
                b.putInt(pos2 - pos1).position(pos2);
            }
        }
    }

    protected void encodeMessage(OSCMessage msg, ByteBuffer b) throws BufferOverflowException, IOException {
        int numArgs = msg.getArgCount();
        Object o = null;
        Class<?> cl = null;
        Atom a = null;
        b.put(msg.getName().getBytes());
        OSCPacketCodec.terminateAndPadToAlign(b);
        ByteBuffer b2 = b.slice();
        b2.put((byte)44);
        b.position(b.position() + (numArgs + 5 & 0xFFFFFFFC));
        try {
            for (int i = 0; i < numArgs; ++i) {
                o = msg.getArg(i);
                cl = o.getClass();
                int j = 0;
                while (this.atomEncoderC[j] != cl) {
                    ++j;
                }
                a = this.atomEncoderA[j];
                a.encodeAtom(o, b2, b);
            }
        }
        catch (NullPointerException e1) {
            throw new OSCException(5, o == null ? "null" : cl.getName());
        }
        OSCPacketCodec.terminateAndPadToAlign(b2);
    }

    public static String readString(ByteBuffer b) {
        int pos = b.position();
        while (b.get() != 0) {
        }
        int len = b.position() - pos;
        byte[] bytes = new byte[len];
        b.position(pos);
        b.get(bytes);
        return new String(bytes, 0, len - 1);
    }

    public static void terminateAndPadToAlign(ByteBuffer b) {
        b.put(pad, 0, 4 - (b.position() & 3));
    }

    public static void padToAlign(ByteBuffer b) {
        b.put(pad, 0, -b.position() & 3);
    }

    public static void skipToValues(ByteBuffer b) throws BufferUnderflowException {
        while (b.get() != 0) {
        }
        b.position(b.position() + 3 & 0xFFFFFFFC);
    }

    public static void skipToAlign(ByteBuffer b) {
        b.position(b.position() + 3 & 0xFFFFFFFC);
    }

    private class PacketAtom
    extends Atom {
        protected PacketAtom() {
        }

        public Object decodeAtom(byte typeTag, ByteBuffer b) throws IOException {
            throw new IOException("Not supported");
        }

        public void encodeAtom(Object o, ByteBuffer tb, ByteBuffer db) throws IOException {
            tb.put((byte)98);
            int pos = db.position();
            int pos2 = pos + 4;
            db.position(pos2);
            OSCPacketCodec.this.encode((OSCPacket)o, db);
            db.putInt(pos, db.position() - pos2);
        }

        public byte getTypeTag(Object o) {
            return 98;
        }

        public int getAtomSize(Object o) throws IOException {
            return OSCPacketCodec.this.getSize((OSCPacket)o) + 4;
        }
    }

    private class BlobAtom
    extends Atom {
        protected BlobAtom() {
        }

        public Object decodeAtom(byte typeTag, ByteBuffer b) throws IOException {
            byte[] blob = new byte[b.getInt()];
            b.get(blob);
            OSCPacketCodec.skipToAlign(b);
            return blob;
        }

        public void encodeAtom(Object o, ByteBuffer tb, ByteBuffer db) throws IOException {
            byte[] blob = (byte[])o;
            tb.put((byte)98);
            db.putInt(blob.length);
            db.put(blob);
            OSCPacketCodec.padToAlign(db);
        }

        public byte getTypeTag(Object o) {
            return 98;
        }

        public int getAtomSize(Object o) throws IOException {
            return ((byte[])o).length + 7 & 0xFFFFFFFC;
        }
    }

    private class StringAtom
    extends Atom {
        protected StringAtom() {
        }

        public Object decodeAtom(byte typeTag, ByteBuffer b) throws IOException {
            int pos1 = b.position();
            while (b.get() != 0) {
            }
            int pos2 = b.position() - 1;
            b.position(pos1);
            int len = pos2 - pos1;
            byte[] bytes = new byte[len];
            b.get(bytes, 0, len);
            String s = new String(bytes, OSCPacketCodec.this.charsetName);
            b.position(pos2 + 4 & 0xFFFFFFFC);
            return s;
        }

        public void encodeAtom(Object o, ByteBuffer tb, ByteBuffer db) throws IOException {
            tb.put((byte)115);
            String s = (String)o;
            db.put(s.getBytes(OSCPacketCodec.this.charsetName));
            OSCPacketCodec.terminateAndPadToAlign(db);
        }

        public byte getTypeTag(Object o) {
            return 115;
        }

        public int getAtomSize(Object o) throws IOException {
            String s = (String)o;
            return s.getBytes(OSCPacketCodec.this.charsetName).length + 4 & 0xFFFFFFFC;
        }
    }

    private class LongAsIntegerAtom
    extends Atom {
        protected LongAsIntegerAtom() {
        }

        public Object decodeAtom(byte typeTag, ByteBuffer b) throws IOException {
            return new Integer((int)b.getLong());
        }

        public void encodeAtom(Object o, ByteBuffer tb, ByteBuffer db) throws IOException {
            tb.put((byte)105);
            db.putInt(((Long)o).intValue());
        }

        public byte getTypeTag(Object o) {
            return 105;
        }

        public int getAtomSize(Object o) throws IOException {
            return 4;
        }
    }

    private class DoubleAsFloatAtom
    extends Atom {
        protected DoubleAsFloatAtom() {
        }

        public Object decodeAtom(byte typeTag, ByteBuffer b) throws IOException {
            return new Float(b.getDouble());
        }

        public void encodeAtom(Object o, ByteBuffer tb, ByteBuffer db) throws IOException {
            tb.put((byte)102);
            db.putFloat(((Double)o).floatValue());
        }

        public byte getTypeTag(Object o) {
            return 102;
        }

        public int getAtomSize(Object o) throws IOException {
            return 4;
        }
    }

    private class DoubleAtom
    extends Atom {
        protected DoubleAtom() {
        }

        public Object decodeAtom(byte typeTag, ByteBuffer b) throws IOException {
            return new Double(b.getDouble());
        }

        public void encodeAtom(Object o, ByteBuffer tb, ByteBuffer db) throws IOException {
            tb.put((byte)100);
            db.putDouble((Double)o);
        }

        public byte getTypeTag(Object o) {
            return 100;
        }

        public int getAtomSize(Object o) throws IOException {
            return 8;
        }
    }

    private class LongAtom
    extends Atom {
        protected LongAtom() {
        }

        public Object decodeAtom(byte typeTag, ByteBuffer b) throws IOException {
            return new Long(b.getLong());
        }

        public void encodeAtom(Object o, ByteBuffer tb, ByteBuffer db) throws IOException {
            tb.put((byte)104);
            db.putLong((Long)o);
        }

        public byte getTypeTag(Object o) {
            return 104;
        }

        public int getAtomSize(Object o) throws IOException {
            return 8;
        }
    }

    private class FloatAtom
    extends Atom {
        protected FloatAtom() {
        }

        public Object decodeAtom(byte typeTag, ByteBuffer b) throws IOException {
            return new Float(b.getFloat());
        }

        public void encodeAtom(Object o, ByteBuffer tb, ByteBuffer db) throws IOException {
            tb.put((byte)102);
            db.putFloat(((Float)o).floatValue());
        }

        public byte getTypeTag(Object o) {
            return 102;
        }

        public int getAtomSize(Object o) throws IOException {
            return 4;
        }
    }

    private class IntegerAtom
    extends Atom {
        protected IntegerAtom() {
        }

        public Object decodeAtom(byte typeTag, ByteBuffer b) throws IOException {
            return new Integer(b.getInt());
        }

        public void encodeAtom(Object o, ByteBuffer tb, ByteBuffer db) throws IOException {
            tb.put((byte)105);
            db.putInt((Integer)o);
        }

        public byte getTypeTag(Object o) {
            return 105;
        }

        public int getAtomSize(Object o) throws IOException {
            return 4;
        }
    }

    public static abstract class Atom {
        public abstract Object decodeAtom(byte var1, ByteBuffer var2) throws IOException;

        public abstract void encodeAtom(Object var1, ByteBuffer var2, ByteBuffer var3) throws IOException;

        public abstract byte getTypeTag(Object var1);

        public abstract int getAtomSize(Object var1) throws IOException;
    }
}

