/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import tcl.lang.ChannelBuffer;
import tcl.lang.EncodingCmd;
import tcl.lang.TclByteArray;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class TclInputStream {
    private InputStream input;
    private char eofChar;
    private boolean eofCond = false;
    private boolean stickyEofCond = false;
    protected int translation;
    protected String encoding;
    protected ByteToCharConverter btc = null;
    protected int buffering;
    protected boolean blocking;
    protected boolean blocked = false;
    protected int bufSize;
    protected boolean needNL = false;
    protected boolean sawCR = false;
    protected boolean needMoreData = false;
    Object encodingState = null;
    boolean encodingStart = true;
    boolean encodingEnd = false;
    ChannelBuffer inQueueHead = null;
    ChannelBuffer inQueueTail = null;
    ChannelBuffer saveInBuf = null;
    private final int TCL_CONVERT_MULTIBYTE = -1;
    private final int TCL_CONVERT_SYNTAX = -2;
    private final int TCL_CONVERT_UNKNOWN = -3;
    private final int TCL_CONVERT_NOSPACE = -4;

    TclInputStream(InputStream inInput) {
        this.input = inInput;
    }

    /*
     * Enabled aggressive block sorting
     */
    int getsObj(TclObject obj) {
        int dst;
        boolean in_binary_encoding = false;
        boolean debug = false;
        ChannelBuffer buf = this.inQueueHead;
        int oldLength = 0;
        boolean oldEncodingStart = this.encodingStart;
        boolean oldEncodingEnd = this.encodingEnd;
        Object oldState = this.encodingState;
        int oldRemoved = 16;
        if (buf != null) {
            oldRemoved = buf.nextRemoved;
        }
        if (this.encoding == null) {
            in_binary_encoding = true;
            this.encoding = EncodingCmd.getJavaName("iso8859-1");
        }
        GetsState gs = new GetsState();
        gs.obj = obj;
        gs.encoding = this.encoding;
        gs.buf = buf;
        gs.state = oldState;
        gs.rawRead.i = 0;
        gs.charsWrote.i = 0;
        gs.totalChars = 0;
        TclString.empty((TclObject)obj);
        StringBuffer obj_sbuf = ((TclString)obj.getInternalRep()).sbuf;
        int dstEnd = dst = 0;
        int skip = 0;
        int eof = -1;
        char inEofChar = this.eofChar;
        boolean restore = false;
        boolean goteol = false;
        int eol = -1;
        int copiedTotal = -1;
        block6: while (true) {
            if (dst >= dstEnd) {
                if (this.filterBytes(gs) != 0) {
                    restore = true;
                    break;
                }
                dstEnd += gs.charsWrote.i;
            }
            if (inEofChar != '\u0000') {
                for (eol = dst; eol < dstEnd; ++eol) {
                    if (obj_sbuf.charAt(eol) != inEofChar) continue;
                    dstEnd = eol;
                    eof = eol;
                    break;
                }
            }
            switch (this.translation) {
                case 2: {
                    for (eol = dst; eol < dstEnd; ++eol) {
                        if (obj_sbuf.charAt(eol) != '\n') continue;
                        skip = 1;
                        goteol = true;
                        break block6;
                    }
                    break;
                }
                case 3: {
                    for (eol = dst; eol < dstEnd; ++eol) {
                        if (obj_sbuf.charAt(eol) != '\r') continue;
                        skip = 1;
                        goteol = true;
                        break block6;
                    }
                    break;
                }
                case 4: {
                    for (eol = dst; eol < dstEnd; ++eol) {
                        if (obj_sbuf.charAt(eol) != '\r') continue;
                        if (++eol >= dstEnd) {
                            dst = dstEnd;
                            if (this.filterBytes(gs) != 0) {
                                restore = true;
                                break block6;
                            }
                            if (eol >= (dstEnd += gs.charsWrote.i)) {
                                skip = 0;
                                goteol = true;
                                break block6;
                            }
                        }
                        if (obj_sbuf.charAt(eol) != '\n') continue;
                        --eol;
                        skip = 2;
                        goteol = true;
                        break block6;
                    }
                    break;
                }
                case 0: {
                    eol = dst;
                    skip = 1;
                    if (this.sawCR) {
                        this.sawCR = false;
                        if (eol < dstEnd && obj_sbuf.charAt(eol) == '\n') {
                            char[] tmp = new char[1];
                            IntPtr rawRead = new IntPtr();
                            buf = gs.buf;
                            this.externalToUnicode(buf.buf, buf.nextRemoved, gs.rawRead.i, tmp, 0, 1, rawRead, null, null);
                            buf.nextRemoved += rawRead.i;
                            gs.rawRead.i -= rawRead.i;
                            --gs.charsWrote.i;
                            obj_sbuf.deleteCharAt(dst);
                            --dstEnd;
                        }
                    }
                    for (eol = dst; eol < dstEnd; ++eol) {
                        if (obj_sbuf.charAt(eol) == '\r') {
                            if (++eol == dstEnd) {
                                dst = dstEnd;
                                this.peekAhead(gs);
                                if (eol >= (dstEnd += gs.charsWrote.i)) {
                                    --eol;
                                    this.sawCR = true;
                                    goteol = true;
                                    break block6;
                                }
                            }
                            if (obj_sbuf.charAt(eol) == '\n') {
                                ++skip;
                            }
                            --eol;
                            goteol = true;
                            break block6;
                        }
                        if (obj_sbuf.charAt(eol) != '\n') continue;
                        goteol = true;
                        break block6;
                    }
                }
            }
            if (eof != -1) {
                dstEnd = eof;
                this.eofCond = true;
                this.stickyEofCond = true;
                this.encodingEnd = true;
            }
            if (this.eofCond) {
                skip = 0;
                eol = dstEnd;
                if (eol == oldLength) {
                    obj_sbuf.setLength(oldLength);
                    this.commonGetsCleanup();
                    copiedTotal = -1;
                    break;
                }
                goteol = true;
                break;
            }
            dst = dstEnd;
        }
        if (goteol) {
            int linelen = eol - dst + skip;
            char[] tmp = new char[linelen];
            buf = gs.buf;
            this.encodingState = gs.state;
            if (this.btc != null) {
                this.btc.reset();
            }
            this.externalToUnicode(buf.buf, buf.nextRemoved, gs.rawRead.i, tmp, 0, linelen, gs.rawRead, null, gs.charsWrote);
            buf.nextRemoved += gs.rawRead.i;
            obj_sbuf.setLength(eol);
            this.commonGetsCleanup();
            this.blocked = false;
            copiedTotal = gs.totalChars + gs.charsWrote.i - skip;
        }
        if (restore) {
            buf = this.inQueueHead;
            buf.nextRemoved = oldRemoved;
            buf = buf.next;
            while (buf != null) {
                buf.nextRemoved = 16;
                buf = buf.next;
            }
            this.commonGetsCleanup();
            this.encodingState = oldState;
            this.encodingStart = oldEncodingStart;
            this.encodingEnd = oldEncodingEnd;
            obj_sbuf.setLength(oldLength);
            this.needMoreData = true;
            copiedTotal = -1;
        }
        if (in_binary_encoding) {
            this.encoding = null;
        }
        this.updateInterest();
        return copiedTotal;
    }

    int filterBytes(GetsState gs) {
        ChannelBuffer buf;
        block13: {
            ChannelBuffer next;
            int rawLen;
            byte[] raw;
            int ENCODING_LINESIZE = 20;
            boolean goto_read = false;
            TclObject obj = gs.obj;
            buf = gs.buf;
            if (buf != null) {
                buf.nextRemoved += gs.rawRead.i;
                if (buf.nextRemoved >= buf.nextAdded) {
                    buf = buf.next;
                }
            }
            gs.totalChars += gs.charsWrote.i;
            while (true) {
                block15: {
                    block14: {
                        if (goto_read || buf == null) break block14;
                        if (buf.nextAdded != 16) break block15;
                    }
                    if (this.blocked) {
                        if (!this.blocking) {
                            gs.charsWrote.i = 0;
                            gs.rawRead.i = 0;
                            return -1;
                        }
                        this.blocked = false;
                    }
                    if (this.getInput() != 0) {
                        gs.charsWrote.i = 0;
                        gs.rawRead.i = 0;
                        return -1;
                    }
                    gs.buf = buf = this.inQueueTail;
                }
                int rawStart = buf.nextRemoved;
                raw = buf.buf;
                int toRead = 20;
                int rawEnd = buf.nextAdded;
                rawLen = rawEnd - rawStart;
                if (toRead > rawLen) {
                    toRead = rawLen;
                }
                char[] dst = new char[toRead];
                gs.state = this.encodingState;
                int result = this.externalToUnicode(raw, rawStart, rawLen, dst, 0, toRead, gs.rawRead, null, gs.charsWrote);
                TclString.append((TclObject)gs.obj, (char[])dst, (int)0, (int)gs.charsWrote.i);
                this.encodingStart = false;
                if (result != -1) break block13;
                next = buf.next;
                if (buf.nextAdded >= buf.bufLength) break;
                if (gs.rawRead.i > 0) break block13;
                if (this.eofCond) {
                    buf.nextRemoved = buf.nextAdded;
                    break block13;
                }
                goto_read = true;
            }
            if (next == null) {
                buf.next = next = new ChannelBuffer(this.bufSize);
                this.inQueueTail = next;
            }
            int extra = rawLen - gs.rawRead.i;
            System.arraycopy(raw, gs.rawRead.i, next.buf, 16 - extra, extra);
            next.nextRemoved -= extra;
            buf.nextAdded -= extra;
        }
        gs.buf = buf;
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    void peekAhead(GetsState gs) {
        goto_cleanup = false;
        buf = gs.buf;
        if (buf.next != null || (bytesLeft = buf.nextAdded - (buf.nextRemoved + gs.rawRead.i)) != 0) ** GOTO lbl9
        if (buf.nextAdded < buf.bufLength) {
            goto_cleanup = true;
        } else {
            if (this.blocking) {
                // empty if block
            }
lbl9:
            // 4 sources

            this.filterBytes(gs);
        }
        if (goto_cleanup) {
            buf.nextRemoved += gs.rawRead.i;
            gs.rawRead.i = 0;
            gs.totalChars += gs.charsWrote.i;
            gs.charsWrote.i = 0;
        }
    }

    void commonGetsCleanup() {
        ChannelBuffer next;
        ChannelBuffer buf = this.inQueueHead;
        while (buf != null) {
            next = buf.next;
            if (buf.nextRemoved < buf.nextAdded) break;
            this.recycleBuffer(buf, false);
            buf = next;
        }
        this.inQueueHead = buf;
        if (buf == null) {
            this.inQueueTail = null;
        } else {
            next = buf.next;
            while (next != null) {
                int extra = buf.bufLength - buf.nextAdded;
                if (extra > 0) {
                    System.arraycopy(next.buf, 16 - extra, buf.buf, buf.nextAdded, extra);
                    buf.nextAdded += extra;
                    next.nextRemoved = 16;
                }
                buf = next;
                next = buf.next;
            }
        }
        if (this.encoding != null) {
            // empty if block
        }
    }

    void close() throws IOException {
        this.discardQueued(true);
    }

    boolean eof() {
        return this.eofCond;
    }

    void setEncoding(String inEncoding) {
        this.encoding = inEncoding;
    }

    void setEofChar(char inEofChar) {
        this.eofChar = inEofChar;
    }

    void setTranslation(int inTranslation) {
        this.translation = inTranslation;
    }

    void setBuffering(int inBuffering) {
        this.buffering = inBuffering;
    }

    void setBufferSize(int inBufSize) {
        this.bufSize = inBufSize;
    }

    void setBlocking(boolean inBlocking) {
        this.blocking = inBlocking;
    }

    boolean isBlocked() {
        return this.blocked;
    }

    boolean sawCR() {
        return this.sawCR;
    }

    int doReadChars(TclObject obj, int toRead) throws IOException {
        int copied;
        block10: {
            boolean debug = false;
            IntPtr offset = new IntPtr();
            if (this.encoding == null) {
                TclByteArray.setLength(null, obj, 0);
            } else {
                TclString.empty((TclObject)obj);
            }
            offset.i = 0;
            if (toRead < 0) {
                toRead = Integer.MAX_VALUE;
            }
            copied = 0;
            while (toRead > 0) {
                int copiedNow = -1;
                if (this.inQueueHead != null) {
                    copiedNow = this.encoding == null ? this.readBytes(obj, toRead, offset) : this.readChars(obj, toRead);
                    ChannelBuffer buf = this.inQueueHead;
                    if (buf.nextRemoved == buf.nextAdded) {
                        ChannelBuffer next = buf.next;
                        this.recycleBuffer(buf, false);
                        this.inQueueHead = next;
                        if (next == null) {
                            this.inQueueTail = null;
                        }
                    }
                }
                if (copiedNow < 0) {
                    int result;
                    if (this.eofCond) break;
                    if (this.blocked) {
                        if (!this.blocking) break;
                        this.blocked = false;
                    }
                    if ((result = this.getInput()) == 0) continue;
                    if (result == 35) break;
                    copied = -1;
                    break block10;
                }
                copied += copiedNow;
                toRead -= copiedNow;
            }
            this.blocked = false;
            if (this.encoding == null) {
                TclByteArray.setLength(null, obj, offset.i);
            }
        }
        this.updateInterest();
        return copied;
    }

    int readBytes(TclObject obj, int bytesToRead, IntPtr offsetPtr) {
        IntPtr srcRead;
        IntPtr dstWrote;
        boolean debug = false;
        int offset = offsetPtr.i;
        ChannelBuffer buf = this.inQueueHead;
        byte[] src = buf.buf;
        int srcOff = buf.nextRemoved;
        int toRead = bytesToRead;
        int srcLen = buf.nextAdded - buf.nextRemoved;
        if (toRead > srcLen) {
            toRead = srcLen;
        }
        int length = TclByteArray.getLength(null, obj);
        byte[] dst = TclByteArray.getBytes(null, obj);
        if (toRead > length - offset - 1) {
            length = offset * 2;
            if (offset < toRead) {
                length = offset + toRead + 1;
            }
            dst = TclByteArray.setLength(null, obj, length);
        }
        if (this.needNL) {
            this.needNL = false;
            if (srcLen == 0 || src[srcOff] != 10) {
                dst[offset] = 13;
                ++offsetPtr.i;
                return 1;
            }
            dst[offset++] = 10;
            ++srcOff;
            --srcLen;
            --toRead;
        }
        if (this.translateEOL(dst, offset, src, srcOff, dstWrote = new IntPtr(toRead), srcRead = new IntPtr(srcLen)) != 0 && dstWrote.i == 0) {
            return -1;
        }
        buf.nextRemoved += srcRead.i;
        offsetPtr.i += dstWrote.i;
        return dstWrote.i;
    }

    int readChars(TclObject obj, int charsToRead) throws IOException {
        IntPtr srcRead = new IntPtr();
        IntPtr numChars = new IntPtr();
        IntPtr dstRead = new IntPtr();
        IntPtr dstWrote = new IntPtr();
        ChannelBuffer buf = this.inQueueHead;
        byte[] src = buf.buf;
        int srcOff = buf.nextRemoved;
        int srcLen = buf.nextAdded - buf.nextRemoved;
        if (srcLen == 0) {
            if (this.needNL) {
                TclString.append((TclObject)obj, (String)"\r");
                return 1;
            }
            return -1;
        }
        int toRead = charsToRead;
        if (toRead > srcLen) {
            toRead = srcLen;
        }
        int dstNeeded = toRead;
        char[] dst = new char[dstNeeded];
        int dstOff = 0;
        Object oldState = this.encodingState;
        if (this.needNL) {
            this.needNL = false;
            this.externalToUnicode(src, srcOff, srcLen, dst, dstOff, 1, srcRead, dstWrote, numChars);
            if (numChars.i > 0 && dst[dstOff] == '\n') {
                buf.nextRemoved += srcRead.i;
            } else {
                dst[dstOff] = 13;
            }
            this.encodingStart = false;
            TclString.append((TclObject)obj, (char[])dst, (int)dstOff, (int)1);
            return 1;
        }
        this.externalToUnicode(src, srcOff, srcLen, dst, dstOff, dstNeeded, srcRead, dstWrote, numChars);
        dstRead.i = dstWrote.i;
        if (this.translateEOL(dst, dstOff, dst, dstOff, dstWrote, dstRead) != 0) {
            if (dstWrote.i == 0) {
                return -1;
            }
            this.encodingState = oldState;
            if (this.btc != null) {
                this.btc.reset();
            }
            this.externalToUnicode(src, srcOff, srcLen, dst, dstOff, dstRead.i, srcRead, dstWrote, numChars);
            this.translateEOL(dst, dstOff, dst, dstOff, dstWrote, dstRead);
        }
        numChars.i -= dstRead.i - dstWrote.i;
        if (numChars.i > toRead) {
            int eof = toRead;
            this.encodingState = oldState;
            if (this.btc != null) {
                this.btc.reset();
            }
            this.externalToUnicode(src, srcOff, srcLen, dst, dstOff, eof - dstOff, srcRead, dstWrote, numChars);
            dstRead.i = dstWrote.i;
            this.translateEOL(dst, dstOff, dst, dstOff, dstWrote, dstRead);
            numChars.i -= dstRead.i - dstWrote.i;
        }
        this.encodingStart = false;
        buf.nextRemoved += srcRead.i;
        TclString.append((TclObject)obj, (char[])dst, (int)dstOff, (int)numChars.i);
        return numChars.i;
    }

    /*
     * WARNING - void declaration
     */
    int externalToUnicode(byte[] src, int srcOff, int srcLen, char[] dst, int dstOff, int dstLen, IntPtr srcReadPtr, IntPtr dstWrotePtr, IntPtr dstCharsPtr) {
        void var14_14;
        void var13_13;
        int chars_written;
        int bytes_read;
        boolean debug = false;
        String encoding = this.encoding;
        if (encoding == null) {
            throw new TclRuntimeError("externalToUnicode called with null encoding");
        }
        if (srcLen == 0) {
            srcReadPtr.i = 0;
            if (dstWrotePtr != null) {
                dstWrotePtr.i = 0;
            }
            if (dstCharsPtr != null) {
                dstCharsPtr.i = 0;
            }
            return 0;
        }
        if (this.btc == null) {
            try {
                this.btc = ByteToCharConverter.getConverter((String)encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new TclRuntimeError("unsupported encoding \"" + encoding + "\"");
            }
        }
        try {
            this.btc.convert(src, srcOff, srcOff + srcLen, dst, dstOff, dstOff + dstLen);
            bytes_read = this.btc.nextByteIndex() - srcOff;
            chars_written = this.btc.nextCharIndex() - dstOff;
        }
        catch (ConversionBufferFullException ex) {
            bytes_read = this.btc.nextByteIndex() - srcOff;
            chars_written = this.btc.nextCharIndex() - dstOff;
        }
        catch (MalformedInputException ex) {
            throw new TclRuntimeError("MalformedInputException");
        }
        catch (UnknownCharacterException ex) {
            throw new TclRuntimeError("UnknownCharacterException");
        }
        srcReadPtr.i = var13_13;
        if (dstWrotePtr != null) {
            dstWrotePtr.i = var14_14;
        }
        if (dstCharsPtr != null) {
            dstCharsPtr.i = var14_14;
        }
        int result = 0;
        return result;
    }

    private int getInput() {
        int nread;
        int toRead;
        boolean debug = false;
        ChannelBuffer buf = this.inQueueTail;
        if (buf != null && buf.nextAdded < buf.bufLength) {
            toRead = buf.bufLength - buf.nextAdded;
        } else {
            buf = this.saveInBuf;
            this.saveInBuf = null;
            if (buf != null) {
                if (buf.bufLength - 16 < this.bufSize) {
                    buf = null;
                }
            }
            if (buf == null) {
                buf = new ChannelBuffer(this.bufSize);
            }
            buf.next = null;
            toRead = buf.bufLength - buf.nextAdded;
            if (this.inQueueTail == null) {
                this.inQueueHead = buf;
            } else {
                this.inQueueTail.next = buf;
            }
            this.inQueueTail = buf;
        }
        if (this.eofCond) {
            return 0;
        }
        if (!this.blocking) {
            return 35;
        }
        int result = 0;
        int numAvailable = 0;
        if (!this.blocking && numAvailable < toRead) {
            result = 35;
            nread = -1;
        } else {
            try {
                nread = this.input.read(buf.buf, buf.nextAdded, toRead);
                if (nread == -1) {
                    nread = 0;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                nread = -1;
            }
        }
        if (nread > 0) {
            buf.nextAdded += nread;
            if (nread < toRead) {
                this.blocked = true;
            }
        } else if (nread == 0) {
            this.eofCond = true;
            this.encodingEnd = true;
        } else if (nread < 0) {
            if (result == 35 || result == 35) {
                this.blocked = true;
                result = 35;
            }
            return result;
        }
        return 0;
    }

    private void recycleBuffer(ChannelBuffer buf, boolean mustDiscard) {
        if (mustDiscard) {
            return;
        }
        if (buf.bufLength - 16 < this.bufSize) {
            return;
        }
        if (this.inQueueHead == null) {
            this.inQueueHead = buf;
            this.inQueueTail = buf;
            buf.nextRemoved = 16;
            buf.nextAdded = 16;
            buf.next = null;
            return;
        }
        if (this.saveInBuf == null) {
            this.saveInBuf = buf;
            buf.nextRemoved = 16;
            buf.nextAdded = 16;
            buf.next = null;
            return;
        }
    }

    private void discardQueued(boolean discardSavedBuffers) {
        ChannelBuffer buf = this.inQueueHead;
        this.inQueueHead = null;
        this.inQueueTail = null;
        while (buf != null) {
            ChannelBuffer nxt = buf.next;
            this.recycleBuffer(buf, discardSavedBuffers);
            buf = nxt;
        }
        if (discardSavedBuffers && this.saveInBuf != null) {
            this.saveInBuf = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    int translateEOL(Object dstArray, int dstStart, Object srcArray, int srcStart, IntPtr dstLenPtr, IntPtr srcLenPtr) {
        void var14_19;
        int srcLen;
        void index;
        void var11_11;
        void var9_9;
        void var8_8;
        byte[] dstArrayByte;
        byte[] srcArrayByte;
        char[] dstArrayChar;
        char[] srcArrayChar;
        boolean isCharType;
        boolean debug = false;
        if (srcArray instanceof char[] && dstArray instanceof char[]) {
            isCharType = true;
            srcArrayChar = (char[])srcArray;
            dstArrayChar = (char[])dstArray;
            srcArrayByte = null;
            dstArrayByte = null;
        } else if (srcArray instanceof byte[] && dstArray instanceof byte[]) {
            isCharType = false;
            srcArrayChar = null;
            dstArrayChar = null;
            srcArrayByte = (byte[])srcArray;
            dstArrayByte = (byte[])dstArray;
        } else {
            throw new TclRuntimeError("unknown array argument types");
        }
        int dstLen = dstLenPtr.i;
        int eof = -1;
        char inEofChar = this.eofChar;
        if (inEofChar != '\u0000') {
            int srcMax = srcStart + srcLenPtr.i;
            for (int src = srcStart; src < srcMax; ++src) {
                index = var8_8 != false ? var9_9[src] : var11_11[src];
                if (index != inEofChar) continue;
                eof = src;
                srcLen = src - srcStart;
                if (srcLen < dstLen) {
                    dstLen = srcLen;
                }
                srcLenPtr.i = srcLen;
                break;
            }
        }
        switch (this.translation) {
            case 2: {
                if (dstArray != srcArray || dstArray == srcArray && dstStart != srcStart) {
                    System.arraycopy(srcArray, srcStart, dstArray, dstStart, dstLen);
                }
                srcLen = dstLen;
                break;
            }
            case 3: {
                int dst;
                if (dstArray != srcArray || dstArray == srcArray && dstStart != srcStart) {
                    System.arraycopy(srcArray, srcStart, dstArray, dstStart, dstLen);
                }
                int dstEnd = dstStart + dstLen;
                if (var8_8 != false) {
                    for (dst = dstStart; dst < dstEnd; ++dst) {
                        void var10_10;
                        if (var10_10[dst] != 13) continue;
                        var10_10[dst] = 10;
                    }
                } else {
                    for (dst = dstStart; dst < dstEnd; ++dst) {
                        void var12_12;
                        if (var12_12[dst] != 13) continue;
                        var12_12[dst] = 10;
                    }
                }
                srcLen = dstLen;
                break;
            }
            case 4: {
                int dst = dstStart;
                int src = srcStart;
                int srcEnd = srcStart + dstLen;
                int srcMax = srcStart + srcLenPtr.i;
                if (var8_8 != false) {
                    while (src < srcEnd) {
                        if (var9_9[src] == 13) {
                            if (++src >= srcMax) {
                                this.needNL = true;
                                continue;
                            }
                            if (var9_9[src] == 10) {
                                var10_10[dst++] = var9_9[src++];
                                continue;
                            }
                            var10_10[dst++] = 13;
                            continue;
                        }
                        var10_10[dst++] = var9_9[src++];
                    }
                } else {
                    while (src < srcEnd) {
                        if (var11_11[src] == 13) {
                            if (++src >= srcMax) {
                                this.needNL = true;
                                continue;
                            }
                            if (var11_11[src] == 10) {
                                var12_12[dst++] = var11_11[src++];
                                continue;
                            }
                            var12_12[dst++] = 13;
                            continue;
                        }
                        var12_12[dst++] = var11_11[src++];
                    }
                }
                srcLen = src - srcStart;
                dstLen = dst - dstStart;
                break;
            }
            case 0: {
                int dst = dstStart;
                int src = srcStart;
                int srcEnd = srcStart + dstLen;
                int srcMax = srcStart + srcLenPtr.i;
                if (this.sawCR && src < srcMax) {
                    index = var8_8 != false ? var9_9[src] : var11_11[src];
                    if (index == 10) {
                        ++src;
                    }
                    this.sawCR = false;
                }
                if (var8_8 != false) {
                    while (src < srcEnd) {
                        if (var9_9[src] == 13) {
                            if (++src >= srcMax) {
                                this.sawCR = true;
                            } else if (var9_9[src] == 10) {
                                if (srcEnd < srcMax) {
                                    ++srcEnd;
                                }
                                ++src;
                            }
                            var10_10[dst++] = 10;
                            continue;
                        }
                        var10_10[dst++] = var9_9[src++];
                    }
                } else {
                    while (src < srcEnd) {
                        if (var11_11[src] == 13) {
                            if (++src >= srcMax) {
                                this.sawCR = true;
                            } else if (var11_11[src] == 10) {
                                if (srcEnd < srcMax) {
                                    ++srcEnd;
                                }
                                ++src;
                            }
                            var12_12[dst++] = 10;
                            continue;
                        }
                        var12_12[dst++] = var11_11[src++];
                    }
                }
                srcLen = src - srcStart;
                dstLen = dst - dstStart;
                break;
            }
            default: {
                throw new TclRuntimeError("invalid translation");
            }
        }
        dstLenPtr.i = dstLen;
        if (eof != -1 && srcStart + var14_19 >= eof) {
            this.eofCond = true;
            this.stickyEofCond = true;
            this.encodingEnd = true;
            this.sawCR = false;
            this.needNL = false;
            return 1;
        }
        srcLenPtr.i = var14_19;
        return 0;
    }

    void updateInterest() {
    }

    int getNumBufferedBytes() {
        int IOQueued = 0;
        ChannelBuffer buf = this.inQueueHead;
        while (buf != null) {
            IOQueued += buf.nextAdded - buf.nextRemoved;
            buf = buf.next;
        }
        return IOQueued;
    }

    void seekReset() {
        this.discardQueued(false);
        this.eofCond = false;
        this.stickyEofCond = false;
        this.blocked = false;
        this.sawCR = false;
    }

    private class IntPtr {
        int i;

        IntPtr() {
        }

        IntPtr(int value) {
            this.i = value;
        }
    }

    private class GetsState {
        TclObject obj;
        String encoding;
        ChannelBuffer buf;
        Object state;
        IntPtr rawRead;
        IntPtr charsWrote;
        int totalChars;

        private GetsState() {
            this.rawRead = new IntPtr();
            this.charsWrote = new IntPtr();
        }
    }
}

