/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import tcl.lang.AcceptThread;
import tcl.lang.Channel;
import tcl.lang.Interp;
import tcl.lang.SocketChannel;
import tcl.lang.SocketConnectionEvent;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;

public class ServerSocketChannel
extends Channel {
    private ServerSocket sock;
    private Interp cbInterp;
    private TclObject callback;
    private AcceptThread acceptThread;

    public ServerSocketChannel(Interp interp, String localAddr, int port, TclObject callback) throws TclException {
        InetAddress localAddress = null;
        if (!localAddr.equals("")) {
            try {
                localAddress = InetAddress.getByName(localAddr);
            }
            catch (UnknownHostException e) {
                throw new TclException(interp, "host unkown: " + localAddr);
            }
        }
        this.mode = 16;
        this.callback = callback;
        this.cbInterp = interp;
        try {
            this.sock = localAddress == null ? new ServerSocket(port) : new ServerSocket(port, 0, localAddress);
        }
        catch (IOException ex) {
            throw new TclException(interp, ex.getMessage());
        }
        this.acceptThread = new AcceptThread(this.sock, this);
        this.setChanName(TclIO.getNextDescriptor(interp, "sock"));
        this.acceptThread.start();
    }

    synchronized void addConnection(Socket s) {
        SocketChannel sChan = null;
        try {
            sChan = new SocketChannel(this.cbInterp, s);
            TclIO.registerChannel(this.cbInterp, sChan);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SocketConnectionEvent evt = new SocketConnectionEvent(this.cbInterp, this.callback, sChan.getChanName(), s.getInetAddress().getHostAddress(), s.getPort());
        this.cbInterp.getNotifier().queueEvent(evt, 0);
    }

    void close() throws IOException {
        this.acceptThread.pleaseStop();
        super.close();
        this.sock.close();
    }

    void seek(Interp interp, long offset, int mode) throws IOException, TclException {
        throw new TclPosixException(interp, 13, true, "error during seek on \"" + this.getChanName() + "\"");
    }

    String getChanType() {
        return "tcp";
    }

    protected InputStream getInputStream() throws IOException {
        throw new RuntimeException("should never be called");
    }

    protected OutputStream getOutputStream() throws IOException {
        throw new RuntimeException("should never be called");
    }
}

